/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.intermediate.filters;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.List;
import org.xbib.graphics.chart.io.vector.intermediate.commands.Command;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DisposeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.DrawImageCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.FillShapeCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetPaintCommand;
import org.xbib.graphics.chart.io.vector.intermediate.filters.Filter;

public class FillPaintedShapeAsImageFilter
extends Filter {
    private SetPaintCommand lastSetPaintCommand;

    public FillPaintedShapeAsImageFilter(Iterable<Command<?>> stream) {
        super(stream);
    }

    @Override
    public Command<?> next() {
        Object nextCommand = super.next();
        if (nextCommand instanceof SetPaintCommand) {
            this.lastSetPaintCommand = (SetPaintCommand)nextCommand;
        } else if (nextCommand instanceof DisposeCommand) {
            this.lastSetPaintCommand = null;
        }
        return nextCommand;
    }

    private DrawImageCommand getDrawImageCommand(FillShapeCommand shapeCommand, SetPaintCommand paintCommand) {
        Shape shape = (Shape)shapeCommand.getValue();
        Rectangle2D shapeBounds = shape.getBounds2D();
        double x = shapeBounds.getX();
        double y = shapeBounds.getY();
        double width = shapeBounds.getWidth();
        double height = shapeBounds.getHeight();
        int imageWidth = (int)Math.round(width);
        int imageHeight = (int)Math.round(height);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, 2);
        Graphics2D imageGraphics = (Graphics2D)image.getGraphics();
        imageGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        imageGraphics.scale((double)imageWidth / width, (double)imageHeight / height);
        imageGraphics.translate(-shapeBounds.getX(), -shapeBounds.getY());
        imageGraphics.setPaint((Paint)paintCommand.getValue());
        imageGraphics.fill(shape);
        imageGraphics.dispose();
        DrawImageCommand drawImageCommand = new DrawImageCommand(image, imageWidth, imageHeight, x, y, width, height);
        return drawImageCommand;
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (this.lastSetPaintCommand != null && command instanceof FillShapeCommand) {
            FillShapeCommand fillShapeCommand = (FillShapeCommand)command;
            DrawImageCommand drawImageCommand = this.getDrawImageCommand(fillShapeCommand, this.lastSetPaintCommand);
            return Arrays.asList(drawImageCommand);
        }
        return Arrays.asList(command);
    }
}

