/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.intermediate.filters;

import java.util.Arrays;
import java.util.List;
import org.xbib.graphics.chart.io.vector.intermediate.commands.Command;
import org.xbib.graphics.chart.io.vector.intermediate.commands.Group;
import org.xbib.graphics.chart.io.vector.intermediate.filters.Filter;

public abstract class GroupingFilter
extends Filter {
    private Group group;

    public GroupingFilter(Iterable<Command<?>> stream) {
        super(stream);
    }

    @Override
    public boolean hasNext() {
        return this.group != null || super.hasNext();
    }

    @Override
    public Command<?> next() {
        if (this.group == null) {
            return super.next();
        }
        Group g = this.group;
        this.group = null;
        return g;
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        boolean grouped = this.isGrouped(command);
        if (grouped) {
            if (this.group == null) {
                this.group = new Group();
            }
            this.group.add(command);
            return null;
        }
        return Arrays.asList(command);
    }

    protected abstract boolean isGrouped(Command<?> var1);
}

