/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.intermediate.filters;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.xbib.graphics.chart.io.vector.intermediate.commands.AffineTransformCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.Command;
import org.xbib.graphics.chart.io.vector.intermediate.commands.SetHintCommand;
import org.xbib.graphics.chart.io.vector.intermediate.commands.StateCommand;
import org.xbib.graphics.chart.io.vector.intermediate.filters.Filter;

public class OptimizeFilter
extends Filter {
    private final Queue<Command<?>> buffer = new LinkedList();

    public OptimizeFilter(Iterable<Command<?>> stream) {
        super(stream);
    }

    private static boolean isStateChange(Command<?> command) {
        return command instanceof StateCommand && !(command instanceof AffineTransformCommand) && !(command instanceof SetHintCommand);
    }

    @Override
    public boolean hasNext() {
        return super.hasNext();
    }

    @Override
    public Command<?> next() {
        if (this.buffer.isEmpty()) {
            return super.next();
        }
        return this.buffer.poll();
    }

    @Override
    protected List<Command<?>> filter(Command<?> command) {
        if (!OptimizeFilter.isStateChange(command)) {
            return Arrays.asList(command);
        }
        Iterator i = this.buffer.iterator();
        Class<?> cls = command.getClass();
        while (i.hasNext()) {
            if (!cls.equals(((Command)i.next()).getClass())) continue;
            i.remove();
        }
        this.buffer.add(command);
        return null;
    }
}

