/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Arrays;

public class ASCII85EncodeStream
extends FilterOutputStream {
    private static final Charset ISO88591 = Charset.forName("ISO-8859-1");
    private static final int BASE = 85;
    private static final int[] POW_85 = new int[]{52200625, 614125, 7225, 85, 1};
    private static final char[] CHAR_MAP = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstu".toCharArray();
    private final byte[] data;
    private final byte[] prefixBytes;
    private final byte[] suffixBytes;
    private final byte[] encoded;
    private boolean closed;
    private int dataSize;
    private boolean prefixDone;

    public ASCII85EncodeStream(OutputStream out, String prefix, String suffix) {
        super(out);
        this.prefixBytes = (prefix != null ? prefix : "").getBytes(ISO88591);
        this.suffixBytes = (suffix != null ? suffix : "").getBytes(ISO88591);
        this.data = new byte[4];
        this.encoded = new byte[5];
    }

    public ASCII85EncodeStream(OutputStream out) {
        this(out, "", "~>");
    }

    private static long toUInt32(byte[] bytes, int size) {
        long uint32 = 0L;
        for (int i = 0; i < 4 && i < size; ++i) {
            uint32 |= (long)((bytes[i] & 0xFF) << (3 - i) * 8);
        }
        return ASCII85EncodeStream.toUnsignedInt(uint32);
    }

    private static long toUnsignedInt(long x) {
        return x & 0xFFFFFFFFL;
    }

    @Override
    public void write(int b) throws IOException {
        if (this.closed) {
            return;
        }
        if (!this.prefixDone) {
            this.out.write(this.prefixBytes);
            this.prefixDone = true;
        }
        if (this.dataSize == this.data.length) {
            this.writeChunk();
            this.dataSize = 0;
        }
        this.data[this.dataSize++] = (byte)(b & 0xFF);
    }

    private void writeChunk() throws IOException {
        if (this.dataSize == 0) {
            return;
        }
        long uint32 = ASCII85EncodeStream.toUInt32(this.data, this.dataSize);
        int padByteCount = this.data.length - this.dataSize;
        int encodedSize = this.encodeChunk(uint32, padByteCount);
        this.out.write(this.encoded, 0, encodedSize);
    }

    private int encodeChunk(long uint32, int padByteCount) {
        Arrays.fill(this.encoded, (byte)0);
        if (uint32 == 0L && padByteCount == 0) {
            this.encoded[0] = 122;
            return 1;
        }
        int size = this.encoded.length - padByteCount;
        for (int i = 0; i < size; ++i) {
            this.encoded[i] = (byte)CHAR_MAP[(int)(uint32 / (long)POW_85[i] % 85L)];
        }
        return size;
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.writeChunk();
        this.out.write(this.suffixBytes);
        super.close();
        this.closed = true;
    }
}

