/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.util;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import org.xbib.graphics.chart.io.vector.util.DataUtils;

public class FormattingWriter
implements Closeable,
Flushable {
    private final OutputStream out;
    private final String encoding;
    private final String eolString;
    private long position;

    public FormattingWriter(OutputStream out, String encoding, String eol) {
        this.out = out;
        this.encoding = encoding;
        this.eolString = eol;
    }

    public FormattingWriter write(String string) throws IOException {
        byte[] bytes = string.getBytes(this.encoding);
        this.out.write(bytes, 0, bytes.length);
        this.position += (long)bytes.length;
        return this;
    }

    public FormattingWriter write(Number number) throws IOException {
        this.write(DataUtils.format(number));
        return this;
    }

    public FormattingWriter writeln() throws IOException {
        this.write(this.eolString);
        return this;
    }

    public FormattingWriter writeln(String string) throws IOException {
        this.write(string);
        this.write(this.eolString);
        return this;
    }

    public FormattingWriter writeln(Number number) throws IOException {
        this.write(number);
        this.write(this.eolString);
        return this;
    }

    public FormattingWriter format(String format, Object ... args) throws IOException {
        this.write(String.format(null, format, args));
        return this;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public long tell() {
        return this.position;
    }
}

