/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.io.vector.util;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Arc2D;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.PathIterator;
import java.awt.geom.QuadCurve2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.PriorityQueue;
import javax.swing.ImageIcon;

public abstract class GraphicsUtils {
    private static final FontRenderContext FONT_RENDER_CONTEXT = new FontRenderContext(null, false, true);
    private static final String FONT_TEST_STRING = "Falsches \u00dcben von Xylophonmusik qu\u00e4lt jeden gr\u00f6\u00dferen Zwerg";
    private static final FontExpressivenessComparator FONT_EXPRESSIVENESS_COMPARATOR = new FontExpressivenessComparator();

    protected GraphicsUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean hasAlpha(Image image) {
        ColorModel cm;
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            cm = bimage.getColorModel();
        } else {
            PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
            try {
                pg.grabPixels();
            }
            catch (InterruptedException e) {
                return false;
            }
            cm = pg.getColorModel();
        }
        return cm.hasAlpha();
    }

    public static boolean usesAlpha(Image image) {
        if (image == null) {
            return false;
        }
        BufferedImage bimage = GraphicsUtils.toBufferedImage(image);
        WritableRaster alphaRaster = bimage.getAlphaRaster();
        if (alphaRaster == null) {
            return false;
        }
        DataBuffer dataBuffer = alphaRaster.getDataBuffer();
        for (int i = 0; i < dataBuffer.getSize(); ++i) {
            int alpha = dataBuffer.getElem(i);
            if (alpha >= 255) continue;
            return true;
        }
        return false;
    }

    public static BufferedImage toBufferedImage(RenderedImage image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        ColorModel cm = image.getColorModel();
        WritableRaster raster = cm.createCompatibleWritableRaster(image.getWidth(), image.getHeight());
        boolean isRasterPremultiplied = cm.isAlphaPremultiplied();
        Hashtable<String, Object> properties = null;
        if (image.getPropertyNames() != null) {
            properties = new Hashtable<String, Object>();
            for (String key : image.getPropertyNames()) {
                properties.put(key, image.getProperty(key));
            }
        }
        BufferedImage bimage = new BufferedImage(cm, raster, isRasterPremultiplied, properties);
        image.copyData(raster);
        return bimage;
    }

    public static BufferedImage toBufferedImage(Image image) {
        BufferedImage bimage;
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = GraphicsUtils.hasAlpha(image);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 3;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            bimage = null;
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static Shape clone(Shape shape) {
        Shape clone;
        if (shape == null) {
            return null;
        }
        if (shape instanceof Line2D) {
            clone = shape instanceof Line2D.Float ? new Line2D.Float() : new Line2D.Double();
            ((Line2D)clone).setLine((Line2D)shape);
        } else if (shape instanceof Rectangle) {
            clone = new Rectangle((Rectangle)shape);
        } else if (shape instanceof Rectangle2D) {
            clone = shape instanceof Rectangle2D.Float ? new Rectangle2D.Float() : new Rectangle2D.Double();
            ((Rectangle2D)clone).setRect((Rectangle2D)shape);
        } else if (shape instanceof RoundRectangle2D) {
            clone = shape instanceof RoundRectangle2D.Float ? new RoundRectangle2D.Float() : new RoundRectangle2D.Double();
            ((RoundRectangle2D)clone).setRoundRect((RoundRectangle2D)shape);
        } else if (shape instanceof Ellipse2D) {
            clone = shape instanceof Ellipse2D.Float ? new Ellipse2D.Float() : new Ellipse2D.Double();
            ((Ellipse2D)clone).setFrame(((Ellipse2D)shape).getFrame());
        } else if (shape instanceof Arc2D) {
            clone = shape instanceof Arc2D.Float ? new Arc2D.Float() : new Arc2D.Double();
            ((Arc2D)clone).setArc((Arc2D)shape);
        } else if (shape instanceof Polygon) {
            Polygon p = (Polygon)shape;
            clone = new Polygon(p.xpoints, p.ypoints, p.npoints);
        } else if (shape instanceof CubicCurve2D) {
            clone = shape instanceof CubicCurve2D.Float ? new CubicCurve2D.Float() : new CubicCurve2D.Double();
            ((CubicCurve2D)clone).setCurve((CubicCurve2D)shape);
        } else if (shape instanceof QuadCurve2D) {
            clone = shape instanceof QuadCurve2D.Float ? new QuadCurve2D.Float() : new QuadCurve2D.Double();
            ((QuadCurve2D)clone).setCurve((QuadCurve2D)shape);
        } else {
            clone = shape instanceof Path2D.Float ? new Path2D.Float(shape) : new Path2D.Double(shape);
        }
        return clone;
    }

    private static boolean isLogicalFontFamily(String family) {
        return "Dialog".equals(family) || "DialogInput".equals(family) || "SansSerif".equals(family) || "Serif".equals(family) || "Monospaced".equals(family);
    }

    public static Font getPhysicalFont(Font logicalFont, String testText) {
        Font[] allPhysicalFonts;
        String logicalFamily = logicalFont.getFamily();
        if (!GraphicsUtils.isLogicalFontFamily(logicalFamily)) {
            return logicalFont;
        }
        TextLayout logicalLayout = new TextLayout(testText, logicalFont, FONT_RENDER_CONTEXT);
        PriorityQueue<Font> physicalFonts = new PriorityQueue<Font>(1, FONT_EXPRESSIVENESS_COMPARATOR);
        for (Font physicalFont : allPhysicalFonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()) {
            TextLayout physicalLayout;
            String physicalFamily = physicalFont.getFamily();
            if (GraphicsUtils.isLogicalFontFamily(physicalFamily) || !(physicalLayout = new TextLayout(testText, physicalFont = physicalFont.deriveFont(logicalFont.getStyle(), logicalFont.getSize2D()), FONT_RENDER_CONTEXT)).getBounds().equals(logicalLayout.getBounds()) || physicalLayout.getAscent() != logicalLayout.getAscent() || physicalLayout.getDescent() != logicalLayout.getDescent() || physicalLayout.getLeading() != logicalLayout.getLeading() || physicalLayout.getAdvance() != logicalLayout.getAdvance() || physicalLayout.getVisibleAdvance() != logicalLayout.getVisibleAdvance()) continue;
            physicalFonts.add(physicalFont);
        }
        if (physicalFonts.isEmpty()) {
            return logicalFont;
        }
        return (Font)physicalFonts.poll();
    }

    public static Font getPhysicalFont(Font logicalFont) {
        return GraphicsUtils.getPhysicalFont(logicalFont, FONT_TEST_STRING);
    }

    public static BufferedImage getAlphaImage(BufferedImage image) {
        WritableRaster alphaRaster = image.getAlphaRaster();
        int width = image.getWidth();
        int height = image.getHeight();
        ColorSpace colorSpace = ColorSpace.getInstance(1003);
        int[] bits = new int[]{8};
        ComponentColorModel cm = new ComponentColorModel(colorSpace, bits, false, true, 1, 0);
        WritableRaster raster = ((ColorModel)cm).createCompatibleWritableRaster(width, height);
        BufferedImage alphaImage = new BufferedImage(cm, raster, false, null);
        int[] alphaValues = new int[image.getWidth() * alphaRaster.getNumBands()];
        for (int y = 0; y < image.getHeight(); ++y) {
            alphaRaster.getPixels(0, y, image.getWidth(), 1, alphaValues);
            if (image.getTransparency() == 2) {
                for (int i = 0; i < alphaValues.length; ++i) {
                    if (alphaValues[i] <= 0) continue;
                    alphaValues[i] = 255;
                }
            }
            alphaImage.getRaster().setPixels(0, y, image.getWidth(), 1, alphaValues);
        }
        return alphaImage;
    }

    public static boolean equals(Shape shapeA, Shape shapeB) {
        PathIterator pathAIterator = shapeA.getPathIterator(null);
        PathIterator pathBIterator = shapeB.getPathIterator(null);
        if (pathAIterator.getWindingRule() != pathBIterator.getWindingRule()) {
            return false;
        }
        double[] pathASegment = new double[6];
        double[] pathBSegment = new double[6];
        while (!pathAIterator.isDone()) {
            int pathBSegmentType;
            int pathASegmentType = pathAIterator.currentSegment(pathASegment);
            if (pathASegmentType != (pathBSegmentType = pathBIterator.currentSegment(pathBSegment))) {
                return false;
            }
            for (int segmentIndex = 0; segmentIndex < pathASegment.length; ++segmentIndex) {
                if (pathASegment[segmentIndex] == pathBSegment[segmentIndex]) continue;
                return false;
            }
            pathAIterator.next();
            pathBIterator.next();
        }
        return pathBIterator.isDone();
    }

    private static class FontExpressivenessComparator
    implements Comparator<Font> {
        private static final int[] STYLES = new int[]{0, 2, 1, 3};

        private FontExpressivenessComparator() {
        }

        @Override
        public int compare(Font font1, Font font2) {
            if (font1 == font2) {
                return 0;
            }
            HashSet<String> variantNames1 = new HashSet<String>();
            HashSet<String> variantNames2 = new HashSet<String>();
            for (int style : STYLES) {
                variantNames1.add(font1.deriveFont(style).getPSName());
                variantNames2.add(font2.deriveFont(style).getPSName());
            }
            if (variantNames1.size() < variantNames2.size()) {
                return 1;
            }
            if (variantNames1.size() > variantNames2.size()) {
                return -1;
            }
            return font1.getName().compareTo(font2.getName());
        }
    }
}

