/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.legend;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.LinkedHashMap;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.legend.Legend;
import org.xbib.graphics.chart.legend.LegendLayout;
import org.xbib.graphics.chart.legend.LegendRenderType;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;

public abstract class AbstractLegend<ST extends Styler, S extends Series>
implements Legend<ST, S> {
    protected static final int BOX_SIZE = 20;
    protected static final int BOX_OUTLINE_WIDTH = 5;
    private static final int LEGEND_MARGIN = 6;
    private static final int MULTI_LINE_SPACE = 3;
    protected Chart<ST, S> chart;
    protected Rectangle2D bounds;
    protected double xOffset = 0.0;
    protected double yOffset = 0.0;

    protected AbstractLegend(Chart<ST, S> chart) {
        this.chart = chart;
    }

    @Override
    public abstract double getSeriesLegendRenderGraphicHeight(S var1);

    protected abstract void doPaint(Graphics2D var1);

    @Override
    public Rectangle2D getBounds() {
        if (((Styler)this.chart.getStyler()).getLegendLayout() == LegendLayout.Vertical) {
            return this.getBoundsHintVertical();
        }
        return this.getBoundsHintHorizontal();
    }

    @Override
    public void paint(Graphics2D g) {
        if (!((Styler)this.chart.getStyler()).isLegendVisible()) {
            return;
        }
        if (this.chart.getSeriesMap().isEmpty()) {
            return;
        }
        if (this.chart.getPlot().getBounds().getWidth() < 30.0) {
            return;
        }
        this.bounds = ((Styler)this.chart.getStyler()).getLegendLayout() == LegendLayout.Vertical ? this.getBoundsHintVertical() : this.getBoundsHintHorizontal();
        double height = this.bounds.getHeight();
        switch (((Styler)this.chart.getStyler()).getLegendPosition()) {
            case OutsideE: {
                this.xOffset = (double)this.chart.getWidth() - this.bounds.getWidth() - (double)((Styler)this.chart.getStyler()).getChartPadding();
                this.yOffset = this.chart.getPlot().getBounds().getY() + (this.chart.getPlot().getBounds().getHeight() - this.bounds.getHeight()) / 2.0;
                break;
            }
            case InsideNW: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + 6.0;
                this.yOffset = this.chart.getPlot().getBounds().getY() + 6.0;
                break;
            }
            case InsideNE: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + this.chart.getPlot().getBounds().getWidth() - this.bounds.getWidth() - 6.0;
                this.yOffset = this.chart.getPlot().getBounds().getY() + 6.0;
                break;
            }
            case InsideSE: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + this.chart.getPlot().getBounds().getWidth() - this.bounds.getWidth() - 6.0;
                this.yOffset = this.chart.getPlot().getBounds().getY() + this.chart.getPlot().getBounds().getHeight() - this.bounds.getHeight() - 6.0;
                break;
            }
            case InsideSW: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + 6.0;
                this.yOffset = this.chart.getPlot().getBounds().getY() + this.chart.getPlot().getBounds().getHeight() - this.bounds.getHeight() - 6.0;
                break;
            }
            case InsideN: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + (this.chart.getPlot().getBounds().getWidth() - this.bounds.getWidth()) / 2.0 + 6.0;
                this.yOffset = this.chart.getPlot().getBounds().getY() + 6.0;
                break;
            }
            case OutsideS: {
                this.xOffset = this.chart.getPlot().getBounds().getX() + (this.chart.getPlot().getBounds().getWidth() - this.bounds.getWidth()) / 2.0;
                this.yOffset = (double)this.chart.getHeight() - this.bounds.getHeight() - 6.0;
                break;
            }
        }
        Rectangle2D.Double rect = new Rectangle2D.Double(this.xOffset, this.yOffset, this.bounds.getWidth(), height);
        g.setColor(((Styler)this.chart.getStyler()).getLegendBackgroundColor());
        g.fill(rect);
        g.setStroke(Theme.Strokes.LEGEND);
        g.setColor(((Styler)this.chart.getStyler()).getLegendBorderColor());
        g.draw(rect);
        this.doPaint(g);
    }

    protected Map<String, Rectangle2D> getSeriesTextBounds(S series) {
        String[] lines = ((Series)series).getName().split("\\n");
        LinkedHashMap<String, Rectangle2D> seriesTextBounds = new LinkedHashMap<String, Rectangle2D>(lines.length);
        for (String line : lines) {
            TextLayout textLayout = new TextLayout(line, ((Styler)this.chart.getStyler()).getLegendFont(), new FontRenderContext(null, true, false));
            Shape shape = textLayout.getOutline(null);
            Rectangle2D bounds = shape.getBounds2D();
            seriesTextBounds.put(line, bounds);
        }
        return seriesTextBounds;
    }

    protected float getLegendEntryHeight(Map<String, Rectangle2D> seriesTextBounds, int markerSize) {
        float legendEntryHeight = 0.0f;
        for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
            legendEntryHeight = (float)((double)legendEntryHeight + (entry.getValue().getHeight() + 3.0));
        }
        legendEntryHeight -= 3.0f;
        legendEntryHeight = Math.max(legendEntryHeight, (float)markerSize);
        return legendEntryHeight;
    }

    protected float getLegendEntryWidth(Map<String, Rectangle2D> seriesTextBounds, int markerSize) {
        float legendEntryWidth = 0.0f;
        for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
            legendEntryWidth = Math.max(legendEntryWidth, (float)entry.getValue().getWidth());
        }
        return legendEntryWidth + (float)markerSize + (float)((Styler)this.chart.getStyler()).getLegendPadding();
    }

    protected void paintSeriesText(Graphics2D g, Map<String, Rectangle2D> seriesTextBounds, int markerSize, double x, double starty) {
        g.setColor(((Styler)this.chart.getStyler()).getChartFontColor());
        g.setFont(((Styler)this.chart.getStyler()).getLegendFont());
        double multiLineOffset = 0.0;
        for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
            double height = entry.getValue().getHeight();
            double centerOffsetY = (Math.max((double)markerSize, height) - height) / 2.0;
            FontRenderContext frc = g.getFontRenderContext();
            TextLayout tl = new TextLayout(entry.getKey(), ((Styler)this.chart.getStyler()).getLegendFont(), frc);
            Shape shape = tl.getOutline(null);
            AffineTransform orig = g.getTransform();
            AffineTransform at = new AffineTransform();
            at.translate(x, starty + height + centerOffsetY + multiLineOffset);
            g.transform(at);
            g.fill(shape);
            g.setTransform(orig);
            multiLineOffset += height + 3.0;
        }
    }

    private Rectangle2D getBoundsHintVertical() {
        if (!((Styler)this.chart.getStyler()).isLegendVisible()) {
            return new Rectangle2D.Double();
        }
        boolean containsBox = false;
        double legendTextContentMaxWidth = 0.0;
        double legendContentHeight = 0.0;
        Map<String, S> map = this.chart.getSeriesMap();
        for (Series series : map.values()) {
            if (series.isNotShownInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            double legendEntryHeight = 0.0;
            for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
                legendEntryHeight += entry.getValue().getHeight() + 3.0;
                legendTextContentMaxWidth = Math.max(legendTextContentMaxWidth, entry.getValue().getWidth());
            }
            legendEntryHeight -= 3.0;
            legendEntryHeight = Math.max(legendEntryHeight, this.getSeriesLegendRenderGraphicHeight(series));
            legendContentHeight += legendEntryHeight + (double)((Styler)this.chart.getStyler()).getLegendPadding();
            if (series.getLegendRenderType() != LegendRenderType.Box) continue;
            containsBox = true;
        }
        double legendContentWidth = !containsBox ? (double)(((Styler)this.chart.getStyler()).getLegendSeriesLineLength() + ((Styler)this.chart.getStyler()).getLegendPadding()) + legendTextContentMaxWidth : (double)(20 + ((Styler)this.chart.getStyler()).getLegendPadding()) + legendTextContentMaxWidth;
        double width = legendContentWidth + (double)(2 * ((Styler)this.chart.getStyler()).getLegendPadding());
        double height = legendContentHeight + (double)((Styler)this.chart.getStyler()).getLegendPadding();
        return new Rectangle2D.Double(Double.NaN, Double.NaN, width, height);
    }

    private Rectangle2D getBoundsHintHorizontal() {
        if (!((Styler)this.chart.getStyler()).isLegendVisible()) {
            return new Rectangle2D.Double();
        }
        double legendTextContentMaxHeight = 0.0;
        double legendContentWidth = 0.0;
        Map<String, S> map = this.chart.getSeriesMap();
        for (Series series : map.values()) {
            if (series.isNotShownInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            double legendEntryHeight = 0.0;
            double legendEntryMaxWidth = 0.0;
            for (Map.Entry<String, Rectangle2D> entry : seriesTextBounds.entrySet()) {
                legendEntryHeight += entry.getValue().getHeight() + 3.0;
                legendEntryMaxWidth = Math.max(legendEntryMaxWidth, entry.getValue().getWidth());
            }
            legendTextContentMaxHeight = Math.max(legendEntryHeight -= 3.0, this.getSeriesLegendRenderGraphicHeight(series));
            legendContentWidth += legendEntryMaxWidth + (double)((Styler)this.chart.getStyler()).getLegendPadding();
            if (series.getLegendRenderType() == LegendRenderType.Line) {
                legendContentWidth = (double)(((Styler)this.chart.getStyler()).getLegendSeriesLineLength() + ((Styler)this.chart.getStyler()).getLegendPadding()) + legendContentWidth;
                continue;
            }
            legendContentWidth = (double)(20 + ((Styler)this.chart.getStyler()).getLegendPadding()) + legendContentWidth;
        }
        double width = legendContentWidth + (double)((Styler)this.chart.getStyler()).getLegendPadding();
        double height = legendTextContentMaxHeight + (double)(((Styler)this.chart.getStyler()).getLegendPadding() * 2);
        return new Rectangle2D.Double(0.0, 0.0, width, height);
    }
}

