/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.legend;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.legend.AbstractLegend;
import org.xbib.graphics.chart.legend.LegendLayout;
import org.xbib.graphics.chart.legend.LegendRenderType;
import org.xbib.graphics.chart.series.MarkerSeries;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.theme.Theme;

public class MarkerLegend<ST extends AxesChartStyler, S extends MarkerSeries>
extends AbstractLegend<ST, S> {
    private final ST axesChartStyler;

    public MarkerLegend(Chart<ST, S> chart) {
        super(chart);
        this.axesChartStyler = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double startx = this.xOffset + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (MarkerSeries series : map.values()) {
            double x;
            if (series.isNotShownInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, series.getLegendRenderType() == LegendRenderType.Line || series.getLegendRenderType() == LegendRenderType.Scatter ? ((AxesChartStyler)this.axesChartStyler).getMarkerSize() : 20);
            if (series.getLegendRenderType() == LegendRenderType.Line || series.getLegendRenderType() == LegendRenderType.Scatter) {
                if (series.getLegendRenderType() == LegendRenderType.Line && series.getLineStyle() != Theme.Series.NONE_STROKE) {
                    g.setColor(series.getLineColor());
                    g.setStroke(series.getLineStyle());
                    Line2D.Double line = new Line2D.Double(startx, starty + (double)legendEntryHeight / 2.0, startx + (double)((AxesChartStyler)this.chart.getStyler()).getLegendSeriesLineLength(), starty + (double)legendEntryHeight / 2.0);
                    g.draw(line);
                }
                if (series.getMarker() != null) {
                    g.setColor(series.getMarkerColor());
                    series.getMarker().paint(g, startx + (double)((AxesChartStyler)this.chart.getStyler()).getLegendSeriesLineLength() / 2.0, starty + (double)legendEntryHeight / 2.0, ((AxesChartStyler)this.axesChartStyler).getMarkerSize());
                }
            } else {
                Rectangle2D.Double rectSmall = new Rectangle2D.Double(startx, starty, 20.0, 20.0);
                g.setColor(series.getFillColor());
                g.fill(rectSmall);
                if (series.getLegendRenderType() != LegendRenderType.BoxNoOutline) {
                    g.setColor(series.getLineColor());
                    BasicStroke existingLineStyle = series.getLineStyle();
                    BasicStroke newLineStyle = new BasicStroke(Math.min(existingLineStyle.getLineWidth(), 2.5f), existingLineStyle.getEndCap(), existingLineStyle.getLineJoin(), existingLineStyle.getMiterLimit(), existingLineStyle.getDashArray(), existingLineStyle.getDashPhase());
                    g.setPaint(series.getLineColor());
                    g.setStroke(newLineStyle);
                    Path2D.Double outlinePath = new Path2D.Double();
                    double lineOffset = (double)existingLineStyle.getLineWidth() * 0.5;
                    outlinePath.moveTo(startx + lineOffset, starty + lineOffset);
                    outlinePath.lineTo(startx + lineOffset, starty + 20.0 - lineOffset);
                    outlinePath.lineTo(startx + 20.0 - lineOffset, starty + 20.0 - lineOffset);
                    outlinePath.lineTo(startx + 20.0 - lineOffset, starty + lineOffset);
                    outlinePath.closePath();
                    g.draw(outlinePath);
                }
            }
            if (series.getLegendRenderType() == LegendRenderType.Line || series.getLegendRenderType() == LegendRenderType.Scatter) {
                x = startx + (double)((AxesChartStyler)this.chart.getStyler()).getLegendSeriesLineLength() + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
                this.paintSeriesText(g, seriesTextBounds, ((AxesChartStyler)this.axesChartStyler).getMarkerSize(), x, starty);
            } else {
                x = startx + 20.0 + (double)((AxesChartStyler)this.chart.getStyler()).getLegendPadding();
                this.paintSeriesText(g, seriesTextBounds, 20, x, starty);
            }
            if (((AxesChartStyler)this.chart.getStyler()).getLegendLayout() == LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((AxesChartStyler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = 20;
            if (series.getLegendRenderType() == LegendRenderType.Line) {
                markerWidth = ((AxesChartStyler)this.chart.getStyler()).getLegendSeriesLineLength();
            }
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((AxesChartStyler)this.chart.getStyler()).getLegendPadding());
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return ((Series)series).getLegendRenderType() == LegendRenderType.Box || ((Series)series).getLegendRenderType() == LegendRenderType.BoxNoOutline ? 20.0 : (double)((AxesChartStyler)this.axesChartStyler).getMarkerSize();
    }
}

