/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.ohlc;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.AxisPair;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.ohlc.OHLCChartBuilder;
import org.xbib.graphics.chart.ohlc.OHLCLegend;
import org.xbib.graphics.chart.ohlc.OHLCSeries;
import org.xbib.graphics.chart.ohlc.OHLCSeriesRenderStyle;
import org.xbib.graphics.chart.ohlc.OHLCStyler;
import org.xbib.graphics.chart.plot.AxesChartPlot;
import org.xbib.graphics.chart.plot.ContentPlot;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyle;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyleCycler;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;

public class OHLCChart
extends Chart<OHLCStyler, OHLCSeries> {
    public OHLCChart(int width, int height) {
        super(width, height, new OHLCStyler());
        this.axisPair = new AxisPair<OHLCStyler, OHLCSeries>(this);
        this.plot = new OHLCPlot<OHLCStyler, OHLCSeries>(this);
        this.legend = new OHLCLegend<OHLCStyler, OHLCSeries>(this);
    }

    public OHLCChart(int width, int height, Theme theme) {
        this(width, height);
        ((OHLCStyler)this.styler).setTheme(theme);
    }

    public OHLCChart(OHLCChartBuilder chartBuilder) {
        this(chartBuilder.getWidth(), chartBuilder.getHeight(), chartBuilder.getTheme());
        this.setTitle(chartBuilder.getTitle());
        this.setXAxisTitle(chartBuilder.getxAxisTitle());
        this.setYAxisTitle(chartBuilder.getyAxisTitle());
    }

    public OHLCSeries addSeries(String seriesName, List<?> xData, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData) {
        DataType dataType = this.getDataType(xData);
        if (dataType == DataType.Instant) {
            return this.addSeries(seriesName, xData, openData, highData, lowData, closeData, DataType.Instant);
        }
        return this.addSeries(seriesName, xData, openData, highData, lowData, closeData, DataType.Number);
    }

    public OHLCSeries addSeries(String seriesName, double[] xData, double[] openData, double[] highData, double[] lowData, double[] closeData) {
        return this.addSeries(seriesName, this.listFromDoubleArray(xData), this.listFromDoubleArray(openData), this.listFromDoubleArray(highData), this.listFromDoubleArray(lowData), this.listFromDoubleArray(closeData), DataType.Number);
    }

    private OHLCSeries addSeries(String seriesName, List<?> xData, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData, DataType dataType) {
        List<Double> xDataToUse;
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series!!!");
        }
        this.sanityCheck(seriesName, openData, highData, lowData, closeData);
        if (xData != null) {
            this.checkDataLengths(seriesName, "X-Axis", xData, closeData);
            xDataToUse = xData;
        } else {
            xDataToUse = this.getGeneratedData(closeData.size());
        }
        OHLCSeries series = new OHLCSeries(seriesName, xDataToUse, openData, highData, lowData, closeData, dataType);
        this.seriesMap.put(seriesName, series);
        return series;
    }

    private DataType getDataType(List<?> data) {
        DataType axisType;
        if (data == null) {
            return DataType.Number;
        }
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = DataType.Number;
        } else if (dataPoint instanceof Instant) {
            axisType = DataType.Instant;
        } else {
            throw new IllegalArgumentException("Series data must be either Number or Instant type");
        }
        return axisType;
    }

    private void checkData(String seriesName, String dataName, List<? extends Number> data) {
        if (data == null) {
            throw new IllegalArgumentException(dataName + " data cannot be null >" + seriesName);
        }
        if (data.size() == 0) {
            throw new IllegalArgumentException(dataName + " data cannot be empty >" + seriesName);
        }
    }

    private void checkDataLengths(String seriesName, String data1Name, List<?> data1, List<?> data2) {
        String data2Name = "Close";
        if (data1.size() != data2.size()) {
            throw new IllegalArgumentException(data1Name + " and " + data2Name + " sizes are not the same >" + seriesName);
        }
    }

    private void sanityCheck(String seriesName, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData) {
        this.checkData(seriesName, "Open", openData);
        this.checkData(seriesName, "High", highData);
        this.checkData(seriesName, "Low", lowData);
        this.checkData(seriesName, "Close", closeData);
        this.checkDataLengths(seriesName, "Open", openData, closeData);
        this.checkDataLengths(seriesName, "High", highData, closeData);
        this.checkDataLengths(seriesName, "Low", lowData, closeData);
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (OHLCSeries series : this.getSeriesMap().values()) {
            OHLCSeriesRenderStyle renderStyle = series.getOhlcSeriesRenderStyle();
            if (renderStyle != null) continue;
            series.setOhlcSeriesRenderStyle(((OHLCStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        this.paintBackground(g);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((OHLCStyler)this.getStyler()).getSeriesColors(), ((OHLCStyler)this.getStyler()).getSeriesMarkers(), ((OHLCStyler)this.getStyler()).getSeriesLines());
        for (OHLCSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getUpColor() == null) {
                series.setUpColor(Color.GREEN);
            }
            if (series.getDownColor() != null) continue;
            series.setDownColor(Color.RED);
        }
    }

    private static class ContentPlotOHLC<ST extends AxesChartStyler, S extends OHLCSeries>
    extends ContentPlot<ST, S> {
        private final ST ohlcStyler;

        private ContentPlotOHLC(Chart<ST, S> chart) {
            super(chart);
            this.ohlcStyler = (AxesChartStyler)chart.getStyler();
        }

        @Override
        public void doPaint(Graphics2D g) {
            double xTickSpace = ((Styler)this.ohlcStyler).getPlotContentSize() * this.getBounds().getWidth();
            double xLeftMargin = ((double)((int)this.getBounds().getWidth()) - xTickSpace) / 2.0;
            double yTickSpace = ((Styler)this.ohlcStyler).getPlotContentSize() * this.getBounds().getHeight();
            double yTopMargin = ((double)((int)this.getBounds().getHeight()) - yTickSpace) / 2.0;
            double xMin = this.chart.getXAxis().getMin();
            double xMax = this.chart.getXAxis().getMax();
            Line2D.Double line = new Line2D.Double();
            Rectangle2D.Double rect = new Rectangle2D.Double();
            if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
                xMin = Math.log10(xMin);
                xMax = Math.log10(xMax);
            }
            Map map = this.chart.getSeriesMap();
            for (OHLCSeries series : map.values()) {
                if (!series.isEnabled()) continue;
                Axis<?, ?> yAxis = this.chart.getYAxis(series.getYAxisGroup());
                double yMin = yAxis.getMin();
                double yMax = yAxis.getMax();
                if (((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic()) {
                    yMin = Math.log10(yMin);
                    yMax = Math.log10(yMax);
                }
                List<?> xData = series.getXData();
                List<? extends Number> openData = series.getOpenData();
                List<? extends Number> highData = series.getHighData();
                List<? extends Number> lowData = series.getLowData();
                List<? extends Number> closeData = series.getCloseData();
                double candleHalfWidth = Math.max(3.0, xTickSpace / (double)xData.size() / 2.0 - (double)((AxesChartStyler)this.ohlcStyler).getAxisTickPadding());
                for (int i = 0; i < xData.size(); ++i) {
                    double closeY;
                    double lowY;
                    double highY;
                    double openY;
                    Double x = (Double)xData.get(i);
                    if (((AxesChartStyler)this.ohlcStyler).isXAxisLogarithmic()) {
                        x = Math.log10(x);
                    }
                    if (Double.isNaN((Double)closeData.get(i))) continue;
                    Double openOrig = (Double)openData.get(i);
                    Double highOrig = (Double)highData.get(i);
                    Double lowOrig = (Double)lowData.get(i);
                    Double closeOrig = (Double)closeData.get(i);
                    if (((AxesChartStyler)this.ohlcStyler).isYAxisLogarithmic()) {
                        openY = Math.log10(openOrig);
                        highY = Math.log10(highOrig);
                        lowY = Math.log10(lowOrig);
                        closeY = Math.log10(closeOrig);
                    } else {
                        openY = openOrig;
                        highY = highOrig;
                        lowY = lowOrig;
                        closeY = closeOrig;
                    }
                    double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                    double openTransform = this.getBounds().getHeight() - (yTopMargin + (openY - yMin) / (yMax - yMin) * yTickSpace);
                    double highTransform = this.getBounds().getHeight() - (yTopMargin + (highY - yMin) / (yMax - yMin) * yTickSpace);
                    double lowTransform = this.getBounds().getHeight() - (yTopMargin + (lowY - yMin) / (yMax - yMin) * yTickSpace);
                    double closeTransform = this.getBounds().getHeight() - (yTopMargin + (closeY - yMin) / (yMax - yMin) * yTickSpace);
                    if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                        xTransform = this.getBounds().getWidth() / 2.0;
                    }
                    if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                        openTransform = this.getBounds().getHeight() / 2.0;
                        highTransform = this.getBounds().getHeight() / 2.0;
                        lowTransform = this.getBounds().getHeight() / 2.0;
                        closeTransform = this.getBounds().getHeight() / 2.0;
                    }
                    double xOffset = this.getBounds().getX() + xTransform;
                    double openOffset = this.getBounds().getY() + openTransform;
                    double highOffset = this.getBounds().getY() + highTransform;
                    double lowOffset = this.getBounds().getY() + lowTransform;
                    double closeOffset = this.getBounds().getY() + closeTransform;
                    if (series.getLineStyle() == Theme.Series.NONE_STROKE || xOffset == -1.7976931348623157E308 || openOffset == -1.7976931348623157E308 || highOffset == -1.7976931348623157E308 || lowOffset == -1.7976931348623157E308 || closeOffset == -1.7976931348623157E308) continue;
                    g.setColor(series.getLineColor());
                    g.setStroke(series.getLineStyle());
                    line.setLine(xOffset, highOffset, xOffset, lowOffset);
                    g.draw(line);
                    double xStart = xOffset - candleHalfWidth;
                    double xEnd = xOffset + candleHalfWidth;
                    if (series.getOhlcSeriesRenderStyle() == OHLCSeriesRenderStyle.Candle) {
                        if (closeOrig > openOrig) {
                            g.setPaint(series.getUpColor());
                        } else {
                            g.setPaint(series.getDownColor());
                        }
                        rect.setRect(xStart, Math.min(openOffset, closeOffset), xEnd - xStart, Math.abs(closeOffset - openOffset));
                        g.fill(rect);
                        continue;
                    }
                    line.setLine(xStart, openOffset, xOffset, openOffset);
                    g.draw(line);
                    line.setLine(xOffset, closeOffset, xEnd, closeOffset);
                    g.draw(line);
                }
                g.setColor(series.getFillColor());
            }
        }
    }

    private static class OHLCPlot<ST extends AxesChartStyler, S extends OHLCSeries>
    extends AxesChartPlot<ST, S> {
        private OHLCPlot(Chart<ST, S> chart) {
            super(chart);
            this.contentPlot = new ContentPlotOHLC<ST, S>(chart);
        }
    }
}

