/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.ohlc;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.legend.AbstractLegend;
import org.xbib.graphics.chart.legend.LegendLayout;
import org.xbib.graphics.chart.legend.LegendRenderType;
import org.xbib.graphics.chart.ohlc.OHLCSeries;
import org.xbib.graphics.chart.ohlc.OHLCStyler;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.theme.Theme;

public class OHLCLegend<ST extends OHLCStyler, S extends OHLCSeries>
extends AbstractLegend<ST, S> {
    private final ST axesChartStyler;

    public OHLCLegend(Chart<ST, S> chart) {
        super(chart);
        this.axesChartStyler = (OHLCStyler)chart.getStyler();
    }

    @Override
    public void doPaint(Graphics2D g) {
        double startx = this.xOffset + (double)((OHLCStyler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((OHLCStyler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (OHLCSeries series : map.values()) {
            if (series.isNotShownInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, ((AxesChartStyler)this.axesChartStyler).getMarkerSize());
            if (series.getLegendRenderType() == LegendRenderType.Line && series.getLineStyle() != Theme.Series.NONE_STROKE) {
                g.setColor(series.getLineColor());
                g.setStroke(series.getLineStyle());
                Line2D.Double line = new Line2D.Double(startx, starty + (double)legendEntryHeight / 2.0, startx + (double)((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength(), starty + (double)legendEntryHeight / 2.0);
                g.draw(line);
            }
            double x = startx + (double)((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength() + (double)((OHLCStyler)this.chart.getStyler()).getLegendPadding();
            this.paintSeriesText(g, seriesTextBounds, ((AxesChartStyler)this.axesChartStyler).getMarkerSize(), x, starty);
            if (((OHLCStyler)this.chart.getStyler()).getLegendLayout() == LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((OHLCStyler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = ((OHLCStyler)this.chart.getStyler()).getLegendSeriesLineLength();
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((OHLCStyler)this.chart.getStyler()).getLegendPadding());
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return ((OHLCSeries)series).getLegendRenderType() == LegendRenderType.Box || ((OHLCSeries)series).getLegendRenderType() == LegendRenderType.BoxNoOutline ? 20.0 : (double)((AxesChartStyler)this.axesChartStyler).getMarkerSize();
    }
}

