/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.ohlc;

import java.awt.Color;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.legend.LegendRenderType;
import org.xbib.graphics.chart.ohlc.OHLCSeriesRenderStyle;
import org.xbib.graphics.chart.series.AxesChartSeries;

public class OHLCSeries
extends AxesChartSeries {
    private final List<?> xData;
    private final List<? extends Number> openData;
    private final List<? extends Number> highData;
    private final List<? extends Number> lowData;
    private final List<? extends Number> closeData;
    private OHLCSeriesRenderStyle ohlcSeriesRenderStyle;
    private Color upColor;
    private Color downColor;

    public OHLCSeries(String name, List<?> xData, List<? extends Number> openData, List<? extends Number> highData, List<? extends Number> lowData, List<? extends Number> closeData, DataType xDataType) {
        super(name, xDataType);
        this.xData = xData;
        this.openData = openData;
        this.highData = highData;
        this.lowData = lowData;
        this.closeData = closeData;
        this.calculateMinMax();
    }

    public OHLCSeriesRenderStyle getOhlcSeriesRenderStyle() {
        return this.ohlcSeriesRenderStyle;
    }

    public void setOhlcSeriesRenderStyle(OHLCSeriesRenderStyle ohlcSeriesRenderStyle) {
        this.ohlcSeriesRenderStyle = ohlcSeriesRenderStyle;
    }

    public Color getUpColor() {
        return this.upColor;
    }

    public void setUpColor(Color color) {
        this.upColor = color;
    }

    public Color getDownColor() {
        return this.downColor;
    }

    public void setDownColor(Color color) {
        this.downColor = color;
    }

    @Override
    public LegendRenderType getLegendRenderType() {
        return this.ohlcSeriesRenderStyle.getLegendRenderType();
    }

    private List<Double> findMinMax(List<?> lows, List<?> highs) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < highs.size(); ++i) {
            Instant t;
            double d;
            Object h = highs.get(i);
            Object l = lows.get(i);
            if (h instanceof Double) {
                d = (Double)h;
                if (!Double.isNaN(d) && d > max) {
                    max = d;
                }
            } else if (h instanceof Instant && (double)(t = (Instant)h).toEpochMilli() > max) {
                max = t.toEpochMilli();
            }
            if (l instanceof Double) {
                d = (Double)l;
                if (Double.isNaN(d) || !(d < min)) continue;
                min = d;
                continue;
            }
            if (!(l instanceof Instant) || !((double)(t = (Instant)l).toEpochMilli() < min)) continue;
            min = t.toEpochMilli();
        }
        return Arrays.asList(min, max);
    }

    @Override
    protected void calculateMinMax() {
        List<Double> xMinMax = this.findMinMax(this.xData, this.xData);
        this.setXMin(xMinMax.get(0));
        this.setXMax(xMinMax.get(1));
        List<Double> yMinMax = this.findMinMax(this.lowData, this.highData);
        this.setYMin(yMinMax.get(0));
        this.setYMax(yMinMax.get(1));
    }

    public List<?> getXData() {
        return this.xData;
    }

    public List<? extends Number> getOpenData() {
        return this.openData;
    }

    public List<? extends Number> getHighData() {
        return this.highData;
    }

    public List<? extends Number> getLowData() {
        return this.lowData;
    }

    public List<? extends Number> getCloseData() {
        return this.closeData;
    }
}

