/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.pie;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.text.DecimalFormat;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.pie.PieChartBuilder;
import org.xbib.graphics.chart.pie.PieLegend;
import org.xbib.graphics.chart.pie.PieSeries;
import org.xbib.graphics.chart.pie.PieSeriesRenderStyle;
import org.xbib.graphics.chart.pie.PieStyler;
import org.xbib.graphics.chart.plot.CircularPlot;
import org.xbib.graphics.chart.plot.ContentPlot;
import org.xbib.graphics.chart.plot.SurfacePlot;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyle;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyleCycler;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;

public class PieChart
extends Chart<PieStyler, PieSeries> {
    public PieChart(int width, int height) {
        super(width, height, new PieStyler());
        this.plot = new PiePlot<PieStyler, PieSeries>(this);
        this.legend = new PieLegend<PieStyler, PieSeries>(this);
    }

    public PieChart(int width, int height, Theme theme) {
        this(width, height);
        ((PieStyler)this.styler).setTheme(theme);
    }

    public PieChart(PieChartBuilder chartBuilder) {
        this(chartBuilder.getWidth(), chartBuilder.getHeight(), chartBuilder.getTheme());
        this.setTitle(chartBuilder.getTitle());
    }

    public PieSeries addSeries(String seriesName, Number value) {
        PieSeries series = new PieSeries(seriesName, value);
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series");
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (PieSeries pieSeries : this.getSeriesMap().values()) {
            PieSeriesRenderStyle seriesType = pieSeries.getPieSeriesRenderStyle();
            if (seriesType != null) continue;
            pieSeries.setPieSeriesRenderStyle(((PieStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(((PieStyler)this.styler).getChartBackgroundColor());
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g.fill(rect);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
    }

    public void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((PieStyler)this.getStyler()).getSeriesColors(), ((PieStyler)this.getStyler()).getSeriesMarkers(), ((PieStyler)this.getStyler()).getSeriesLines());
        for (Series series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getFillColor() != null) continue;
            series.setFillColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    private static class SurfacePlotPie<ST extends PieStyler, S extends PieSeries>
    extends SurfacePlot<ST, S> {
        private final ST pieStyler;

        private SurfacePlotPie(Chart<ST, S> chart) {
            super(chart);
            this.pieStyler = (PieStyler)chart.getStyler();
        }

        @Override
        public void paint(Graphics2D g) {
            Rectangle2D bounds = this.getBounds();
            if (bounds != null) {
                Rectangle2D.Double rect = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
                g.setColor(((Styler)this.pieStyler).getPlotBackgroundColor());
                g.fill(rect);
                if (((Styler)this.pieStyler).isPlotBorderVisible()) {
                    g.setColor(((Styler)this.pieStyler).getPlotBorderColor());
                    g.draw(rect);
                }
            }
        }
    }

    private static class ContentPlotPie<ST extends PieStyler, S extends PieSeries>
    extends ContentPlot<ST, S> {
        private final PieStyler pieStyler;
        private final DecimalFormat df = new DecimalFormat("#.0");

        private ContentPlotPie(Chart<ST, S> chart) {
            super(chart);
            this.pieStyler = (PieStyler)chart.getStyler();
        }

        @Override
        public void doPaint(Graphics2D g) {
            double pieFillPercentage = this.pieStyler.getPlotContentSize();
            double halfBorderPercentage = (1.0 - pieFillPercentage) / 2.0;
            double width = this.pieStyler.isCircular() ? Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) : this.getBounds().getWidth();
            double height = this.pieStyler.isCircular() ? Math.min(this.getBounds().getWidth(), this.getBounds().getHeight()) : this.getBounds().getHeight();
            Rectangle2D.Double pieBounds = new Rectangle2D.Double(this.getBounds().getX() + this.getBounds().getWidth() / 2.0 - width / 2.0 + halfBorderPercentage * width, this.getBounds().getY() + this.getBounds().getHeight() / 2.0 - height / 2.0 + halfBorderPercentage * height, width * pieFillPercentage, height * pieFillPercentage);
            double total = 0.0;
            Map map = this.chart.getSeriesMap();
            for (PieSeries series : map.values()) {
                if (!series.isEnabled()) continue;
                total += series.getValue().doubleValue();
            }
            if (this.pieStyler.isSumVisible()) {
                DecimalFormat totalDf = this.pieStyler.getDecimalPattern() == null ? this.df : new DecimalFormat(this.pieStyler.getDecimalPattern());
                String annotation = totalDf.format(total);
                TextLayout textLayout = new TextLayout(annotation, this.pieStyler.getSumFont(), new FontRenderContext(null, true, false));
                Shape shape = textLayout.getOutline(null);
                g.setColor(this.pieStyler.getChartFontColor());
                Rectangle2D annotationRectangle = textLayout.getBounds();
                double xCenter = ((RectangularShape)pieBounds).getX() + ((RectangularShape)pieBounds).getWidth() / 2.0 - annotationRectangle.getWidth() / 2.0;
                double yCenter = ((RectangularShape)pieBounds).getY() + ((RectangularShape)pieBounds).getHeight() / 2.0 + annotationRectangle.getHeight() / 2.0;
                AffineTransform orig = g.getTransform();
                AffineTransform at = new AffineTransform();
                at.translate(xCenter, yCenter);
                g.transform(at);
                g.fill(shape);
                g.setTransform(orig);
            }
            double startAngle = this.pieStyler.getStartAngleInDegrees() + 90.0;
            map = this.chart.getSeriesMap();
            for (PieSeries series : map.values()) {
                if (!series.isEnabled()) continue;
                Number y = series.getValue();
                double arcAngle = y.doubleValue() * 360.0 / total;
                g.setColor(series.getFillColor());
                if (PieSeriesRenderStyle.Pie == series.getPieSeriesRenderStyle()) {
                    Arc2D.Double pieShape = new Arc2D.Double(((RectangularShape)pieBounds).getX(), ((RectangularShape)pieBounds).getY(), ((RectangularShape)pieBounds).getWidth(), ((RectangularShape)pieBounds).getHeight(), startAngle, arcAngle, 2);
                    g.fill(pieShape);
                    g.setColor(this.pieStyler.getPlotBackgroundColor());
                    g.draw(pieShape);
                } else {
                    Shape donutSlice = this.getDonutSliceShape(pieBounds, this.pieStyler.getDonutThickness(), startAngle, arcAngle);
                    g.fill(donutSlice);
                    g.setColor(this.pieStyler.getPlotBackgroundColor());
                    g.draw(donutSlice);
                }
                if (this.pieStyler.hasAnnotations().booleanValue()) {
                    Object annotation = "";
                    if (this.pieStyler.getAnnotationType() == PieStyler.AnnotationType.Value) {
                        if (this.pieStyler.getDecimalPattern() != null) {
                            DecimalFormat df = new DecimalFormat(this.pieStyler.getDecimalPattern());
                            annotation = df.format(y);
                        } else {
                            annotation = y.toString();
                        }
                    } else if (this.pieStyler.getAnnotationType() == PieStyler.AnnotationType.Label) {
                        annotation = series.getName();
                    } else if (this.pieStyler.getAnnotationType() == PieStyler.AnnotationType.LabelAndPercentage) {
                        double percentage = y.doubleValue() / total * 100.0;
                        annotation = series.getName() + " (" + this.df.format(percentage) + "%)";
                    } else if (this.pieStyler.getAnnotationType() == PieStyler.AnnotationType.Percentage) {
                        double percentage = y.doubleValue() / total * 100.0;
                        annotation = this.df.format(percentage) + "%";
                    }
                    TextLayout textLayout = new TextLayout((String)annotation, this.pieStyler.getAnnotationsFont(), new FontRenderContext(null, true, false));
                    Rectangle2D annotationRectangle = textLayout.getBounds();
                    double xCenter = ((RectangularShape)pieBounds).getX() + ((RectangularShape)pieBounds).getWidth() / 2.0 - annotationRectangle.getWidth() / 2.0;
                    double yCenter = ((RectangularShape)pieBounds).getY() + ((RectangularShape)pieBounds).getHeight() / 2.0 + annotationRectangle.getHeight() / 2.0;
                    double angle = arcAngle + startAngle - arcAngle / 2.0;
                    double xOffset = xCenter + Math.cos(Math.toRadians(angle)) * (((RectangularShape)pieBounds).getWidth() / 2.0 * this.pieStyler.getAnnotationDistance());
                    double yOffset = yCenter - Math.sin(Math.toRadians(angle)) * (((RectangularShape)pieBounds).getHeight() / 2.0 * this.pieStyler.getAnnotationDistance());
                    Shape shape = textLayout.getOutline(null);
                    Rectangle2D annotationBounds = shape.getBounds2D();
                    double annotationWidth = annotationBounds.getWidth();
                    double annotationHeight = annotationBounds.getHeight();
                    double xOffset1 = xCenter + Math.cos(Math.toRadians(startAngle)) * (((RectangularShape)pieBounds).getWidth() / 2.0 * this.pieStyler.getAnnotationDistance());
                    double yOffset1 = yCenter - Math.sin(Math.toRadians(startAngle)) * (((RectangularShape)pieBounds).getHeight() / 2.0 * this.pieStyler.getAnnotationDistance());
                    double xOffset2 = xCenter + Math.cos(Math.toRadians(arcAngle + startAngle)) * (((RectangularShape)pieBounds).getWidth() / 2.0 * this.pieStyler.getAnnotationDistance());
                    double yOffset2 = yCenter - Math.sin(Math.toRadians(arcAngle + startAngle)) * (((RectangularShape)pieBounds).getHeight() / 2.0 * this.pieStyler.getAnnotationDistance());
                    double xDiff = Math.abs(xOffset1 - xOffset2);
                    double yDiff = Math.abs(yOffset1 - yOffset2);
                    boolean annotationWillFit = false;
                    if (xDiff >= yDiff) {
                        if (annotationWidth < xDiff) {
                            annotationWillFit = true;
                        }
                    } else if (xDiff <= yDiff && annotationHeight < yDiff) {
                        annotationWillFit = true;
                    }
                    if (this.pieStyler.isDrawAllAnnotations() || annotationWillFit) {
                        g.setColor(this.pieStyler.getChartFontColor());
                        g.setFont(this.pieStyler.getAnnotationsFont());
                        AffineTransform orig = g.getTransform();
                        AffineTransform at = new AffineTransform();
                        if (this.pieStyler.getAnnotationDistance() <= 1.0) {
                            at.translate(xOffset, yOffset);
                        } else {
                            xCenter = ((RectangularShape)pieBounds).getX() + ((RectangularShape)pieBounds).getWidth() / 2.0;
                            yCenter = ((RectangularShape)pieBounds).getY() + ((RectangularShape)pieBounds).getHeight() / 2.0;
                            double endPoint = 3.0 - this.pieStyler.getAnnotationDistance();
                            double xOffsetStart = xCenter + Math.cos(Math.toRadians(angle)) * (((RectangularShape)pieBounds).getWidth() / 2.01);
                            double xOffsetEnd = xCenter + Math.cos(Math.toRadians(angle)) * (((RectangularShape)pieBounds).getWidth() / endPoint);
                            double yOffsetStart = yCenter - Math.sin(Math.toRadians(angle)) * (((RectangularShape)pieBounds).getHeight() / 2.01);
                            double yOffsetEnd = yCenter - Math.sin(Math.toRadians(angle)) * (((RectangularShape)pieBounds).getHeight() / endPoint);
                            g.setStroke(Theme.Strokes.PIE);
                            Line2D.Double line = new Line2D.Double(xOffsetStart, yOffsetStart, xOffsetEnd, yOffsetEnd);
                            g.draw(line);
                            at.translate(xOffset - Math.sin(Math.toRadians(angle - 90.0)) * annotationWidth / 2.0 + 3.0, yOffset);
                        }
                        g.transform(at);
                        g.fill(shape);
                        g.setTransform(orig);
                    }
                }
                startAngle += arcAngle;
            }
        }

        Shape getDonutSliceShape(Rectangle2D pieBounds, double thickness, double start, double extent) {
            thickness /= 2.0;
            GeneralPath generalPath = new GeneralPath();
            GeneralPath dummy = new GeneralPath();
            double x = pieBounds.getX();
            double y = pieBounds.getY();
            double width = pieBounds.getWidth();
            double height = pieBounds.getHeight();
            Arc2D.Double outer = new Arc2D.Double(x, y, width, height, start, extent, 0);
            double wt = width * thickness;
            double ht = height * thickness;
            Arc2D.Double inner = new Arc2D.Double(x + wt, y + ht, width - 2.0 * wt, height - 2.0 * ht, start + extent, -extent, 0);
            generalPath.append(outer, false);
            dummy.append(new Arc2D.Double(x + wt, y + ht, width - 2.0 * wt, height - 2.0 * ht, start, extent, 0), false);
            Point2D point = dummy.getCurrentPoint();
            if (point != null) {
                generalPath.lineTo(point.getX(), point.getY());
            }
            generalPath.append(inner, false);
            dummy.append(new Arc2D.Double(x, y, width, height, start + extent, -extent, 0), false);
            point = dummy.getCurrentPoint();
            generalPath.lineTo(point.getX(), point.getY());
            return generalPath;
        }
    }

    private static class PiePlot<ST extends PieStyler, S extends PieSeries>
    extends CircularPlot<ST, S> {
        private ContentPlot<ST, S> contentPlot;
        private SurfacePlot<ST, S> surfacePlot;

        private PiePlot(Chart<ST, S> chart) {
            super(chart);
        }

        @Override
        protected void initContentAndSurface(Chart<ST, S> chart) {
            this.contentPlot = new ContentPlotPie<ST, S>(chart);
            this.surfacePlot = new SurfacePlotPie<ST, S>(chart);
        }

        @Override
        public void paint(Graphics2D g) {
            super.paint(g);
            this.surfacePlot.paint(g);
            if (this.chart.getSeriesMap().isEmpty()) {
                return;
            }
            this.contentPlot.paint(g);
        }
    }
}

