/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.pie;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.legend.AbstractLegend;
import org.xbib.graphics.chart.legend.LegendLayout;
import org.xbib.graphics.chart.legend.LegendRenderType;
import org.xbib.graphics.chart.pie.PieSeries;
import org.xbib.graphics.chart.pie.PieStyler;

public class PieLegend<ST extends PieStyler, S extends PieSeries>
extends AbstractLegend<ST, S> {
    public PieLegend(Chart<ST, S> chart) {
        super(chart);
    }

    @Override
    public void doPaint(Graphics2D g) {
        double startx = this.xOffset + (double)((PieStyler)this.chart.getStyler()).getLegendPadding();
        double starty = this.yOffset + (double)((PieStyler)this.chart.getStyler()).getLegendPadding();
        Object oldHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Map map = this.chart.getSeriesMap();
        for (PieSeries series : map.values()) {
            if (series.isNotShownInLegend() || !series.isEnabled()) continue;
            Map<String, Rectangle2D> seriesTextBounds = this.getSeriesTextBounds(series);
            float legendEntryHeight = this.getLegendEntryHeight(seriesTextBounds, 20);
            Rectangle2D.Double rectSmall = new Rectangle2D.Double(startx, starty, 20.0, 20.0);
            g.setColor(series.getFillColor());
            g.fill(rectSmall);
            double x = startx + 20.0 + (double)((PieStyler)this.chart.getStyler()).getLegendPadding();
            this.paintSeriesText(g, seriesTextBounds, 20, x, starty);
            if (((PieStyler)this.chart.getStyler()).getLegendLayout() == LegendLayout.Vertical) {
                starty += (double)(legendEntryHeight + (float)((PieStyler)this.chart.getStyler()).getLegendPadding());
                continue;
            }
            int markerWidth = 20;
            if (series.getLegendRenderType() == LegendRenderType.Line) {
                markerWidth = ((PieStyler)this.chart.getStyler()).getLegendSeriesLineLength();
            }
            float legendEntryWidth = this.getLegendEntryWidth(seriesTextBounds, markerWidth);
            startx += (double)(legendEntryWidth + (float)((PieStyler)this.chart.getStyler()).getLegendPadding());
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }

    @Override
    public double getSeriesLegendRenderGraphicHeight(S series) {
        return 20.0;
    }
}

