/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.pie;

import java.awt.Font;
import org.xbib.graphics.chart.pie.PieSeriesRenderStyle;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;

public class PieStyler
extends Styler {
    private PieSeriesRenderStyle pieSeriesRenderStyle;
    private boolean isCircular;
    private double startAngleInDegrees;
    private Font annotationFont;
    private double annotationDistance;
    private AnnotationType annotationType;
    private boolean drawAllAnnotations;
    private double donutThickness;
    private boolean isSumVisible;
    private Font sumFont;

    public PieStyler() {
        this.setAllStyles();
    }

    @Override
    protected void setAllStyles() {
        this.pieSeriesRenderStyle = PieSeriesRenderStyle.Pie;
        this.isCircular = this.theme.isCircular();
        this.annotationFont = this.theme.getPieFont();
        this.annotationDistance = this.theme.getAnnotationDistance();
        this.annotationType = this.theme.getAnnotationType();
        this.drawAllAnnotations = this.theme.isDrawAllAnnotations();
        this.donutThickness = this.theme.getDonutThickness();
        this.hasAnnotations = true;
        this.isSumVisible = this.theme.isSumVisible();
        this.sumFont = this.theme.getSumFont();
    }

    public PieSeriesRenderStyle getDefaultSeriesRenderStyle() {
        return this.pieSeriesRenderStyle;
    }

    public void setDefaultSeriesRenderStyle(PieSeriesRenderStyle pieSeriesRenderStyle) {
        this.pieSeriesRenderStyle = pieSeriesRenderStyle;
    }

    public boolean isCircular() {
        return this.isCircular;
    }

    public void setCircular(boolean isCircular) {
        this.isCircular = isCircular;
    }

    public double getStartAngleInDegrees() {
        return this.startAngleInDegrees;
    }

    public void setStartAngleInDegrees(double startAngleInDegrees) {
        this.startAngleInDegrees = startAngleInDegrees;
    }

    public void setAnnotationFont(Font pieFont) {
        this.annotationFont = pieFont;
    }

    public Font getAnnotationFont() {
        return this.annotationFont;
    }

    public void setAnnotationDistance(double annotationDistance) {
        this.annotationDistance = annotationDistance;
    }

    public double getAnnotationDistance() {
        return this.annotationDistance;
    }

    public void setAnnotationType(AnnotationType annotationType) {
        this.annotationType = annotationType;
    }

    public AnnotationType getAnnotationType() {
        return this.annotationType;
    }

    public void setDrawAllAnnotations(boolean drawAllAnnotations) {
        this.drawAllAnnotations = drawAllAnnotations;
    }

    public boolean isDrawAllAnnotations() {
        return this.drawAllAnnotations;
    }

    public void setDonutThickness(double donutThickness) {
        this.donutThickness = donutThickness;
    }

    public double getDonutThickness() {
        return this.donutThickness;
    }

    public void setSumVisible(boolean isSumVisible) {
        this.isSumVisible = isSumVisible;
    }

    public boolean isSumVisible() {
        return this.isSumVisible;
    }

    public void setSumFontSize(float sumFontSize) {
        this.sumFont = this.sumFont.deriveFont(sumFontSize);
    }

    public Font getSumFont() {
        return this.sumFont;
    }

    public void setSumFont(Font sumFont) {
        this.sumFont = sumFont;
    }

    public void setTheme(Theme theme) {
        this.theme = theme;
        super.setAllStyles();
    }

    public Theme getTheme() {
        return this.theme;
    }

    public static enum AnnotationType {
        Value,
        Percentage,
        Label,
        LabelAndPercentage;

    }
}

