/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.plot.ContentPlot;
import org.xbib.graphics.chart.plot.Plot;
import org.xbib.graphics.chart.plot.SurfacePlot;
import org.xbib.graphics.chart.plot.SurfacePlotAxesChart;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.AxesChartStyler;

public class AxesChartPlot<ST extends AxesChartStyler, S extends Series>
extends Plot<ST, S> {
    protected ContentPlot<ST, S> contentPlot;
    protected SurfacePlot<ST, S> surfacePlot;
    protected Rectangle2D bounds;

    public AxesChartPlot(Chart<ST, S> chart) {
        super(chart);
        this.surfacePlot = new SurfacePlotAxesChart<ST, S>(chart);
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle2D.Double yAxisBounds = this.chart.getAxisPair().getLeftYAxisBounds();
        Rectangle2D xAxisBounds = this.chart.getXAxis().getBounds();
        double xOffset = xAxisBounds.getX();
        double yOffset = ((RectangularShape)yAxisBounds).getY();
        double width = xAxisBounds.getWidth();
        double height = ((RectangularShape)yAxisBounds).getHeight();
        this.bounds = new Rectangle2D.Double(xOffset, yOffset, width, height);
        this.surfacePlot.paint(g);
        if (this.chart.getSeriesMap().isEmpty()) {
            return;
        }
        this.contentPlot.paint(g);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }
}

