/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.plot;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.legend.LegendPosition;
import org.xbib.graphics.chart.plot.Plot;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.Styler;

public abstract class CircularPlot<ST extends Styler, S extends Series>
extends Plot<ST, S> {
    protected Rectangle2D bounds;

    public CircularPlot(Chart<ST, S> chart) {
        super(chart);
        this.initContentAndSurface(chart);
    }

    protected abstract void initContentAndSurface(Chart<ST, S> var1);

    @Override
    public void paint(Graphics2D g) {
        double xOffset = ((Styler)this.chart.getStyler()).getChartPadding();
        double yOffset = this.chart.getChartTitle().getBounds().getHeight() + (double)((Styler)this.chart.getStyler()).getChartPadding();
        double width = (double)this.chart.getWidth() - (((Styler)this.chart.getStyler()).getLegendPosition() == LegendPosition.OutsideE ? this.chart.getLegend().getBounds().getWidth() : 0.0) - (double)(2 * ((Styler)this.chart.getStyler()).getChartPadding()) - (double)(((Styler)this.chart.getStyler()).getLegendPosition() == LegendPosition.OutsideE && ((Styler)this.chart.getStyler()).isLegendVisible() ? ((Styler)this.chart.getStyler()).getChartPadding() : 0);
        double height = (double)this.chart.getHeight() - this.chart.getChartTitle().getBounds().getHeight() - (((Styler)this.chart.getStyler()).getLegendPosition() == LegendPosition.OutsideS ? this.chart.getLegend().getBounds().getHeight() : 0.0) - (double)(2 * ((Styler)this.chart.getStyler()).getChartPadding());
        this.bounds = new Rectangle2D.Double(xOffset, yOffset, width, height);
    }

    @Override
    public Rectangle2D getBounds() {
        return this.bounds;
    }
}

