/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.plot;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.ChartComponent;
import org.xbib.graphics.chart.plot.Plot;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.Styler;

public abstract class ContentPlot<ST extends Styler, S extends Series>
extends Plot<ST, S>
implements ChartComponent {
    public ContentPlot(Chart<ST, S> chart) {
        super(chart);
    }

    @Override
    public void paint(Graphics2D g) {
        Rectangle2D bounds = this.getBounds();
        if (bounds != null) {
            if (bounds.getWidth() < 30.0) {
                return;
            }
            Shape saveClip = g.getClip();
            g.setClip(bounds.createIntersection(bounds));
            this.doPaint(g);
            g.setClip(saveClip);
        }
    }

    protected void closePath(Graphics2D g, Path2D.Double path, double previousX, double yTopMargin) {
        if (path != null) {
            double yBottomOfArea = this.getBounds().getY() + this.getBounds().getHeight() - yTopMargin;
            path.lineTo(previousX, yBottomOfArea);
            path.closePath();
            g.fill(path);
        }
    }

    protected abstract void doPaint(Graphics2D var1);
}

