/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.plot;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.util.List;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.plot.SurfacePlot;
import org.xbib.graphics.chart.series.Series;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.style.Styler;

public class SurfacePlotAxesChart<ST extends AxesChartStyler, S extends Series>
extends SurfacePlot<ST, S> {
    private final ST axesChartStyler;

    protected SurfacePlotAxesChart(Chart<ST, S> chart) {
        super(chart);
        this.axesChartStyler = (AxesChartStyler)chart.getStyler();
    }

    @Override
    public void paint(Graphics2D g) {
        Shape line;
        double yOffset;
        List<Double> yAxisTickLocations;
        Rectangle2D bounds = this.getBounds();
        Rectangle2D.Double rect = new Rectangle2D.Double(bounds.getX(), bounds.getY(), bounds.getWidth(), bounds.getHeight());
        g.setColor(((Styler)this.axesChartStyler).getPlotBackgroundColor());
        g.fill(rect);
        if (((AxesChartStyler)this.axesChartStyler).isPlotGridHorizontalLinesVisible()) {
            yAxisTickLocations = this.chart.getYAxis().getAxisTickCalculator().getTickLocations();
            for (Double yAxisTickLocation : yAxisTickLocations) {
                yOffset = bounds.getY() + bounds.getHeight() - yAxisTickLocation;
                if (!(yOffset > bounds.getY()) || !(yOffset < bounds.getY() + bounds.getHeight())) continue;
                g.setColor(((AxesChartStyler)this.axesChartStyler).getPlotGridLinesColor());
                g.setStroke(((AxesChartStyler)this.axesChartStyler).getPlotGridLinesStroke());
                line = ((AxesChartStyler)this.axesChartStyler).getPlotGridLinesStroke().createStrokedShape(new Line2D.Double(bounds.getX(), yOffset, bounds.getX() + bounds.getWidth(), yOffset));
                g.draw(line);
            }
        }
        if (((AxesChartStyler)this.axesChartStyler).isPlotTicksMarksVisible()) {
            yAxisTickLocations = this.chart.getAxisPair().getLeftMainYAxis().getAxisTickCalculator().getTickLocations();
            for (Double yAxisTickLocation : yAxisTickLocations) {
                yOffset = bounds.getY() + bounds.getHeight() - yAxisTickLocation;
                if (!(yOffset > bounds.getY()) || !(yOffset < bounds.getY() + bounds.getHeight())) continue;
                g.setColor(((AxesChartStyler)this.axesChartStyler).getAxisTickMarksColor());
                g.setStroke(((AxesChartStyler)this.axesChartStyler).getAxisTickMarksStroke());
                line = new Line2D.Double(bounds.getX(), yOffset, bounds.getX() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength(), yOffset);
                g.draw(line);
            }
            yAxisTickLocations = this.chart.getAxisPair().getRightMainYAxis().getAxisTickCalculator().getTickLocations();
            for (Double yAxisTickLocation : yAxisTickLocations) {
                yOffset = bounds.getY() + bounds.getHeight() - yAxisTickLocation;
                if (!(yOffset > bounds.getY()) || !(yOffset < bounds.getY() + bounds.getHeight())) continue;
                g.setColor(((AxesChartStyler)this.axesChartStyler).getAxisTickMarksColor());
                g.setStroke(((AxesChartStyler)this.axesChartStyler).getAxisTickMarksStroke());
                line = new Line2D.Double(bounds.getX() + bounds.getWidth(), yOffset, bounds.getX() + bounds.getWidth() - (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength(), yOffset);
                g.draw(line);
            }
        }
        if (((AxesChartStyler)this.axesChartStyler).isPlotGridVerticalLinesVisible() || ((AxesChartStyler)this.axesChartStyler).isPlotTicksMarksVisible()) {
            List<Double> xAxisTickLocations = this.chart.getXAxis().getAxisTickCalculator().getTickLocations();
            for (Double xAxisTickLocation : xAxisTickLocations) {
                Shape line2;
                double tickLocation = xAxisTickLocation;
                double xOffset = bounds.getX() + tickLocation;
                if (!(xOffset > bounds.getX()) || !(xOffset < bounds.getX() + bounds.getWidth())) continue;
                if (((AxesChartStyler)this.axesChartStyler).isPlotGridVerticalLinesVisible()) {
                    g.setColor(((AxesChartStyler)this.axesChartStyler).getPlotGridLinesColor());
                    g.setStroke(((AxesChartStyler)this.axesChartStyler).getPlotGridLinesStroke());
                    line2 = ((AxesChartStyler)this.axesChartStyler).getPlotGridLinesStroke().createStrokedShape(new Line2D.Double(xOffset, bounds.getY(), xOffset, bounds.getY() + bounds.getHeight()));
                    g.draw(line2);
                }
                if (!((AxesChartStyler)this.axesChartStyler).isPlotTicksMarksVisible()) continue;
                g.setColor(((AxesChartStyler)this.axesChartStyler).getAxisTickMarksColor());
                g.setStroke(((AxesChartStyler)this.axesChartStyler).getAxisTickMarksStroke());
                line2 = new Line2D.Double(xOffset, bounds.getY(), xOffset, bounds.getY() + (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength());
                g.draw(line2);
                line2 = new Line2D.Double(xOffset, bounds.getY() + bounds.getHeight(), xOffset, bounds.getY() + bounds.getHeight() - (double)((AxesChartStyler)this.axesChartStyler).getAxisTickMarkLength());
                g.draw(line2);
            }
        }
        if (((Styler)this.axesChartStyler).isPlotBorderVisible()) {
            g.setColor(((Styler)this.axesChartStyler).getPlotBorderColor());
            g.setStroke(new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{3.0f, 0.0f}, 0.0f));
            g.draw(rect);
        }
    }
}

