/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.series;

import java.awt.BasicStroke;
import java.awt.Color;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.series.Series;

public abstract class AxesChartSeries
extends Series {
    private final DataType xAxisType;
    private final DataType yAxisType;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private BasicStroke stroke;
    private Color lineColor;
    private float lineWidth = -1.0f;

    public AxesChartSeries(String name, DataType xAxisType) {
        super(name);
        this.xAxisType = xAxisType;
        this.yAxisType = DataType.Number;
    }

    protected abstract void calculateMinMax();

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public DataType getxAxisDataType() {
        return this.xAxisType;
    }

    public DataType getyAxisDataType() {
        return this.yAxisType;
    }

    public void setXMin(double xMin) {
        this.xMin = xMin;
    }

    public double getXMin() {
        return this.xMin;
    }

    public void setXMax(double xMax) {
        this.xMax = xMax;
    }

    public double getXMax() {
        return this.xMax;
    }

    public void setYMin(double yMin) {
        this.yMin = yMin;
    }

    public double getYMin() {
        return this.yMin;
    }

    public void setYMax(double yMax) {
        this.yMax = yMax;
    }

    public double getYMax() {
        return this.yMax;
    }

    public void setLineStyle(BasicStroke basicStroke) {
        this.stroke = basicStroke;
        if (this.lineWidth > 0.0f) {
            this.stroke = new BasicStroke(this.lineWidth, this.stroke.getEndCap(), this.stroke.getLineJoin(), this.stroke.getMiterLimit(), this.stroke.getDashArray(), this.stroke.getDashPhase());
        }
    }

    public BasicStroke getLineStyle() {
        return this.stroke;
    }

    public AxesChartSeries setLineWidth(float lineWidth) {
        this.lineWidth = lineWidth;
        return this;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }
}

