/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.series;

import java.time.Instant;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.series.MarkerSeries;

public abstract class AxesChartSeriesCategory
extends MarkerSeries {
    private final List<?> xData;
    private final List<? extends Number> yData;
    private final List<? extends Number> extraValues;

    public AxesChartSeriesCategory(String name, List<?> xData, List<? extends Number> yData, List<? extends Number> extraValues, DataType xDataType) {
        super(name, xDataType);
        this.xData = xData;
        this.yData = yData;
        this.extraValues = extraValues;
        this.calculateMinMax();
    }

    @Override
    protected void calculateMinMax() {
        double[] xMinMax = this.findMinMax(this.xData, this.getxAxisDataType());
        this.setXMin(xMinMax[0]);
        this.setXMax(xMinMax[1]);
        double[] yMinMax = this.extraValues == null ? this.findMinMax(this.yData, this.getyAxisDataType()) : this.findMinMaxWithErrorBars(this.yData, this.extraValues);
        this.setYMin(yMinMax[0]);
        this.setYMax(yMinMax[1]);
    }

    private double[] findMinMaxWithErrorBars(Collection<? extends Number> data, Collection<? extends Number> errorBars) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        Iterator<? extends Number> itr = data.iterator();
        Iterator<? extends Number> ebItr = errorBars.iterator();
        while (itr.hasNext()) {
            double eb;
            double bigDecimal = itr.next().doubleValue();
            if (bigDecimal - (eb = ebItr.next().doubleValue()) < min) {
                min = bigDecimal - eb;
            }
            if (!(bigDecimal + eb > max)) continue;
            max = bigDecimal + eb;
        }
        return new double[]{min, max};
    }

    private double[] findMinMax(Collection<?> data, DataType dataType) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (Object dataPoint : data) {
            if (dataPoint == null) continue;
            double value = 0.0;
            if (dataType == DataType.Number) {
                value = ((Number)dataPoint).doubleValue();
            } else if (dataType == DataType.Instant) {
                Instant date = (Instant)dataPoint;
                value = date.toEpochMilli();
            } else if (dataType == DataType.String) {
                return new double[]{Double.NaN, Double.NaN};
            }
            if (value < min) {
                min = value;
            }
            if (!(value > max)) continue;
            max = value;
        }
        return new double[]{min, max};
    }

    public Collection<?> getXData() {
        return this.xData;
    }

    public Collection<? extends Number> getYData() {
        return this.yData;
    }

    public Collection<? extends Number> getExtraValues() {
        return this.extraValues;
    }
}

