/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.series;

import java.math.BigDecimal;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.series.MarkerSeries;

public abstract class AxesChartSeriesNumericalNoErrorBars
extends MarkerSeries {
    protected List<?> xData;
    protected List<? extends Number> yData;
    protected List<? extends Number> extraValues;

    public AxesChartSeriesNumericalNoErrorBars(String name, List<?> xData, List<? extends Number> yData, List<? extends Number> extraValues, DataType xDataType) {
        super(name, xDataType);
        this.xData = xData;
        this.yData = yData;
        this.extraValues = extraValues;
        this.calculateMinMax();
    }

    @Override
    protected void calculateMinMax() {
        List<Double> xMinMax = this.findMinMax(this.xData);
        this.setXMin(xMinMax.get(0));
        this.setXMax(xMinMax.get(1));
        List<Double> yMinMax = this.extraValues == null ? this.findMinMax(this.yData) : this.findMinMaxWithErrorBars(this.yData, this.extraValues);
        this.setYMin(yMinMax.get(0));
        this.setYMax(yMinMax.get(1));
    }

    List<Double> findMinMax(List<?> data) {
        Double min = null;
        Double max = null;
        for (Object dataPoint : data) {
            if (dataPoint instanceof Double) {
                Double d = (Double)dataPoint;
                if (min == null) {
                    min = d;
                }
                if (max == null) {
                    max = d;
                }
                if (Double.isNaN(d)) continue;
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
                continue;
            }
            if (dataPoint instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)dataPoint;
                if (min == null) {
                    min = bd.doubleValue();
                }
                if (max == null) {
                    max = bd.doubleValue();
                }
                if (bd.doubleValue() < min) {
                    min = bd.doubleValue();
                }
                if (!(bd.doubleValue() > max)) continue;
                max = bd.doubleValue();
                continue;
            }
            if (dataPoint instanceof Integer) {
                int i = (Integer)dataPoint;
                if (min == null) {
                    min = i;
                }
                if (max == null) {
                    max = i;
                }
                if ((double)i < min) {
                    min = i;
                }
                if (!((double)i > max)) continue;
                max = i;
                continue;
            }
            if (!(dataPoint instanceof Instant)) continue;
            Instant instant = (Instant)dataPoint;
            if (min == null) {
                min = instant.toEpochMilli();
            }
            if (max == null) {
                max = instant.toEpochMilli();
            }
            if ((double)instant.toEpochMilli() < min) {
                min = instant.toEpochMilli();
            }
            if (!((double)instant.toEpochMilli() > max)) continue;
            max = instant.toEpochMilli();
        }
        return Arrays.asList(min, max);
    }

    private List<Double> findMinMaxWithErrorBars(List<? extends Number> data, List<? extends Number> errorBars) {
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 0; i < data.size(); ++i) {
            Double eb;
            Number n = data.get(i);
            Double d = n instanceof Double ? (Double)n : null;
            Number nn = errorBars.get(i);
            Double d2 = eb = nn instanceof Double ? (Double)nn : null;
            if (d == null || eb == null) continue;
            if (d - eb < min) {
                min = d - eb;
            }
            if (!(d + eb > max)) continue;
            max = d + eb;
        }
        return Arrays.asList(min, max);
    }

    public List<?> getXData() {
        return this.xData;
    }

    public List<? extends Number> getYData() {
        return this.yData;
    }

    public List<? extends Number> getExtraValues() {
        return this.extraValues;
    }
}

