/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.style;

import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.time.ZoneId;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.xbib.graphics.chart.axis.TextAlignment;
import org.xbib.graphics.chart.style.Styler;

public abstract class AxesChartStyler
extends Styler {
    private boolean xAxisTitleVisible;
    private boolean yAxisTitleVisible;
    private Font axisTitleFont;
    private boolean xAxisTicksVisible;
    private boolean yAxisTicksVisible;
    private Font axisTickLabelsFont;
    private int axisTickMarkLength;
    private int axisTickPadding;
    private Color axisTickMarksColor;
    private Stroke axisTickMarksStroke;
    private Color axisTickLabelsColor;
    private boolean isAxisTicksLineVisible;
    private boolean isAxisTicksMarksVisible;
    private int plotMargin;
    private int axisTitlePadding;
    private int xAxisTickMarkSpacingHint;
    private int yAxisTickMarkSpacingHint;
    private boolean isXAxisLogarithmic;
    private boolean isYAxisLogarithmic;
    private Double xAxisMin;
    private Double xAxisMax;
    private final Map<Integer, Double> yAxisMinMap = new HashMap<Integer, Double>();
    private final Map<Integer, Double> yAxisMaxMap = new HashMap<Integer, Double>();
    private TextAlignment xAxisLabelAlignment = TextAlignment.Centre;
    private TextAlignment xAxisLabelAlignmentVertical = TextAlignment.Centre;
    private TextAlignment yAxisLabelAlignment = TextAlignment.Left;
    private int xAxisLabelRotation = 0;
    private boolean isPlotGridHorizontalLinesVisible;
    private boolean isPlotGridVerticalLinesVisible;
    private boolean isPlotTicksMarksVisible;
    private Color plotGridLinesColor;
    private Stroke plotGridLinesStroke;
    private int markerSize;
    private Color errorBarsColor;
    private boolean isErrorBarsColorSeriesColor;
    private Locale locale;
    private ZoneId zoneId;
    private String datePattern;
    private String decimalPattern;
    private String xAxisDecimalPattern;
    private String yAxisDecimalPattern;
    private boolean xAxisLogarithmicDecadeOnly;
    private boolean yAxisLogarithmicDecadeOnly;

    @Override
    protected void setAllStyles() {
        super.setAllStyles();
        this.xAxisTitleVisible = this.theme.isXAxisTitleVisible();
        this.yAxisTitleVisible = this.theme.isYAxisTitleVisible();
        this.axisTitleFont = this.theme.getAxisTitleFont();
        this.xAxisTicksVisible = this.theme.isXAxisTicksVisible();
        this.yAxisTicksVisible = this.theme.isYAxisTicksVisible();
        this.axisTickLabelsFont = this.theme.getAxisTickLabelsFont();
        this.axisTickMarkLength = this.theme.getAxisTickMarkLength();
        this.axisTickPadding = this.theme.getAxisTickPadding();
        this.axisTickMarksColor = this.theme.getAxisTickMarksColor();
        this.axisTickMarksStroke = this.theme.getAxisTickMarksStroke();
        this.axisTickLabelsColor = this.theme.getAxisTickLabelsColor();
        this.isAxisTicksLineVisible = this.theme.isAxisTicksLineVisible();
        this.isAxisTicksMarksVisible = this.theme.isAxisTicksMarksVisible();
        this.plotMargin = this.theme.getPlotMargin();
        this.axisTitlePadding = this.theme.getAxisTitlePadding();
        this.xAxisTickMarkSpacingHint = this.theme.getXAxisTickMarkSpacingHint();
        this.yAxisTickMarkSpacingHint = this.theme.getYAxisTickMarkSpacingHint();
        this.isXAxisLogarithmic = false;
        this.isYAxisLogarithmic = false;
        this.xAxisMin = null;
        this.xAxisMax = null;
        this.yAxisMinMap.clear();
        this.yAxisMaxMap.clear();
        this.isPlotGridVerticalLinesVisible = this.theme.isPlotGridVerticalLinesVisible();
        this.isPlotGridHorizontalLinesVisible = this.theme.isPlotGridHorizontalLinesVisible();
        this.isPlotTicksMarksVisible = this.theme.isPlotTicksMarksVisible();
        this.plotGridLinesColor = this.theme.getPlotGridLinesColor();
        this.plotGridLinesStroke = this.theme.getPlotGridLinesStroke();
        this.markerSize = this.theme.getMarkerSize();
        this.errorBarsColor = this.theme.getErrorBarsColor();
        this.isErrorBarsColorSeriesColor = this.theme.isErrorBarsColorSeriesColor();
        this.locale = Locale.getDefault();
        this.zoneId = ZoneId.of("UTC");
        this.datePattern = "YYYY-MM-dd";
        this.decimalPattern = null;
        this.xAxisDecimalPattern = null;
        this.yAxisDecimalPattern = null;
    }

    public boolean isXAxisTitleVisible() {
        return this.xAxisTitleVisible;
    }

    public void setXAxisTitleVisible(boolean xAxisTitleVisible) {
        this.xAxisTitleVisible = xAxisTitleVisible;
    }

    public boolean isYAxisTitleVisible() {
        return this.yAxisTitleVisible;
    }

    public void setYAxisTitleVisible(boolean yAxisTitleVisible) {
        this.yAxisTitleVisible = yAxisTitleVisible;
    }

    public void setAxisTitlesVisible(boolean isVisible) {
        this.xAxisTitleVisible = isVisible;
        this.yAxisTitleVisible = isVisible;
    }

    public Font getAxisTitleFont() {
        return this.axisTitleFont;
    }

    public void setAxisTitleFont(Font axisTitleFont) {
        this.axisTitleFont = axisTitleFont;
    }

    public boolean isXAxisTicksVisible() {
        return this.xAxisTicksVisible;
    }

    public void setXAxisTicksVisible(boolean xAxisTicksVisible) {
        this.xAxisTicksVisible = xAxisTicksVisible;
    }

    public boolean isYAxisTicksVisible() {
        return this.yAxisTicksVisible;
    }

    public void setYAxisTicksVisible(boolean yAxisTicksVisible) {
        this.yAxisTicksVisible = yAxisTicksVisible;
    }

    public void setAxisTicksVisible(boolean isVisible) {
        this.xAxisTicksVisible = isVisible;
        this.yAxisTicksVisible = isVisible;
    }

    public Font getAxisTickLabelsFont() {
        return this.axisTickLabelsFont;
    }

    public void setAxisTickLabelsFont(Font axisTicksFont) {
        this.axisTickLabelsFont = axisTicksFont;
    }

    public int getAxisTickMarkLength() {
        return this.axisTickMarkLength;
    }

    public void setAxisTickMarkLength(int axisTickMarkLength) {
        this.axisTickMarkLength = axisTickMarkLength;
    }

    public int getAxisTickPadding() {
        return this.axisTickPadding;
    }

    public void setAxisTickPadding(int axisTickPadding) {
        this.axisTickPadding = axisTickPadding;
    }

    public Color getAxisTickMarksColor() {
        return this.axisTickMarksColor;
    }

    public void setAxisTickMarksColor(Color axisTickColor) {
        this.axisTickMarksColor = axisTickColor;
    }

    public Stroke getAxisTickMarksStroke() {
        return this.axisTickMarksStroke;
    }

    public void setAxisTickMarksStroke(Stroke axisTickMarksStroke) {
        this.axisTickMarksStroke = axisTickMarksStroke;
    }

    public Color getAxisTickLabelsColor() {
        return this.axisTickLabelsColor;
    }

    public void setAxisTickLabelsColor(Color axisTickLabelsColor) {
        this.axisTickLabelsColor = axisTickLabelsColor;
    }

    public boolean isAxisTicksLineVisible() {
        return this.isAxisTicksLineVisible;
    }

    public void setAxisTicksLineVisible(boolean isAxisTicksLineVisible) {
        this.isAxisTicksLineVisible = isAxisTicksLineVisible;
    }

    public boolean isAxisTicksMarksVisible() {
        return this.isAxisTicksMarksVisible;
    }

    public void setAxisTicksMarksVisible(boolean isAxisTicksMarksVisible) {
        this.isAxisTicksMarksVisible = isAxisTicksMarksVisible;
    }

    public int getPlotMargin() {
        return this.plotMargin;
    }

    public void setPlotMargin(int plotMargin) {
        this.plotMargin = plotMargin;
    }

    public int getAxisTitlePadding() {
        return this.axisTitlePadding;
    }

    public void setAxisTitlePadding(int axisTitlePadding) {
        this.axisTitlePadding = axisTitlePadding;
    }

    public int getXAxisTickMarkSpacingHint() {
        return this.xAxisTickMarkSpacingHint;
    }

    public void setXAxisTickMarkSpacingHint(int xAxisTickMarkSpacingHint) {
        this.xAxisTickMarkSpacingHint = xAxisTickMarkSpacingHint;
    }

    public int getYAxisTickMarkSpacingHint() {
        return this.yAxisTickMarkSpacingHint;
    }

    public void setYAxisTickMarkSpacingHint(int yAxisTickMarkSpacingHint) {
        this.yAxisTickMarkSpacingHint = yAxisTickMarkSpacingHint;
    }

    public boolean isXAxisLogarithmic() {
        return this.isXAxisLogarithmic;
    }

    public void setXAxisLogarithmic(boolean isXAxisLogarithmic) {
        this.isXAxisLogarithmic = isXAxisLogarithmic;
    }

    public boolean isYAxisLogarithmic() {
        return this.isYAxisLogarithmic;
    }

    public void setYAxisLogarithmic(boolean isYAxisLogarithmic) {
        this.isYAxisLogarithmic = isYAxisLogarithmic;
    }

    public Double getXAxisMin() {
        return this.xAxisMin;
    }

    public void setXAxisMin(double xAxisMin) {
        this.xAxisMin = xAxisMin;
    }

    public Double getXAxisMax() {
        return this.xAxisMax;
    }

    public void setXAxisMax(double xAxisMax) {
        this.xAxisMax = xAxisMax;
    }

    public Double getYAxisMin() {
        return this.yAxisMinMap.get(null);
    }

    public AxesChartStyler setYAxisMin(Double yAxisMin) {
        this.yAxisMinMap.put(null, yAxisMin);
        return this;
    }

    public Double getYAxisMin(Integer yAxisGroup) {
        return this.yAxisMinMap.get(yAxisGroup);
    }

    public AxesChartStyler setYAxisMax(Integer yAxisGroup, Double yAxisMax) {
        this.yAxisMaxMap.put(yAxisGroup, yAxisMax);
        return this;
    }

    public Double getYAxisMax() {
        return this.yAxisMaxMap.get(null);
    }

    public AxesChartStyler setYAxisMax(Double yAxisMax) {
        this.yAxisMaxMap.put(null, yAxisMax);
        return this;
    }

    public Double getYAxisMax(Integer yAxisGroup) {
        return this.yAxisMaxMap.get(yAxisGroup);
    }

    public TextAlignment getXAxisLabelAlignment() {
        return this.xAxisLabelAlignment;
    }

    public void setXAxisLabelAlignment(TextAlignment xAxisLabelAlignment) {
        this.xAxisLabelAlignment = xAxisLabelAlignment;
    }

    public TextAlignment getYAxisLabelAlignment() {
        return this.yAxisLabelAlignment;
    }

    public void setYAxisLabelAlignment(TextAlignment yAxisLabelAlignment) {
        this.yAxisLabelAlignment = yAxisLabelAlignment;
    }

    public int getXAxisLabelRotation() {
        return this.xAxisLabelRotation;
    }

    public void setXAxisLabelRotation(int xAxisLabelRotation) {
        this.xAxisLabelRotation = xAxisLabelRotation;
    }

    public boolean isPlotGridLinesVisible() {
        return this.isPlotGridHorizontalLinesVisible && this.isPlotGridVerticalLinesVisible;
    }

    public void setPlotGridLinesVisible(boolean isPlotGridLinesVisible) {
        this.isPlotGridHorizontalLinesVisible = isPlotGridLinesVisible;
        this.isPlotGridVerticalLinesVisible = isPlotGridLinesVisible;
    }

    public boolean isPlotGridHorizontalLinesVisible() {
        return this.isPlotGridHorizontalLinesVisible;
    }

    public void setPlotGridHorizontalLinesVisible(boolean isPlotGridHorizontalLinesVisible) {
        this.isPlotGridHorizontalLinesVisible = isPlotGridHorizontalLinesVisible;
    }

    public boolean isPlotGridVerticalLinesVisible() {
        return this.isPlotGridVerticalLinesVisible;
    }

    public void setPlotGridVerticalLinesVisible(boolean isPlotGridVerticalLinesVisible) {
        this.isPlotGridVerticalLinesVisible = isPlotGridVerticalLinesVisible;
    }

    public boolean isPlotTicksMarksVisible() {
        return this.isPlotTicksMarksVisible;
    }

    public void setPlotTicksMarksVisible(boolean isPlotTicksMarksVisible) {
        this.isPlotTicksMarksVisible = isPlotTicksMarksVisible;
    }

    public Color getPlotGridLinesColor() {
        return this.plotGridLinesColor;
    }

    public void setPlotGridLinesColor(Color plotGridLinesColor) {
        this.plotGridLinesColor = plotGridLinesColor;
    }

    public Stroke getPlotGridLinesStroke() {
        return this.plotGridLinesStroke;
    }

    public void setPlotGridLinesStroke(Stroke plotGridLinesStroke) {
        this.plotGridLinesStroke = plotGridLinesStroke;
    }

    public int getMarkerSize() {
        return this.markerSize;
    }

    public void setMarkerSize(int markerSize) {
        this.markerSize = markerSize;
    }

    public Color getErrorBarsColor() {
        return this.errorBarsColor;
    }

    public void setErrorBarsColor(Color errorBarsColor) {
        this.errorBarsColor = errorBarsColor;
    }

    public boolean isErrorBarsColorSeriesColor() {
        return this.isErrorBarsColorSeriesColor;
    }

    public void setErrorBarsColorSeriesColor(boolean isErrorBarsColorSeriesColor) {
        this.isErrorBarsColorSeriesColor = isErrorBarsColorSeriesColor;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public ZoneId getZoneId() {
        return this.zoneId;
    }

    public void setZoneId(ZoneId zoneId) {
        this.zoneId = zoneId;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void setDatePattern(String datePattern) {
        this.datePattern = datePattern;
    }

    @Override
    public String getDecimalPattern() {
        return this.decimalPattern;
    }

    @Override
    public void setDecimalPattern(String decimalPattern) {
        this.decimalPattern = decimalPattern;
    }

    public String getXAxisDecimalPattern() {
        return this.xAxisDecimalPattern;
    }

    public void setXAxisDecimalPattern(String xAxisDecimalPattern) {
        this.xAxisDecimalPattern = xAxisDecimalPattern;
    }

    public String getYAxisDecimalPattern() {
        return this.yAxisDecimalPattern;
    }

    public void setYAxisDecimalPattern(String yAxisDecimalPattern) {
        this.yAxisDecimalPattern = yAxisDecimalPattern;
    }

    public boolean isXAxisLogarithmicDecadeOnly() {
        return this.xAxisLogarithmicDecadeOnly;
    }

    public AxesChartStyler setXAxisLogarithmicDecadeOnly(boolean xAxisLogarithmicDecadeOnly) {
        this.xAxisLogarithmicDecadeOnly = xAxisLogarithmicDecadeOnly;
        return this;
    }

    public boolean isYAxisLogarithmicDecadeOnly() {
        return this.yAxisLogarithmicDecadeOnly;
    }

    public AxesChartStyler setYAxisLogarithmicDecadeOnly(boolean yAxisLogarithmicDecadeOnly) {
        this.yAxisLogarithmicDecadeOnly = yAxisLogarithmicDecadeOnly;
        return this;
    }

    public TextAlignment getXAxisLabelAlignmentVertical() {
        return this.xAxisLabelAlignmentVertical;
    }

    public void setXAxisLabelAlignmentVertical(TextAlignment xAxisLabelAlignmentVertical) {
        this.xAxisLabelAlignmentVertical = xAxisLabelAlignmentVertical;
    }
}

