/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.util.List;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyle;
import org.xbib.graphics.chart.theme.Theme;

public class SeriesColorMarkerLineStyleCycler {
    private final List<Color> seriesColorList;
    private final List<Theme.Series.Marker> seriesMarkerList;
    private final List<BasicStroke> seriesLineStyleList;
    private int colorCounter = 0;
    private int markerCounter = 0;
    private int strokeCounter = 0;

    public SeriesColorMarkerLineStyleCycler(List<Color> seriesColorList, List<Theme.Series.Marker> seriesMarkerList, List<BasicStroke> seriesLineStyleList) {
        this.seriesColorList = seriesColorList;
        this.seriesMarkerList = seriesMarkerList;
        this.seriesLineStyleList = seriesLineStyleList;
    }

    public SeriesColorMarkerLineStyle getNextSeriesColorMarkerLineStyle() {
        if (this.colorCounter >= this.seriesColorList.size()) {
            this.colorCounter = 0;
            ++this.strokeCounter;
        }
        Color seriesColor = this.seriesColorList.get(this.colorCounter++);
        if (this.strokeCounter >= this.seriesLineStyleList.size()) {
            this.strokeCounter = 0;
        }
        BasicStroke seriesLineStyle = this.seriesLineStyleList.get(this.strokeCounter);
        if (this.markerCounter >= this.seriesMarkerList.size()) {
            this.markerCounter = 0;
        }
        Theme.Series.Marker marker = this.seriesMarkerList.get(this.markerCounter++);
        return new SeriesColorMarkerLineStyle(seriesColor, marker, seriesLineStyle);
    }
}

