/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.style;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.util.HashMap;
import java.util.List;
import org.xbib.graphics.chart.axis.YAxisPosition;
import org.xbib.graphics.chart.legend.LegendLayout;
import org.xbib.graphics.chart.legend.LegendPosition;
import org.xbib.graphics.chart.theme.DefaultTheme;
import org.xbib.graphics.chart.theme.Theme;

public abstract class Styler {
    protected Theme theme = new DefaultTheme();
    protected boolean hasAnnotations = false;
    private Font baseFont;
    private Color chartBackgroundColor;
    private Color chartFontColor;
    private int chartPadding;
    private List<Color> seriesColors;
    private List<BasicStroke> seriesLines;
    private List<Theme.Series.Marker> seriesMarkers;
    private Font chartTitleFont;
    private boolean isChartTitleVisible;
    private boolean isChartTitleBoxVisible;
    private Color chartTitleBoxBackgroundColor;
    private Color chartTitleBoxBorderColor;
    private int chartTitlePadding;
    private boolean isLegendVisible;
    private Color legendBackgroundColor;
    private Color legendBorderColor;
    private Font legendFont;
    private int legendPadding;
    private int legendSeriesLineLength;
    private LegendPosition legendPosition;
    private LegendLayout legendLayout = LegendLayout.Vertical;
    private Color plotBackgroundColor;
    private Color plotBorderColor;
    private boolean isPlotBorderVisible;
    private double plotContentSize = 0.92;
    private Font annotationsFont;
    private boolean antiAlias = true;
    private String decimalPattern;
    private final HashMap<Integer, YAxisPosition> yAxisAlignmentMap = new HashMap();

    protected void setAllStyles() {
        this.chartBackgroundColor = this.theme.getChartBackgroundColor();
        this.chartFontColor = this.theme.getChartFontColor();
        this.chartPadding = this.theme.getChartPadding();
        this.seriesColors = this.theme.getSeriesColors();
        this.seriesLines = this.theme.getSeriesLines();
        this.seriesMarkers = this.theme.getSeriesMarkers();
        this.chartTitleFont = this.theme.getChartTitleFont();
        this.isChartTitleVisible = this.theme.isChartTitleVisible();
        this.isChartTitleBoxVisible = this.theme.isChartTitleBoxVisible();
        this.chartTitleBoxBackgroundColor = this.theme.getChartTitleBoxBackgroundColor();
        this.chartTitleBoxBorderColor = this.theme.getChartTitleBoxBorderColor();
        this.chartTitlePadding = this.theme.getChartTitlePadding();
        this.isLegendVisible = this.theme.isLegendVisible();
        this.legendBackgroundColor = this.theme.getLegendBackgroundColor();
        this.legendBorderColor = this.theme.getLegendBorderColor();
        this.legendFont = this.theme.getLegendFont();
        this.legendPadding = this.theme.getLegendPadding();
        this.legendSeriesLineLength = this.theme.getLegendSeriesLineLength();
        this.legendPosition = this.theme.getLegendPosition();
        this.plotBackgroundColor = this.theme.getPlotBackgroundColor();
        this.plotBorderColor = this.theme.getPlotBorderColor();
        this.isPlotBorderVisible = this.theme.isPlotBorderVisible();
        this.plotContentSize = this.theme.getPlotContentSize();
        this.annotationsFont = this.theme.getAnnotationFont();
        this.decimalPattern = null;
    }

    public Styler setBaseFont(Font baseFont) {
        this.baseFont = baseFont;
        return this;
    }

    public Font getBaseFont() {
        return this.baseFont;
    }

    public Color getChartBackgroundColor() {
        return this.chartBackgroundColor;
    }

    public void setChartBackgroundColor(Color color) {
        this.chartBackgroundColor = color;
    }

    public Color getChartFontColor() {
        return this.chartFontColor;
    }

    public void setChartFontColor(Color color) {
        this.chartFontColor = color;
    }

    public int getChartPadding() {
        return this.chartPadding;
    }

    public void setChartPadding(int chartPadding) {
        this.chartPadding = chartPadding;
    }

    public List<Color> getSeriesColors() {
        return this.seriesColors;
    }

    public void setSeriesColors(List<Color> seriesColors) {
        this.seriesColors = seriesColors;
    }

    public List<BasicStroke> getSeriesLines() {
        return this.seriesLines;
    }

    public void setSeriesLines(List<BasicStroke> seriesLines) {
        this.seriesLines = seriesLines;
    }

    public List<Theme.Series.Marker> getSeriesMarkers() {
        return this.seriesMarkers;
    }

    public void setSeriesMarkers(List<Theme.Series.Marker> seriesMarkers) {
        this.seriesMarkers = seriesMarkers;
    }

    public Font getChartTitleFont() {
        return this.chartTitleFont;
    }

    public void setChartTitleFont(Font chartTitleFont) {
        this.chartTitleFont = chartTitleFont;
    }

    public boolean isChartTitleVisible() {
        return this.isChartTitleVisible;
    }

    public void setChartTitleVisible(boolean isChartTitleVisible) {
        this.isChartTitleVisible = isChartTitleVisible;
    }

    public boolean isChartTitleBoxVisible() {
        return this.isChartTitleBoxVisible;
    }

    public void setChartTitleBoxVisible(boolean isChartTitleBoxVisible) {
        this.isChartTitleBoxVisible = isChartTitleBoxVisible;
    }

    public Color getChartTitleBoxBackgroundColor() {
        return this.chartTitleBoxBackgroundColor;
    }

    public void setChartTitleBoxBackgroundColor(Color chartTitleBoxBackgroundColor) {
        this.chartTitleBoxBackgroundColor = chartTitleBoxBackgroundColor;
    }

    public Color getChartTitleBoxBorderColor() {
        return this.chartTitleBoxBorderColor;
    }

    public void setChartTitleBoxBorderColor(Color chartTitleBoxBorderColor) {
        this.chartTitleBoxBorderColor = chartTitleBoxBorderColor;
    }

    public int getChartTitlePadding() {
        return this.chartTitlePadding;
    }

    public void setChartTitlePadding(int chartTitlePadding) {
        this.chartTitlePadding = chartTitlePadding;
    }

    public Color getLegendBackgroundColor() {
        return this.legendBackgroundColor;
    }

    public void setLegendBackgroundColor(Color color) {
        this.legendBackgroundColor = color;
    }

    public Color getLegendBorderColor() {
        return this.legendBorderColor;
    }

    public void setLegendBorderColor(Color legendBorderColor) {
        this.legendBorderColor = legendBorderColor;
    }

    public Font getLegendFont() {
        return this.legendFont;
    }

    public void setLegendFont(Font font) {
        this.legendFont = font;
    }

    public boolean isLegendVisible() {
        return this.isLegendVisible;
    }

    public void setLegendVisible(boolean isLegendVisible) {
        this.isLegendVisible = isLegendVisible;
    }

    public int getLegendPadding() {
        return this.legendPadding;
    }

    public void setLegendPadding(int legendPadding) {
        this.legendPadding = legendPadding;
    }

    public int getLegendSeriesLineLength() {
        return this.legendSeriesLineLength;
    }

    public void setLegendSeriesLineLength(int legendSeriesLineLength) {
        this.legendSeriesLineLength = legendSeriesLineLength < 0 ? 0 : legendSeriesLineLength;
    }

    public LegendPosition getLegendPosition() {
        return this.legendPosition;
    }

    public void setLegendPosition(LegendPosition legendPosition) {
        this.legendPosition = legendPosition;
    }

    public LegendLayout getLegendLayout() {
        return this.legendLayout;
    }

    public void setLegendLayout(LegendLayout legendLayout) {
        this.legendLayout = legendLayout;
    }

    public Color getPlotBackgroundColor() {
        return this.plotBackgroundColor;
    }

    public void setPlotBackgroundColor(Color plotBackgroundColor) {
        this.plotBackgroundColor = plotBackgroundColor;
    }

    public Color getPlotBorderColor() {
        return this.plotBorderColor;
    }

    public void setPlotBorderColor(Color plotBorderColor) {
        this.plotBorderColor = plotBorderColor;
    }

    public boolean isPlotBorderVisible() {
        return this.isPlotBorderVisible;
    }

    public void setPlotBorderVisible(boolean isPlotBorderVisible) {
        this.isPlotBorderVisible = isPlotBorderVisible;
    }

    public double getPlotContentSize() {
        return this.plotContentSize;
    }

    public void setPlotContentSize(double plotContentSize) {
        if (plotContentSize < 0.0 || plotContentSize > 1.0) {
            throw new IllegalArgumentException("Plot content size must be tween 0 and 1");
        }
        this.plotContentSize = plotContentSize;
    }

    public Boolean hasAnnotations() {
        return this.hasAnnotations;
    }

    public void setHasAnnotations(boolean hasAnnotations) {
        this.hasAnnotations = hasAnnotations;
    }

    public Font getAnnotationsFont() {
        return this.annotationsFont;
    }

    public void setAnnotationsFont(Font annotationsFont) {
        this.annotationsFont = annotationsFont;
    }

    public void setDecimalPattern(String decimalPattern) {
        this.decimalPattern = decimalPattern;
    }

    public String getDecimalPattern() {
        return this.decimalPattern;
    }

    public void setYAxisGroupPosition(int yAxisGroup, YAxisPosition yAxisPosition) {
        this.yAxisAlignmentMap.put(yAxisGroup, yAxisPosition);
    }

    public YAxisPosition getYAxisGroupPosistion(int yAxisGroup) {
        return this.yAxisAlignmentMap.get(yAxisGroup);
    }

    public void setAntiAlias(boolean newVal) {
        this.antiAlias = newVal;
    }

    public boolean getAntiAlias() {
        return this.antiAlias;
    }
}

