/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.theme;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xbib.graphics.chart.legend.LegendPosition;
import org.xbib.graphics.chart.pie.PieStyler;

public interface Theme {
    public Font getBaseFont();

    public Color getChartBackgroundColor();

    public Color getChartFontColor();

    public int getChartPadding();

    public Font getChartTitleFont();

    public boolean isChartTitleVisible();

    public boolean isChartTitleBoxVisible();

    public Color getChartTitleBoxBackgroundColor();

    public Color getChartTitleBoxBorderColor();

    public int getChartTitlePadding();

    public Font getLegendFont();

    public boolean isLegendVisible();

    public Color getLegendBackgroundColor();

    public Color getLegendBorderColor();

    public int getLegendPadding();

    public int getLegendSeriesLineLength();

    public LegendPosition getLegendPosition();

    public boolean isXAxisTitleVisible();

    public boolean isYAxisTitleVisible();

    public Font getAxisTitleFont();

    public boolean isXAxisTicksVisible();

    public boolean isYAxisTicksVisible();

    public Font getAxisTickLabelsFont();

    public int getAxisTickMarkLength();

    public int getAxisTickPadding();

    public Color getAxisTickMarksColor();

    public Stroke getAxisTickMarksStroke();

    public Color getAxisTickLabelsColor();

    public boolean isAxisTicksLineVisible();

    public boolean isAxisTicksMarksVisible();

    public int getAxisTitlePadding();

    public int getXAxisTickMarkSpacingHint();

    public int getYAxisTickMarkSpacingHint();

    public boolean isPlotGridVerticalLinesVisible();

    public boolean isPlotGridHorizontalLinesVisible();

    public Color getPlotBackgroundColor();

    public Color getPlotBorderColor();

    public boolean isPlotBorderVisible();

    public Color getPlotGridLinesColor();

    public Stroke getPlotGridLinesStroke();

    public boolean isPlotTicksMarksVisible();

    public double getPlotContentSize();

    public int getPlotMargin();

    public double getAvailableSpaceFill();

    public boolean isOverlapped();

    public boolean isCircular();

    public Font getPieFont();

    public double getAnnotationDistance();

    public PieStyler.AnnotationType getAnnotationType();

    public boolean isDrawAllAnnotations();

    public double getDonutThickness();

    public boolean isSumVisible();

    public Font getSumFont();

    public int getMarkerSize();

    public Color getErrorBarsColor();

    public boolean isErrorBarsColorSeriesColor();

    public Font getAnnotationFont();

    public List<Series.Marker> getSeriesMarkers();

    public List<BasicStroke> getSeriesLines();

    public List<Color> getSeriesColors();

    public static interface Series {
        public static final BasicStroke NONE_STROKE = new BasicStroke();
        public static final BasicStroke SOLID_STROKE = new BasicStroke(2.0f, 0, 0);
        public static final BasicStroke DASH_DOT_STROKE = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{3.0f, 1.0f}, 0.0f);
        public static final BasicStroke DASH_DASH_STROKE = new BasicStroke(2.0f, 0, 0, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
        public static final BasicStroke DOT_DOT_STROKE = new BasicStroke(2.0f, 0, 1, 10.0f, new float[]{2.0f}, 0.0f);
        public static final Marker NONE_MARKER = new None();
        public static final Marker CIRCLE_MARKER = new Circle();
        public static final Marker CROSS_MARKER = new Cross();
        public static final Marker DIAMOND_MARKER = new Diamond();
        public static final Marker SQUARE_MARKER = new Square();
        public static final Marker TRIANGLE_DOWN_MARKER = new TriangleDown();
        public static final Marker TRIANGLE_UP_MARKER = new TriangleUp();

        public static class TriangleUp
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
                g.setStroke(this.stroke);
                double halfSize = (double)markerSize / 2.0;
                Path2D.Double path = new Path2D.Double();
                path.moveTo(xOffset - halfSize, yOffset - halfSize + (double)markerSize - 1.0);
                path.lineTo(xOffset - halfSize + (double)markerSize, yOffset - halfSize + (double)markerSize - 1.0);
                path.lineTo(xOffset, yOffset - halfSize - 1.0);
                path.closePath();
                g.fill(path);
            }
        }

        public static class TriangleDown
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
                g.setStroke(this.stroke);
                double halfSize = (double)markerSize / 2.0;
                Path2D.Double path = new Path2D.Double();
                path.moveTo(xOffset - halfSize, 1.0 + yOffset - halfSize);
                path.lineTo(xOffset, 1.0 + yOffset - halfSize + (double)markerSize);
                path.lineTo(xOffset - halfSize + (double)markerSize, 1.0 + yOffset - halfSize);
                path.closePath();
                g.fill(path);
            }
        }

        public static class Square
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
                g.setStroke(this.stroke);
                double halfSize = (double)markerSize / 2.0;
                Rectangle2D.Double square = new Rectangle2D.Double(xOffset - halfSize, yOffset - halfSize, markerSize, markerSize);
                g.fill(square);
            }
        }

        public static class None
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
            }
        }

        public static class Diamond
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
                g.setStroke(this.stroke);
                double diamondHalfSize = (double)markerSize / 2.0 * 1.3;
                Path2D.Double path = new Path2D.Double();
                path.moveTo(xOffset - diamondHalfSize, yOffset);
                path.lineTo(xOffset, yOffset - diamondHalfSize);
                path.lineTo(xOffset + diamondHalfSize, yOffset);
                path.lineTo(xOffset, yOffset + diamondHalfSize);
                path.closePath();
                g.fill(path);
            }
        }

        public static class Cross
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
                g.setStroke(this.stroke);
                double halfSize = (double)markerSize / 2.0;
                Path2D.Double path = new Path2D.Double();
                path.moveTo(xOffset - halfSize, yOffset - halfSize);
                path.lineTo(xOffset + halfSize, yOffset + halfSize);
                path.moveTo(xOffset - halfSize, yOffset + halfSize);
                path.lineTo(xOffset + halfSize, yOffset - halfSize);
                g.draw(path);
            }
        }

        public static class Circle
        extends Marker {
            @Override
            public void paint(Graphics2D g, double xOffset, double yOffset, int markerSize) {
                g.setStroke(this.stroke);
                double halfSize = (double)markerSize / 2.0;
                Ellipse2D.Double circle = new Ellipse2D.Double(xOffset - halfSize, yOffset - halfSize, markerSize, markerSize);
                g.fill(circle);
            }
        }

        public static abstract class Marker {
            protected BasicStroke stroke = new BasicStroke(1.0f, 0, 2);

            public abstract void paint(Graphics2D var1, double var2, double var4, int var6);
        }
    }

    public static interface Strokes {
        public static final BasicStroke TITLE = new BasicStroke(1.0f, 0, 2);
        public static final BasicStroke LEGEND = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{3.0f, 0.0f}, 0.0f);
        public static final BasicStroke ERROR_BARS = new BasicStroke(1.0f, 0, 2);
        public static final BasicStroke PIE = new BasicStroke(2.0f, 0, 0);
    }

    public static interface Fonts {
        public static final Font SANS_SERIF_PLAIN_10 = new Font("SansSerif", 0, 10);
        public static final Font SANS_SERIF_PLAIN_11 = new Font("SansSerif", 0, 11);
        public static final Font SANS_SERIF_PLAIN_12 = new Font("SansSerif", 0, 12);
        public static final Font SANS_SERIF_PLAIN_14 = new Font("SansSerif", 0, 14);
        public static final Font SANS_SERIF_PLAIN_15 = new Font("SansSerif", 0, 15);
        public static final Font SANS_SERIF_BOLD_12 = new Font("SansSerif", 1, 12);
        public static final Font SANS_SERIF_BOLD_13 = new Font("SansSerif", 1, 13);
        public static final Font SANS_SERIF_BOLD_14 = new Font("SansSerif", 1, 14);
    }

    public static interface Colors {
        public static final Color BLACK = new Color(0, 0, 0);
        public static final Color DARK_GREY = new Color(130, 130, 130);
        public static final Color GREY = new Color(210, 210, 210);
        public static final Color LIGHT_GREY = new Color(230, 230, 230);
        public static final Color WHITE = new Color(255, 255, 255);
    }

    public static interface ColorBlindFriendly {
        public static final Color BLACK = new Color(0, 0, 0, 255);
        public static final Color ORANGE = new Color(230, 159, 0, 255);
        public static final Color SKY_BLUE = new Color(86, 180, 233, 255);
        public static final Color BLUISH_GREEN = new Color(0, 158, 115, 255);
        public static final Color YELLOW = new Color(240, 228, 66, 255);
        public static final Color BLUE = new Color(0, 114, 178, 255);
        public static final Color VERMILLION = new Color(213, 94, 0, 255);
        public static final Color REDDISH_PURPLE = new Color(204, 121, 167, 255);
        public static final List<Color> SERIES_COLORS = Arrays.asList(BLACK, ORANGE, SKY_BLUE, BLUISH_GREEN, YELLOW, BLUE, VERMILLION, REDDISH_PURPLE);
    }

    public static interface PrinterFriendly {
        public static final Color RED = new Color(228, 26, 28, 180);
        public static final Color GREEN = new Color(55, 126, 184, 180);
        public static final Color BLUE = new Color(77, 175, 74, 180);
        public static final Color PURPLE = new Color(152, 78, 163, 180);
        public static final Color ORANGE = new Color(255, 127, 0, 180);
        public static final Color YELLOW = new Color(255, 255, 51, 180);
        public static final Color BROWN = new Color(166, 86, 40, 180);
        public static final Color PINK = new Color(247, 129, 191, 180);
        public static final List<Color> SERIES_COLORS = Arrays.asList(RED, GREEN, BLUE, PURPLE, ORANGE);
    }

    public static interface Matlab {
        public static final List<BasicStroke> SERIES_LINES = Arrays.asList(Series.SOLID_STROKE);
        public static final List<Series.Marker> SERIES_MARKERS = Collections.singletonList(Series.NONE_MARKER);
        public static final Color BLUE = new Color(0, 0, 255, 255);
        public static final Color GREEN = new Color(0, 128, 0, 255);
        public static final Color RED = new Color(255, 0, 0, 255);
        public static final Color TURQUOISE = new Color(0, 191, 191, 255);
        public static final Color MAGENTA = new Color(191, 0, 191, 255);
        public static final Color YELLOW = new Color(191, 191, 0, 255);
        public static final Color DARK_GREY = new Color(64, 64, 64, 255);
        public static final List<Color> SERIES_COLORS = Arrays.asList(BLUE, GREEN, RED, TURQUOISE, MAGENTA, YELLOW, DARK_GREY);
        public static final BasicStroke AXIS_TICKMARK = new BasicStroke(0.5f);
        public static final BasicStroke GRID_LINES = new BasicStroke(0.5f, 0, 1, 10.0f, new float[]{1.0f, 3.0f}, 0.0f);
    }

    public static interface GGPlot2 {
        public static final List<BasicStroke> SERIES_LINES = Arrays.asList(Series.SOLID_STROKE, Series.DOT_DOT_STROKE, Series.DASH_DASH_STROKE);
        public static final List<Series.Marker> SERIES_MARKERS = Arrays.asList(Series.CIRCLE_MARKER, Series.DIAMOND_MARKER);
        public static final Color RED = new Color(248, 118, 109, 255);
        public static final Color YELLOW_GREEN = new Color(163, 165, 0, 255);
        public static final Color GREEN = new Color(0, 191, 125, 255);
        public static final Color BLUE = new Color(0, 176, 246, 255);
        public static final Color PURPLE = new Color(231, 107, 243, 255);
        public static final List<Color> SERIES_COLORS = Arrays.asList(RED, YELLOW_GREEN, GREEN, BLUE, PURPLE);
        public static final BasicStroke AXIS_TICKMARK = new BasicStroke(1.5f, 0, 2, 10.0f, new float[]{3.0f, 0.0f}, 0.0f);
        public static final BasicStroke GRID_LINES = new BasicStroke(1.5f, 0, 2, 10.0f, new float[]{3.0f, 0.0f}, 0.0f);
    }

    public static interface Standard {
        public static final Color BLUE = new Color(0, 55, 255, 180);
        public static final Color ORANGE = new Color(255, 172, 0, 180);
        public static final Color PURPLE = new Color(128, 0, 255, 180);
        public static final Color GREEN = new Color(0, 205, 0, 180);
        public static final Color RED = new Color(205, 0, 0, 180);
        public static final Color YELLOW = new Color(255, 215, 0, 180);
        public static final Color MAGENTA = new Color(255, 0, 255, 180);
        public static final Color PINK = new Color(255, 166, 201, 180);
        public static final Color LIGHT_GREY = new Color(207, 207, 207, 180);
        public static final Color CYAN = new Color(0, 255, 255, 180);
        public static final Color BROWN = new Color(102, 56, 10, 180);
        public static final Color BLACK = new Color(0, 0, 0, 180);
        public static final List<Color> SERIES_COLORS = Arrays.asList(BLUE, ORANGE, PURPLE, GREEN, RED, YELLOW, MAGENTA, PINK, LIGHT_GREY, CYAN, BROWN, BLACK);
        public static final List<Series.Marker> SERIES_MARKERS = Arrays.asList(Series.CIRCLE_MARKER, Series.DIAMOND_MARKER, Series.SQUARE_MARKER, Series.TRIANGLE_DOWN_MARKER, Series.TRIANGLE_UP_MARKER);
        public static final List<BasicStroke> SERIES_LINES = Arrays.asList(Series.SOLID_STROKE, Series.DASH_DOT_STROKE, Series.DASH_DASH_STROKE, Series.DOT_DOT_STROKE);
        public static final BasicStroke AXIS_TICKMARK = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{3.0f, 0.0f}, 0.0f);
        public static final BasicStroke GRID_LINES = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{3.0f, 3.0f}, 0.0f);
    }

    public static interface Default {
        public static final List<Color> SERIES_COLORS = Arrays.asList(new Color(141, 211, 199), new Color(255, 255, 179), new Color(190, 186, 218), new Color(251, 128, 114), new Color(128, 177, 211), new Color(253, 180, 98), new Color(179, 222, 105), new Color(252, 205, 229), new Color(217, 217, 217), new Color(188, 128, 189), new Color(204, 235, 197), new Color(255, 237, 111));
        public static final List<Series.Marker> SERIES_MARKERS = Arrays.asList(Series.CIRCLE_MARKER, Series.SQUARE_MARKER, Series.DIAMOND_MARKER, Series.TRIANGLE_UP_MARKER, Series.TRIANGLE_DOWN_MARKER, Series.CROSS_MARKER);
        public static final List<BasicStroke> SERIES_LINES = Arrays.asList(Series.SOLID_STROKE, Series.DOT_DOT_STROKE, Series.DASH_DASH_STROKE, Series.DASH_DOT_STROKE);
        public static final BasicStroke AXIS_TICKMARK = new BasicStroke(1.0f);
        public static final BasicStroke GRID_LINES = new BasicStroke(1.0f, 0, 2, 10.0f, new float[]{3.0f, 5.0f}, 0.0f);
    }
}

