/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.graphics.chart.xy;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xbib.graphics.chart.Chart;
import org.xbib.graphics.chart.axis.Axis;
import org.xbib.graphics.chart.axis.AxisPair;
import org.xbib.graphics.chart.axis.DataType;
import org.xbib.graphics.chart.legend.MarkerLegend;
import org.xbib.graphics.chart.plot.AxesChartPlot;
import org.xbib.graphics.chart.plot.ContentPlot;
import org.xbib.graphics.chart.style.AxesChartStyler;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyle;
import org.xbib.graphics.chart.style.SeriesColorMarkerLineStyleCycler;
import org.xbib.graphics.chart.style.Styler;
import org.xbib.graphics.chart.theme.Theme;
import org.xbib.graphics.chart.xy.XYChartBuilder;
import org.xbib.graphics.chart.xy.XYSeries;
import org.xbib.graphics.chart.xy.XYSeriesRenderStyle;
import org.xbib.graphics.chart.xy.XYStyler;

public class XYChart
extends Chart<XYStyler, XYSeries> {
    public XYChart(int width, int height) {
        super(width, height, new XYStyler());
        this.axisPair = new AxisPair<XYStyler, XYSeries>(this);
        this.plot = new XYPlot<XYStyler, XYSeries>(this);
        this.legend = new MarkerLegend<XYStyler, XYSeries>(this);
    }

    public XYChart(int width, int height, Theme theme) {
        this(width, height);
        ((XYStyler)this.styler).setTheme(theme);
    }

    public XYChart(XYChartBuilder chartBuilder) {
        this(chartBuilder.getWidth(), chartBuilder.getHeight(), chartBuilder.getTheme());
        this.setTitle(chartBuilder.getTitle());
        this.setXAxisTitle(chartBuilder.getxAxisTitle());
        this.setYAxisTitle(chartBuilder.getyAxisTitle());
    }

    public XYSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData) {
        return this.addSeries(seriesName, xData, yData, null, this.getDataType(xData));
    }

    public XYSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        return this.addSeries(seriesName, xData, yData, errorBars, this.getDataType(xData));
    }

    public XYSeries addSeries(String seriesName, double[] xData, double[] yData) {
        return this.addSeries(seriesName, xData, yData, null);
    }

    public XYSeries addSeries(String seriesName, double[] xData, double[] yData, double[] errorBars) {
        return this.addSeries(seriesName, this.listFromDoubleArray(xData), this.listFromDoubleArray(yData), this.listFromDoubleArray(errorBars), DataType.Number);
    }

    public XYSeries addSeries(String seriesName, int[] xData, int[] yData) {
        return this.addSeries(seriesName, xData, yData, (int[])null);
    }

    public XYSeries addSeries(String seriesName, int[] xData, int[] yData, int[] errorBars) {
        return this.addSeries(seriesName, this.listFromIntArray(xData), this.listFromIntArray(yData), this.listFromIntArray(errorBars), DataType.Number);
    }

    public XYSeries addSeries(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars, DataType dataType) {
        XYSeries series;
        this.sanityCheck(seriesName, xData, yData, errorBars);
        if (xData != null) {
            if (xData.size() != yData.size()) {
                throw new IllegalArgumentException("X and Y-Axis sizes are not the same");
            }
            series = new XYSeries(seriesName, xData, yData, errorBars, dataType);
        } else {
            series = new XYSeries(seriesName, this.getGeneratedData(yData.size()), yData, errorBars, dataType);
        }
        this.seriesMap.put(seriesName, series);
        return series;
    }

    @Override
    public void paint(Graphics2D g, int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        for (XYSeries XYSeries2 : this.getSeriesMap().values()) {
            XYSeriesRenderStyle XYSeriesRenderStyle2 = XYSeries2.getXySeriesRenderStyle();
            if (XYSeriesRenderStyle2 != null) continue;
            XYSeries2.setXySeriesRenderStyle(((XYStyler)this.getStyler()).getDefaultSeriesRenderStyle());
        }
        this.setSeriesStyles();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(((XYStyler)this.styler).getChartBackgroundColor());
        Rectangle2D.Double rect = new Rectangle2D.Double(0.0, 0.0, this.getWidth(), this.getHeight());
        g.fill(rect);
        this.axisPair.paint(g);
        this.plot.paint(g);
        this.chartTitle.paint(g);
        this.legend.paint(g);
        g.dispose();
    }

    private void setSeriesStyles() {
        SeriesColorMarkerLineStyleCycler seriesColorMarkerLineStyleCycler = new SeriesColorMarkerLineStyleCycler(((XYStyler)this.getStyler()).getSeriesColors(), ((XYStyler)this.getStyler()).getSeriesMarkers(), ((XYStyler)this.getStyler()).getSeriesLines());
        for (XYSeries series : this.getSeriesMap().values()) {
            SeriesColorMarkerLineStyle seriesColorMarkerLineStyle = seriesColorMarkerLineStyleCycler.getNextSeriesColorMarkerLineStyle();
            if (series.getLineStyle() == null) {
                series.setLineStyle(seriesColorMarkerLineStyle.getStroke());
            }
            if (series.getLineColor() == null) {
                series.setLineColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getFillColor() == null) {
                series.setFillColor(seriesColorMarkerLineStyle.getColor());
            }
            if (series.getMarker() == null) {
                series.setMarker(seriesColorMarkerLineStyle.getMarker());
            }
            if (series.getMarkerColor() != null) continue;
            series.setMarkerColor(seriesColorMarkerLineStyle.getColor());
        }
    }

    private DataType getDataType(List<?> data) {
        DataType axisType;
        if (data == null) {
            return DataType.Number;
        }
        Iterator<?> itr = data.iterator();
        Object dataPoint = itr.next();
        if (dataPoint instanceof Number) {
            axisType = DataType.Number;
        } else if (dataPoint instanceof Instant) {
            axisType = DataType.Instant;
        } else {
            throw new IllegalArgumentException("Series data must be either Number or Instant type");
        }
        return axisType;
    }

    private void sanityCheck(String seriesName, List<?> xData, List<? extends Number> yData, List<? extends Number> errorBars) {
        if (this.seriesMap.containsKey(seriesName)) {
            throw new IllegalArgumentException("Series name >" + seriesName + "< has already been used. Use unique names for each series");
        }
        if (yData == null) {
            throw new IllegalArgumentException("Y-Axis data cannot be null");
        }
        if (yData.size() == 0) {
            throw new IllegalArgumentException("Y-Axis data cannot be empty");
        }
        if (xData != null && xData.size() == 0) {
            throw new IllegalArgumentException("X-Axis data cannot be empty");
        }
        if (errorBars != null && errorBars.size() != yData.size()) {
            throw new IllegalArgumentException("Error bars and Y-Axis sizes are not the same");
        }
    }

    private static class ContentPlotXY<ST extends AxesChartStyler, S extends XYSeries>
    extends ContentPlot<ST, S> {
        private final ST xystyler;

        private ContentPlotXY(Chart<ST, S> chart) {
            super(chart);
            this.xystyler = (AxesChartStyler)chart.getStyler();
        }

        @Override
        public void doPaint(Graphics2D g) {
            double xTickSpace = ((Styler)this.xystyler).getPlotContentSize() * this.getBounds().getWidth();
            double xLeftMargin = ((double)((int)this.getBounds().getWidth()) - xTickSpace) / 2.0;
            double yTickSpace = ((Styler)this.xystyler).getPlotContentSize() * this.getBounds().getHeight();
            double yTopMargin = ((double)((int)this.getBounds().getHeight()) - yTickSpace) / 2.0;
            double xMin = this.chart.getXAxis().getMin();
            double xMax = this.chart.getXAxis().getMax();
            Line2D.Double line = new Line2D.Double();
            if (((AxesChartStyler)this.xystyler).isXAxisLogarithmic()) {
                xMin = Math.log10(xMin);
                xMax = Math.log10(xMax);
            }
            Map map = this.chart.getSeriesMap();
            for (XYSeries series : map.values()) {
                if (!series.isEnabled()) continue;
                Axis<?, ?> yAxis = this.chart.getYAxis(series.getYAxisGroup());
                double yMin = yAxis.getMin();
                double yMax = yAxis.getMax();
                if (((AxesChartStyler)this.xystyler).isYAxisLogarithmic()) {
                    yMin = Math.log10(yMin);
                    yMax = Math.log10(yMax);
                }
                List<?> xData = series.getXData();
                List<? extends Number> yData = series.getYData();
                double previousX = -1.7976931348623157E308;
                double previousY = -1.7976931348623157E308;
                Iterator xItr = xData.iterator();
                Iterator yItr = yData.iterator();
                Iterator ebItr = null;
                List<? extends Number> errorBars = series.getExtraValues();
                if (errorBars != null) {
                    ebItr = errorBars.iterator();
                }
                Path2D.Double path = null;
                while (xItr.hasNext()) {
                    double bottomValue;
                    double topValue;
                    boolean isSeriesStepLineOrStepArea;
                    Double x = null;
                    if (this.chart.getXAxis().getDataType() == DataType.Number) {
                        Number number = (Number)xItr.next();
                        x = number != null ? Double.valueOf(number.doubleValue()) : null;
                    } else if (this.chart.getXAxis().getDataType() == DataType.Instant) {
                        Instant instant = (Instant)xItr.next();
                        Double d = x = instant != null ? Double.valueOf(instant.toEpochMilli()) : null;
                    }
                    if (((AxesChartStyler)this.xystyler).isXAxisLogarithmic()) {
                        x = x != null ? Double.valueOf(Math.log10(x)) : null;
                    }
                    Number next = (Number)yItr.next();
                    if (x == null || next == null) {
                        this.closePath(g, path, previousX, yTopMargin);
                        path = null;
                        previousX = -1.7976931348623157E308;
                        previousY = -1.7976931348623157E308;
                        continue;
                    }
                    double yOrig = next.doubleValue();
                    double y = ((AxesChartStyler)this.xystyler).isYAxisLogarithmic() ? Math.log10(yOrig) : yOrig;
                    double xTransform = xLeftMargin + (x - xMin) / (xMax - xMin) * xTickSpace;
                    double yTransform = this.getBounds().getHeight() - (yTopMargin + (y - yMin) / (yMax - yMin) * yTickSpace);
                    if (Math.abs(xMax - xMin) / 5.0 == 0.0) {
                        xTransform = this.getBounds().getWidth() / 2.0;
                    }
                    if (Math.abs(yMax - yMin) / 5.0 == 0.0) {
                        yTransform = this.getBounds().getHeight() / 2.0;
                    }
                    double xOffset = this.getBounds().getX() + xTransform;
                    double yOffset = this.getBounds().getY() + yTransform;
                    boolean isSeriesLineOrArea = XYSeriesRenderStyle.Line == series.getXySeriesRenderStyle() || XYSeriesRenderStyle.Area == series.getXySeriesRenderStyle();
                    boolean bl = isSeriesStepLineOrStepArea = XYSeriesRenderStyle.Step == series.getXySeriesRenderStyle() || XYSeriesRenderStyle.StepArea == series.getXySeriesRenderStyle();
                    if ((isSeriesLineOrArea || isSeriesStepLineOrStepArea) && series.getLineStyle() != Theme.Series.NONE_STROKE && previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                        g.setColor(series.getLineColor());
                        g.setStroke(series.getLineStyle());
                        if (isSeriesLineOrArea) {
                            line.setLine(previousX, previousY, xOffset, yOffset);
                            g.draw(line);
                        } else {
                            if (previousX != xOffset) {
                                line.setLine(previousX, previousY, xOffset, previousY);
                                g.draw(line);
                            }
                            if (previousY != yOffset) {
                                line.setLine(xOffset, previousY, xOffset, yOffset);
                                g.draw(line);
                            }
                        }
                    }
                    if (XYSeriesRenderStyle.Area == series.getXySeriesRenderStyle() || XYSeriesRenderStyle.StepArea == series.getXySeriesRenderStyle()) {
                        if (previousX != -1.7976931348623157E308 && previousY != -1.7976931348623157E308) {
                            g.setColor(series.getFillColor());
                            double yBottomOfArea = this.getBounds().getY() + this.getBounds().getHeight() - yTopMargin;
                            if (path == null) {
                                path = new Path2D.Double();
                                path.moveTo(previousX, yBottomOfArea);
                                path.lineTo(previousX, previousY);
                            }
                            if (XYSeriesRenderStyle.Area == series.getXySeriesRenderStyle()) {
                                path.lineTo(xOffset, yOffset);
                            } else {
                                if (previousX != xOffset) {
                                    path.lineTo(xOffset, previousY);
                                }
                                if (previousY != yOffset) {
                                    path.lineTo(xOffset, yOffset);
                                }
                            }
                        }
                        if (xOffset < previousX) {
                            throw new RuntimeException("X-Data must be in ascending order for Area Charts");
                        }
                    }
                    previousX = xOffset;
                    previousY = yOffset;
                    if (series.getMarker() != null) {
                        g.setColor(series.getMarkerColor());
                        series.getMarker().paint(g, xOffset, yOffset, ((AxesChartStyler)this.xystyler).getMarkerSize());
                    }
                    if (errorBars == null) continue;
                    double eb = ((Number)ebItr.next()).doubleValue();
                    if (((AxesChartStyler)this.xystyler).isErrorBarsColorSeriesColor()) {
                        g.setColor(series.getLineColor());
                    } else {
                        g.setColor(((AxesChartStyler)this.xystyler).getErrorBarsColor());
                    }
                    g.setStroke(Theme.Strokes.ERROR_BARS);
                    if (((AxesChartStyler)this.xystyler).isYAxisLogarithmic()) {
                        topValue = yOrig + eb;
                        topValue = Math.log10(topValue);
                    } else {
                        topValue = y + eb;
                    }
                    double topEBTransform = this.getBounds().getHeight() - (yTopMargin + (topValue - yMin) / (yMax - yMin) * yTickSpace);
                    double topEBOffset = this.getBounds().getY() + topEBTransform;
                    if (((AxesChartStyler)this.xystyler).isYAxisLogarithmic()) {
                        bottomValue = yOrig - eb;
                        bottomValue = Math.log10(bottomValue);
                    } else {
                        bottomValue = y - eb;
                    }
                    double bottomEBTransform = this.getBounds().getHeight() - (yTopMargin + (bottomValue - yMin) / (yMax - yMin) * yTickSpace);
                    double bottomEBOffset = this.getBounds().getY() + bottomEBTransform;
                    line = new Line2D.Double(xOffset, topEBOffset, xOffset, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(xOffset - 3.0, bottomEBOffset, xOffset + 3.0, bottomEBOffset);
                    g.draw(line);
                    line = new Line2D.Double(xOffset - 3.0, topEBOffset, xOffset + 3.0, topEBOffset);
                    g.draw(line);
                }
                g.setColor(series.getFillColor());
                this.closePath(g, path, previousX, yTopMargin);
            }
        }
    }

    private static class XYPlot<ST extends AxesChartStyler, S extends XYSeries>
    extends AxesChartPlot<ST, S> {
        private XYPlot(Chart<ST, S> chart) {
            super(chart);
            this.contentPlot = new ContentPlotXY<ST, S>(chart);
        }
    }
}

