/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.smile;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.dataformat.smile.SmileGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.XContentGenerator;
import org.xbib.content.XContentParser;
import org.xbib.content.io.BytesReference;
import org.xbib.content.json.JsonXContentParser;
import org.xbib.content.smile.SmileXContentGenerator;
import org.xbib.content.smile.SmileXContentParser;

public class SmileXContent
implements XContent {
    private static final SmileXContent smileXContent;
    private static final SmileFactory smileFactory;

    public static SmileFactory smileFactory() {
        return smileFactory;
    }

    public static SmileXContent smileContent() {
        return smileXContent;
    }

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder((XContent)smileXContent);
    }

    public static XContentBuilder contentBuilder(OutputStream outputStream) throws IOException {
        return XContentBuilder.builder((XContent)smileXContent, (OutputStream)outputStream);
    }

    public String name() {
        return "smile";
    }

    public XContentGenerator createGenerator(OutputStream os) throws IOException {
        return new SmileXContentGenerator((JsonGenerator)smileFactory.createGenerator(os, JsonEncoding.UTF8));
    }

    public XContentGenerator createGenerator(Writer writer) throws IOException {
        return new SmileXContentGenerator(smileFactory.createGenerator(writer));
    }

    public XContentParser createParser(String content) throws IOException {
        return new SmileXContentParser((JsonParser)smileFactory.createParser(content.getBytes(StandardCharsets.UTF_8)));
    }

    public XContentParser createParser(InputStream is) throws IOException {
        return new SmileXContentParser((JsonParser)smileFactory.createParser(is));
    }

    public XContentParser createParser(byte[] data) throws IOException {
        return new SmileXContentParser((JsonParser)smileFactory.createParser(data));
    }

    public XContentParser createParser(byte[] data, int offset, int length) throws IOException {
        return new SmileXContentParser((JsonParser)smileFactory.createParser(data, offset, length));
    }

    public XContentParser createParser(BytesReference bytes) throws IOException {
        return this.createParser((InputStream)bytes.streamInput());
    }

    public XContentParser createParser(Reader reader) throws IOException {
        return new JsonXContentParser(smileFactory.createParser(reader));
    }

    public boolean isXContent(BytesReference bytes) {
        int length;
        int n = length = bytes.length() < 20 ? bytes.length() : 20;
        if (length == 0) {
            return false;
        }
        byte first = bytes.get(0);
        return length > 2 && first == 58 && bytes.get(1) == 41 && bytes.get(2) == 10;
    }

    static {
        smileFactory = new SmileFactory();
        smileFactory.configure(SmileGenerator.Feature.ENCODE_BINARY_AS_7BIT, false);
        smileXContent = new SmileXContent();
    }
}

