/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.smile;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.smile.SmileParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xbib.content.XContent;
import org.xbib.content.io.BytesReference;
import org.xbib.content.json.JsonXContentGenerator;
import org.xbib.content.smile.SmileXContent;

public class SmileXContentGenerator
extends JsonXContentGenerator {
    public SmileXContentGenerator(JsonGenerator generator) {
        super(generator);
    }

    public XContent content() {
        return SmileXContent.smileContent();
    }

    public void writeRawField(String fieldName, byte[] content, OutputStream outputStream) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = SmileXContent.smileFactory().createParser(content);){
            parser.nextToken();
            ((JsonGenerator)this.generator).copyCurrentStructure((JsonParser)parser);
        }
    }

    public void writeRawField(String fieldName, BytesReference content, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = SmileXContent.smileFactory().createParser((InputStream)content.streamInput());){
            parser.nextToken();
            ((JsonGenerator)this.generator).copyCurrentStructure((JsonParser)parser);
        }
    }

    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream bos) throws IOException {
        this.writeFieldName(fieldName);
        try (SmileParser parser = SmileXContent.smileFactory().createParser(content, offset, length);){
            parser.nextToken();
            ((JsonGenerator)this.generator).copyCurrentStructure((JsonParser)parser);
        }
    }
}

