/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.xbib.content.xml.json.JsonNamespaceContext;
import org.xbib.content.xml.json.StaxLocation;
import org.xbib.content.xml.json.events.CharactersEvent;
import org.xbib.content.xml.json.events.EndDocumentEvent;
import org.xbib.content.xml.json.events.EndElementEvent;
import org.xbib.content.xml.json.events.JsonReaderXmlEvent;
import org.xbib.content.xml.json.events.StartDocumentEvent;
import org.xbib.content.xml.json.events.StartElementEvent;

public class JsonStaxReader
implements XMLStreamReader {
    private static final Collection<JsonToken> valueTokens = new HashSet<JsonToken>(){
        private static final long serialVersionUID = -1481133867668849136L;
        {
            this.add(JsonToken.VALUE_FALSE);
            this.add(JsonToken.VALUE_TRUE);
            this.add(JsonToken.VALUE_NULL);
            this.add(JsonToken.VALUE_STRING);
            this.add(JsonToken.VALUE_NUMBER_FLOAT);
            this.add(JsonToken.VALUE_NUMBER_INT);
        }
    };
    private final JsonParser parser;
    private final Queue<JsonReaderXmlEvent> eventQueue = new LinkedList<JsonReaderXmlEvent>();
    private final Deque<ProcessingInfo> processingStack = new ArrayDeque<ProcessingInfo>();
    private final JsonNamespaceContext namespaceContext = new JsonNamespaceContext();
    private final Map<String, QName> qNamesOfExpElems = new HashMap<String, QName>();

    public JsonStaxReader(JsonParser parser) throws XMLStreamException {
        this.parser = parser;
        try {
            this.readNext();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private void readNext() throws IOException {
        this.readNext(false);
    }

    private QName getQNameForTagLocName(String localName) {
        return this.getQNameForLocName(localName, this.qNamesOfExpElems);
    }

    private QName getQNameForLocName(String localName, Map<String, QName> qNamesMap) {
        QName result = qNamesMap.get(localName);
        if (result != null) {
            return result;
        }
        return new QName(localName);
    }

    private void readNext(boolean lookingForAttributes) throws IOException {
        if (!lookingForAttributes) {
            this.eventQueue.poll();
        }
        if (this.eventQueue.isEmpty() || lookingForAttributes) {
            while (true) {
                this.parser.nextToken();
                JsonToken jtok = this.parser.getCurrentToken();
                ProcessingInfo pi = this.processingStack.peek();
                switch (jtok) {
                    case FIELD_NAME: {
                        String currentName = this.parser.getCurrentName();
                        if (currentName.startsWith("@")) {
                            currentName = currentName.substring(1);
                        }
                        if (!"$".equals(currentName)) {
                            QName currentQName = this.getQNameForTagLocName(currentName);
                            this.eventQueue.add(new StartElementEvent(currentQName, new StaxLocation(this.parser.getCurrentLocation())));
                            this.processingStack.add(new ProcessingInfo(currentQName, false, true));
                            return;
                        }
                        this.parser.nextToken();
                        if (valueTokens.contains(this.parser.getCurrentToken())) {
                            this.eventQueue.add(new CharactersEvent(this.parser.getText(), new StaxLocation(this.parser.getCurrentLocation())));
                            return;
                        }
                        throw new IOException("Not a xml value, expected primitive value!");
                    }
                    case START_OBJECT: {
                        if (pi == null) {
                            this.eventQueue.add(new StartDocumentEvent(new StaxLocation(0, 0, 0)));
                            return;
                        }
                        if (pi.isArray && !pi.isFirstElement) {
                            this.eventQueue.add(new StartElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                            return;
                        }
                        pi.isFirstElement = false;
                        break;
                    }
                    case END_OBJECT: {
                        this.eventQueue.add(new EndElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                        if (!pi.isArray) {
                            this.processingStack.pop();
                        }
                        if (this.processingStack.isEmpty()) {
                            this.eventQueue.add(new EndDocumentEvent(new StaxLocation(this.parser.getCurrentLocation())));
                        }
                        return;
                    }
                    case VALUE_FALSE: 
                    case VALUE_NULL: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_TRUE: 
                    case VALUE_STRING: {
                        if (!pi.isFirstElement) {
                            this.eventQueue.add(new StartElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                        } else {
                            pi.isFirstElement = false;
                        }
                        if (jtok != JsonToken.VALUE_NULL) {
                            this.eventQueue.add(new CharactersEvent(this.parser.getText(), new StaxLocation(this.parser.getCurrentLocation())));
                        }
                        this.eventQueue.add(new EndElementEvent(pi.name, new StaxLocation(this.parser.getCurrentLocation())));
                        if (!pi.isArray) {
                            this.processingStack.pop();
                        }
                        if (this.processingStack.isEmpty()) {
                            this.eventQueue.add(new EndDocumentEvent(new StaxLocation(this.parser.getCurrentLocation())));
                        }
                        return;
                    }
                    case START_ARRAY: {
                        this.processingStack.peek().isArray = true;
                        break;
                    }
                    case END_ARRAY: {
                        this.processingStack.pop();
                        break;
                    }
                }
            }
        }
    }

    @Override
    public void require(int arg0, String arg1, String arg2) throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getElementText() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public int next() throws XMLStreamException {
        try {
            this.readNext();
            return this.eventQueue.peek().getEventType();
        }
        catch (IOException ex) {
            throw new XMLStreamException(ex);
        }
    }

    @Override
    public int nextTag() throws XMLStreamException {
        int eventType = this.next();
        while (eventType == 4 && this.isWhiteSpace() || eventType == 12 && this.isWhiteSpace() || eventType == 6 || eventType == 3 || eventType == 5) {
            eventType = this.next();
        }
        if (eventType != 1 && eventType != 2) {
            throw new XMLStreamException("expected start or end tag", this.getLocation());
        }
        return eventType;
    }

    @Override
    public boolean hasNext() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void close() throws XMLStreamException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNamespaceURI(String arg0) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isStartElement() {
        return this.eventQueue.peek().isStartElement();
    }

    @Override
    public boolean isEndElement() {
        return this.eventQueue.peek().isEndElement();
    }

    @Override
    public boolean isCharacters() {
        return this.eventQueue.peek().isCharacters();
    }

    @Override
    public boolean isWhiteSpace() {
        return false;
    }

    @Override
    public String getAttributeValue(String namespaceURI, String localName) {
        return this.eventQueue.peek().getAttributeValue(namespaceURI, localName);
    }

    @Override
    public int getAttributeCount() {
        return this.eventQueue.peek().getAttributeCount();
    }

    @Override
    public QName getAttributeName(int index) {
        return this.eventQueue.peek().getAttributeName(index);
    }

    @Override
    public String getAttributeNamespace(int index) {
        return this.eventQueue.peek().getAttributeNamespace(index);
    }

    @Override
    public String getAttributeLocalName(int index) {
        return this.eventQueue.peek().getAttributeLocalName(index);
    }

    @Override
    public String getAttributePrefix(int index) {
        return this.eventQueue.peek().getAttributePrefix(index);
    }

    @Override
    public String getAttributeType(int index) {
        return this.eventQueue.peek().getAttributeType(index);
    }

    @Override
    public String getAttributeValue(int index) {
        return this.eventQueue.peek().getAttributeValue(index);
    }

    @Override
    public boolean isAttributeSpecified(int index) {
        return this.eventQueue.peek().isAttributeSpecified(index);
    }

    @Override
    public int getNamespaceCount() {
        return 0;
    }

    @Override
    public String getNamespacePrefix(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getNamespaceURI(int idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    @Override
    public int getEventType() {
        return this.eventQueue.peek().getEventType();
    }

    @Override
    public String getText() {
        return this.eventQueue.peek().getText();
    }

    @Override
    public char[] getTextCharacters() {
        return this.eventQueue.peek().getTextCharacters();
    }

    @Override
    public int getTextCharacters(int sourceStart, char[] target, int targetStart, int length) throws XMLStreamException {
        return this.eventQueue.peek().getTextCharacters(sourceStart, target, targetStart, length);
    }

    @Override
    public int getTextStart() {
        return this.eventQueue.peek().getTextStart();
    }

    @Override
    public int getTextLength() {
        return this.eventQueue.peek().getTextLength();
    }

    @Override
    public String getEncoding() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean hasText() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public Location getLocation() {
        return this.eventQueue.peek().getLocation();
    }

    @Override
    public QName getName() {
        return this.eventQueue.peek().getName();
    }

    @Override
    public String getLocalName() {
        return this.eventQueue.peek().getLocalName();
    }

    @Override
    public boolean hasName() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getNamespaceURI() {
        return this.eventQueue.peek().getName().getNamespaceURI();
    }

    @Override
    public String getPrefix() {
        return this.eventQueue.peek().getPrefix();
    }

    @Override
    public String getVersion() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean isStandalone() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean standaloneSet() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getCharacterEncodingScheme() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPITarget() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getPIData() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static class ProcessingInfo {
        QName name;
        boolean isArray;
        boolean isFirstElement;

        ProcessingInfo(QName name, boolean isArray, boolean isFirstElement) {
            this.name = name;
            this.isArray = isArray;
            this.isFirstElement = isFirstElement;
        }
    }
}

