/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.stream;

import java.io.StringWriter;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public abstract class AbstractXMLEvent
implements XMLEvent {
    private static final Logger logger = Logger.getLogger(AbstractXMLEvent.class.getName());
    protected Location location;
    protected QName schemaType;

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public QName getSchemaType() {
        return this.schemaType;
    }

    @Override
    public Characters asCharacters() {
        return (Characters)((Object)this);
    }

    @Override
    public EndElement asEndElement() {
        return (EndElement)((Object)this);
    }

    @Override
    public StartElement asStartElement() {
        return (StartElement)((Object)this);
    }

    @Override
    public boolean isAttribute() {
        return this.getEventType() == 10;
    }

    @Override
    public boolean isCharacters() {
        switch (this.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEndDocument() {
        return this.getEventType() == 8;
    }

    @Override
    public boolean isEndElement() {
        return this.getEventType() == 2;
    }

    @Override
    public boolean isEntityReference() {
        return this.getEventType() == 9;
    }

    @Override
    public boolean isNamespace() {
        return this.getEventType() == 13;
    }

    @Override
    public boolean isProcessingInstruction() {
        return this.getEventType() == 3;
    }

    @Override
    public boolean isStartDocument() {
        return this.getEventType() == 7;
    }

    @Override
    public boolean isStartElement() {
        return this.getEventType() == 1;
    }

    @Override
    public abstract void writeAsEncodedUnicode(Writer var1) throws XMLStreamException;

    public String toString() {
        StringWriter writer = new StringWriter();
        try {
            this.writeAsEncodedUnicode(writer);
        }
        catch (XMLStreamException e) {
            logger.log(Level.WARNING, e.getMessage(), e);
        }
        return writer.toString();
    }
}

