/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.stream;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.XMLEvent;
import org.xbib.content.xml.stream.AbstractCharactersEvent;
import org.xbib.content.xml.stream.EventWriterDelegate;
import org.xbib.content.xml.stream.Indentation;

public class IndentingXMLEventWriter
extends EventWriterDelegate
implements Indentation {
    private static final Logger logger = Logger.getLogger(IndentingXMLEventWriter.class.getName());
    private static final int WROTE_MARKUP = 1;
    private static final int WROTE_DATA = 2;
    private final PrefixCharacters newLineEvent = new PrefixCharacters();
    private int depth = 0;
    private int[] stack = new int[]{0, 0, 0, 0};

    public IndentingXMLEventWriter(XMLEventWriter out) {
        super(out);
    }

    @Override
    public String getIndent() {
        return this.newLineEvent.getIndent();
    }

    @Override
    public void setIndent(String indent) {
        this.newLineEvent.setIndent(indent);
    }

    @Override
    public void add(XMLEvent event) throws XMLStreamException {
        switch (event.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                this.out.add(event);
                this.afterData();
                return;
            }
            case 1: {
                this.beforeStartElement();
                this.out.add(event);
                this.afterStartElement();
                return;
            }
            case 2: {
                this.beforeEndElement();
                this.out.add(event);
                this.afterEndElement();
                return;
            }
            case 3: 
            case 5: 
            case 7: 
            case 11: {
                this.beforeMarkup();
                this.out.add(event);
                this.afterMarkup();
                return;
            }
            case 8: {
                this.out.add(event);
                this.afterEndDocument();
                break;
            }
            default: {
                this.out.add(event);
            }
        }
    }

    protected void beforeMarkup() throws XMLStreamException {
        int soFar = this.stack[this.depth];
        if ((soFar & 2) == 0 && (this.depth > 0 || soFar != 0)) {
            this.newLineEvent.write(this.out, this.depth);
            if (this.depth > 0 && this.getIndent().length() > 0) {
                this.afterMarkup();
            }
        }
    }

    protected void afterMarkup() {
        int n = this.depth;
        this.stack[n] = this.stack[n] | 1;
    }

    protected void afterData() {
        int n = this.depth;
        this.stack[n] = this.stack[n] | 2;
    }

    protected void beforeStartElement() throws XMLStreamException {
        this.beforeMarkup();
        if (this.stack.length <= this.depth + 1) {
            int[] newWrote = new int[this.stack.length * 2];
            System.arraycopy(this.stack, 0, newWrote, 0, this.stack.length);
            this.stack = newWrote;
        }
        this.stack[this.depth + 1] = 0;
    }

    protected void afterStartElement() {
        this.afterMarkup();
        ++this.depth;
    }

    protected void beforeEndElement() {
        if (this.depth > 0 && this.stack[this.depth] == 1) {
            try {
                this.newLineEvent.write(this.out, this.depth - 1);
            }
            catch (Exception e) {
                logger.log(Level.FINE, e.getMessage(), e);
            }
        }
    }

    protected void afterEndElement() {
        if (this.depth > 0) {
            --this.depth;
        }
    }

    protected void afterEndDocument() throws XMLStreamException {
        this.depth = 0;
        if (this.stack[0] == 1) {
            this.newLineEvent.write(this.out, 0);
        }
        this.stack[0] = 0;
    }

    private static class PrefixCharacters
    extends AbstractCharactersEvent
    implements Indentation {
        private static final Pattern ENCODABLE = Pattern.compile("[&<>]");
        private final String[] prefixes = new String[]{null, null, null, null, null, null};
        private String indent = "  ";
        private String newLine = "\n";
        private int minimumPrefix = 0;
        private int depth = 0;

        PrefixCharacters() {
            super(null);
        }

        @Override
        public String getIndent() {
            return this.indent;
        }

        @Override
        public void setIndent(String indent) {
            if (!indent.equals(this.indent)) {
                Arrays.fill(this.prefixes, null);
            }
            this.indent = indent;
        }

        void write(XMLEventWriter out, int depth) throws XMLStreamException {
            this.depth = depth;
            out.add(this);
        }

        @Override
        public String getData() {
            while (this.depth >= this.minimumPrefix + this.prefixes.length) {
                this.prefixes[this.minimumPrefix++ % this.prefixes.length] = null;
            }
            while (this.depth < this.minimumPrefix) {
                this.prefixes[--this.minimumPrefix % this.prefixes.length] = null;
            }
            int p = this.depth % this.prefixes.length;
            String data = this.prefixes[p];
            if (data == null) {
                StringBuilder b = new StringBuilder(this.newLine.length() + this.indent.length() * this.depth);
                b.append(this.newLine);
                for (int d = 0; d < this.depth; ++d) {
                    b.append(this.indent);
                }
                data = this.prefixes[p] = b.toString();
            }
            return data;
        }

        @Override
        public int getEventType() {
            return 4;
        }

        @Override
        public Characters asCharacters() {
            return this;
        }

        @Override
        public boolean isCData() {
            return false;
        }

        @Override
        public boolean isIgnorableWhiteSpace() {
            return this.isWhiteSpace();
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            try {
                String s = this.getData();
                if (!ENCODABLE.matcher(s).find()) {
                    writer.write(s);
                } else {
                    int first;
                    char[] data = s.toCharArray();
                    block7: for (int d = first = 0; d < data.length; ++d) {
                        switch (data[d]) {
                            case '&': {
                                writer.write(data, first, d - first);
                                writer.write("&amp;");
                                first = d + 1;
                                continue block7;
                            }
                            case '<': {
                                writer.write(data, first, d - first);
                                writer.write("&lt;");
                                first = d + 1;
                                continue block7;
                            }
                            case '>': {
                                writer.write(data, first, d - first);
                                writer.write("&gt;");
                                first = d + 1;
                                continue block7;
                            }
                        }
                    }
                    writer.write(data, first, data.length - first);
                }
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }
    }
}

