/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventConsumer;
import org.xbib.content.resource.XmlNamespaceContext;
import org.xbib.content.xml.util.ToQName;

public class JsonXmlStreamer {
    private final JsonFactory jsonFactory;
    private final XMLEventFactory eventFactory;
    private final XMLOutputFactory outputFactory;
    private QName root;
    private XmlNamespaceContext context = XmlNamespaceContext.newDefaultInstance();
    private Deque<QName> elements;

    public JsonXmlStreamer() {
        this.root = new QName("root");
        this.eventFactory = XMLEventFactory.newInstance();
        this.outputFactory = XMLOutputFactory.newInstance();
        this.outputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        this.jsonFactory = new JsonFactory();
        this.elements = new ArrayDeque<QName>();
    }

    public JsonXmlStreamer root(QName root) {
        this.root = root;
        return this;
    }

    public JsonXmlStreamer context(XmlNamespaceContext context) {
        this.context = context;
        return this;
    }

    public XMLEventWriter openWriter(OutputStream out) throws XMLStreamException {
        return this.openWriter(out, "UTF-8");
    }

    public XMLEventWriter openWriter(OutputStream out, String encoding) throws XMLStreamException {
        return this.outputFactory.createXMLEventWriter(out, encoding);
    }

    public XMLEventWriter openWriter(Writer writer) throws XMLStreamException {
        return this.outputFactory.createXMLEventWriter(writer);
    }

    public void writeXMLProcessingInstruction(XMLEventConsumer consumer, String encoding) throws XMLStreamException {
        consumer.add(this.eventFactory.createProcessingInstruction("xml", "version=\"1.0\" encoding=\"" + encoding + "\""));
    }

    public void writeStylesheetInstruction(XMLEventConsumer consumer, String stylesheet) throws XMLStreamException {
        consumer.add(this.eventFactory.createProcessingInstruction("xml-stylesheet", "type=\"text/xsl\" href=\"" + stylesheet + "\""));
    }

    public void toXML(InputStream in, Writer writer) throws XMLStreamException, IOException {
        this.toXML(in, (XMLEventConsumer)this.openWriter(writer));
        writer.flush();
    }

    public void toXML(InputStream in, OutputStream out) throws XMLStreamException, IOException {
        this.toXML(in, (XMLEventConsumer)this.openWriter(out));
        out.flush();
    }

    public void toXML(Reader in, Writer out) throws XMLStreamException, IOException {
        this.toXML(in, (XMLEventConsumer)this.openWriter(out));
        out.flush();
    }

    public void toXML(InputStream in, XMLEventConsumer consumer) throws XMLStreamException, IOException {
        this.toXML((Reader)new InputStreamReader(in, StandardCharsets.UTF_8), consumer);
    }

    public void toXML(Reader in, XMLEventConsumer consumer) throws XMLStreamException, IOException {
        JsonParser parser = this.jsonFactory.createParser(in);
        JsonToken token = parser.nextToken();
        if (token != JsonToken.START_OBJECT) {
            throw new IOException("JSON first token is not START_OBJECT");
        }
        QName qname = this.root;
        boolean namespaceDecls = true;
        try {
            this.writeXMLProcessingInstruction(consumer, "UTF-8");
            while (token != null) {
                switch (token) {
                    case START_OBJECT: {
                        consumer.add(this.eventFactory.createStartElement(qname, null, null));
                        if (namespaceDecls) {
                            if (!this.context.getNamespaces().containsKey(qname.getPrefix())) {
                                consumer.add(this.eventFactory.createNamespace(qname.getPrefix(), qname.getNamespaceURI()));
                            }
                            for (String prefix : this.context.getNamespaces().keySet()) {
                                String namespaceURI = this.context.getNamespaceURI(prefix);
                                consumer.add(this.eventFactory.createNamespace(prefix, namespaceURI));
                            }
                            namespaceDecls = false;
                        }
                        this.elements.push(qname);
                        break;
                    }
                    case END_OBJECT: {
                        qname = this.elements.pop();
                        consumer.add(this.eventFactory.createEndElement(qname, null));
                        break;
                    }
                    case START_ARRAY: {
                        this.elements.push(qname);
                        break;
                    }
                    case END_ARRAY: {
                        qname = this.elements.pop();
                        break;
                    }
                    case FIELD_NAME: {
                        qname = ToQName.toQName(this.root, (NamespaceContext)this.context, parser.getCurrentName());
                        break;
                    }
                    case VALUE_STRING: 
                    case VALUE_NUMBER_INT: 
                    case VALUE_NUMBER_FLOAT: 
                    case VALUE_NULL: 
                    case VALUE_TRUE: 
                    case VALUE_FALSE: {
                        String text;
                        int len;
                        if (parser.getCurrentName() != null) {
                            qname = ToQName.toQName(this.root, (NamespaceContext)this.context, parser.getCurrentName());
                        }
                        if ((len = (text = parser.getText()).length()) <= 0) break;
                        consumer.add(this.eventFactory.createStartElement(qname, null, null));
                        consumer.add(this.eventFactory.createCharacters(text));
                        consumer.add(this.eventFactory.createEndElement(qname, null));
                        break;
                    }
                    default: {
                        throw new IOException("unknown JSON token: " + token);
                    }
                }
                token = parser.nextToken();
            }
        }
        catch (JsonParseException e) {
            throw new IOException(e);
        }
        finally {
            if (consumer instanceof XMLEventWriter) {
                ((XMLEventWriter)consumer).flush();
            }
        }
    }
}

