/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.json;

import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.xbib.content.resource.XmlNamespaceContext;
import org.xbib.content.xml.json.JsonSaxAdapter;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class JsonXmlReader
implements XMLReader {
    private QName root = new QName("root");
    private XmlNamespaceContext context = XmlNamespaceContext.newDefaultInstance();
    private Map<String, Boolean> map = new HashMap<String, Boolean>();
    private ContentHandler contentHandler;
    private EntityResolver entityResolver;
    private DTDHandler dtdHandler;
    private ErrorHandler errorHandler;

    public JsonXmlReader root(QName root) {
        this.root = root;
        return this;
    }

    public JsonXmlReader context(XmlNamespaceContext context) {
        this.context = context;
        return this;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.map.put(name, value);
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.map.get(name);
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException {
        if (input.getCharacterStream() != null) {
            new JsonSaxAdapter(input.getCharacterStream(), this.contentHandler).root(this.root).context(this.context).parse();
        } else if (input.getByteStream() != null) {
            String encoding = input.getEncoding() != null ? input.getEncoding() : System.getProperty("file.encoding");
            new JsonSaxAdapter(new InputStreamReader(input.getByteStream(), encoding), this.contentHandler).root(this.root).context(this.context).parse();
        }
    }

    @Override
    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException();
    }
}

