/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.stream;

import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xbib.content.xml.stream.AbstractStaxContentHandler;
import org.xbib.content.xml.stream.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class StaxStreamContentHandler
extends AbstractStaxContentHandler {
    private final XMLStreamWriter streamWriter;

    public StaxStreamContentHandler(XMLStreamWriter streamWriter) {
        this.streamWriter = streamWriter;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    protected void charactersInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start, length);
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeEndDocument();
    }

    @Override
    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeEndElement();
    }

    @Override
    protected void ignorableWhitespaceInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.streamWriter.writeCharacters(ch, start, length);
    }

    @Override
    protected void processingInstructionInternal(String target, String data) throws XMLStreamException {
        this.streamWriter.writeProcessingInstruction(target, data);
    }

    @Override
    protected void skippedEntityInternal(String name) {
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.streamWriter.writeStartDocument();
    }

    @Override
    protected void startElementInternal(QName name, Attributes attributes, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        this.streamWriter.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
        String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
        if (defaultNamespaceUri != null && defaultNamespaceUri.length() > 0) {
            this.streamWriter.writeNamespace("", defaultNamespaceUri);
            this.streamWriter.setDefaultNamespace(defaultNamespaceUri);
        }
        Iterator<String> iterator = namespaceContext.getBoundPrefixes();
        while (iterator.hasNext()) {
            String prefix = iterator.next();
            this.streamWriter.writeNamespace(prefix, namespaceContext.getNamespaceURI(prefix));
            this.streamWriter.setPrefix(prefix, namespaceContext.getNamespaceURI(prefix));
        }
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName attrName = this.toQName(attributes.getURI(i), attributes.getQName(i));
            if ("xmlns".equals(attrName.getLocalPart()) || "xmlns".equals(attrName.getPrefix())) continue;
            this.streamWriter.writeAttribute(attrName.getPrefix(), attrName.getNamespaceURI(), attrName.getLocalPart(), attributes.getValue(i));
        }
    }
}

