/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.transform;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXSource;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class TransformerURIResolver
implements URIResolver,
Closeable {
    private static final Logger logger = Logger.getLogger(TransformerURIResolver.class.getName());
    private List<InputStream> inputStreams = new LinkedList<InputStream>();
    private List<String> bases = new LinkedList<String>();
    private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();

    public TransformerURIResolver() {
    }

    public TransformerURIResolver(String ... bases) {
        this.bases.addAll(Arrays.asList(bases));
    }

    public TransformerURIResolver setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    @Override
    public Source resolve(String hrefAttribute, String base) throws TransformerException {
        String href = hrefAttribute;
        InputStream in = null;
        URL url = null;
        try {
            URI uri = URI.create(href);
            if (!uri.isAbsolute() && base != null) {
                url = new URL(new URL(base), href);
                href = url.toURI().getRawSchemeSpecificPart();
            }
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TransformerException(e);
        }
        String systemId = href;
        if (url != null) {
            try {
                in = url.openStream();
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "error while opening stream", e);
            }
        }
        if (in == null) {
            try {
                url = this.classLoader.getResource(href);
                if (url != null) {
                    systemId = url.toExternalForm();
                    in = url.openStream();
                } else {
                    systemId = href;
                    in = this.classLoader.getResourceAsStream(href);
                    if (in == null) {
                        if (this.bases.isEmpty()) {
                            systemId = href;
                        } else {
                            for (String s : this.bases) {
                                systemId = s + "/" + href;
                                in = this.classLoader.getResourceAsStream(systemId);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                throw new TransformerException("I/O error", e);
            }
        }
        if (in == null) {
            throw new TransformerException("href could not be resolved: " + href);
        }
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            SAXParser parser = factory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            this.inputStreams.add(in);
            SAXSource source = new SAXSource(reader, new InputSource(in));
            source.setSystemId(systemId);
            return source;
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new TransformerException("no XML reader for SAX source in URI resolving for:" + href, e);
        }
    }

    @Override
    public void close() throws IOException {
        for (InputStream in : this.inputStreams) {
            in.close();
        }
    }
}

