/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import org.xbib.content.AbstractXContentGenerator;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.XContentGenerator;
import org.xbib.content.XContentHelper;
import org.xbib.content.XContentParser;
import org.xbib.content.XContentString;
import org.xbib.content.io.BytesReference;
import org.xbib.content.xml.XmlXContent;
import org.xbib.content.xml.XmlXContentParser;
import org.xbib.content.xml.XmlXParams;
import org.xbib.content.xml.util.ISO9075;
import org.xbib.content.xml.util.XMLUtil;

public class XmlXContentGenerator
extends AbstractXContentGenerator {
    private static final Logger logger = Logger.getLogger(XmlXContentGenerator.class.getName());
    private final XmlXContentGeneratorDelegate delegate;
    private XmlXParams params;

    public XmlXContentGenerator(ToXmlGenerator generator) {
        this(generator, XmlXParams.getDefaultParams());
    }

    public XmlXContentGenerator(ToXmlGenerator generator, XmlXParams params) {
        this.params = params;
        generator.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, false);
        this.delegate = new XmlXContentGeneratorDelegate(generator, params);
        super.setGenerator((XContentGenerator)this.delegate);
    }

    public XmlXParams getParams() {
        return this.params;
    }

    public XmlXContentGenerator setParams(XmlXParams params) {
        this.delegate.setParams(params);
        return this;
    }

    public XContent content() {
        return this.delegate.content();
    }

    public void usePrettyPrint() {
        this.delegate.usePrettyPrint();
    }

    public void writeStartObject() throws IOException {
        this.delegate.writeStartObject();
    }

    public void writeFieldName(String name) throws IOException {
        this.delegate.writeFieldName(name);
    }

    public void writeFieldName(XContentString name) throws IOException {
        this.delegate.writeFieldName(name);
    }

    public void writeString(String text) throws IOException {
        this.delegate.writeString(text);
    }

    public void writeString(char[] text, int offset, int len) throws IOException {
        this.delegate.writeString(text, offset, len);
    }

    public void writeRawField(String fieldName, byte[] content, OutputStream outputStream) throws IOException {
        this.delegate.writeRawField(fieldName, content, outputStream);
    }

    public void writeRawField(String fieldName, BytesReference content, OutputStream outputStream) throws IOException {
        this.delegate.writeRawField(fieldName, content, outputStream);
    }

    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream outputStream) throws IOException {
        this.delegate.writeRawField(fieldName, content, outputStream);
    }

    public void writeValue(XContentBuilder builder) throws IOException {
        this.delegate.writeValue(builder);
    }

    public void copyCurrentStructure(XContentParser parser) throws IOException {
        this.delegate.copyCurrentStructure(parser);
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private static class XmlXContentGeneratorDelegate
    implements XContentGenerator {
        final ToXmlGenerator generator;
        private XmlXParams params;
        private boolean rootUsed = false;

        XmlXContentGeneratorDelegate(ToXmlGenerator xmlGenerator, XmlXParams params) {
            this.generator = xmlGenerator;
            this.params = params;
        }

        public void setParams(XmlXParams params) {
            this.params = params;
            try {
                this.generator.getStaxWriter().setPrefix(params.getRoot().getPrefix(), params.getRoot().getNamespaceURI());
            }
            catch (XMLStreamException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }

        public XContent content() {
            return XmlXContent.xmlXContent();
        }

        public void usePrettyPrint() {
            this.generator.useDefaultPrettyPrinter();
        }

        public void writeStartArray() throws IOException {
            this.generator.writeStartArray();
        }

        public void writeEndArray() throws IOException {
            this.generator.writeEndArray();
        }

        public void writeStartObject() throws IOException {
            if (!this.rootUsed) {
                this.generator.setNextName(this.params.getRoot());
            }
            this.generator.writeStartObject();
            if (!this.rootUsed) {
                try {
                    for (String prefix : this.params.getNamespaceContext().getNamespaces().keySet()) {
                        String uri = this.params.getNamespaceContext().getNamespaceURI(prefix);
                        if (uri == null || uri.isEmpty()) continue;
                        this.generator.getStaxWriter().writeNamespace(prefix, uri);
                    }
                }
                catch (XMLStreamException e) {
                    logger.log(Level.SEVERE, e.getMessage(), e);
                }
                this.rootUsed = true;
            }
        }

        public void writeEndObject() throws IOException {
            this.generator.writeEndObject();
        }

        public void writeFieldName(String name) throws IOException {
            this.writeFieldNameWithNamespace(name);
        }

        public void writeFieldName(XContentString name) throws IOException {
            this.writeFieldNameWithNamespace(name);
        }

        public void writeString(String text) throws IOException {
            this.generator.writeString(XMLUtil.sanitize(text));
        }

        public void writeString(char[] text, int offset, int len) throws IOException {
            this.generator.writeString(XMLUtil.sanitize(new String(text, offset, len)));
        }

        public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
            this.generator.writeUTF8String(text, offset, length);
        }

        public void writeBinary(byte[] data, int offset, int len) throws IOException {
            this.generator.writeBinary(data, offset, len);
        }

        public void writeBinary(byte[] data) throws IOException {
            this.generator.writeBinary(data);
        }

        public void writeNumber(int v) throws IOException {
            this.generator.writeNumber(v);
        }

        public void writeNumber(long v) throws IOException {
            this.generator.writeNumber(v);
        }

        public void writeNumber(double d) throws IOException {
            this.generator.writeNumber(d);
        }

        public void writeNumber(float f) throws IOException {
            this.generator.writeNumber(f);
        }

        public void writeNumber(BigInteger bi) throws IOException {
            this.generator.writeNumber(bi);
        }

        public void writeNumber(BigDecimal bd) throws IOException {
            this.generator.writeNumber(bd);
        }

        public void writeBoolean(boolean state) throws IOException {
            this.generator.writeBoolean(state);
        }

        public void writeNull() throws IOException {
            this.generator.writeNull();
        }

        public void writeStringField(String fieldName, String value) throws IOException {
            this.generator.writeStringField(fieldName, value);
        }

        public void writeStringField(XContentString fieldName, String value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeString(value);
        }

        public void writeBooleanField(String fieldName, boolean value) throws IOException {
            this.generator.writeBooleanField(fieldName, value);
        }

        public void writeBooleanField(XContentString fieldName, boolean value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeBoolean(value);
        }

        public void writeNullField(String fieldName) throws IOException {
            this.generator.writeNullField(fieldName);
        }

        public void writeNumberField(String fieldName, int value) throws IOException {
            this.generator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(XContentString fieldName, int value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(String fieldName, long value) throws IOException {
            this.generator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(XContentString fieldName, long value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(String fieldName, double value) throws IOException {
            this.generator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(XContentString fieldName, double value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(String fieldName, float value) throws IOException {
            this.generator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(XContentString fieldName, float value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(String fieldName, BigInteger value) throws IOException {
            this.generator.writeFieldName(fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(XContentString fieldName, BigInteger value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(String fieldName, BigDecimal value) throws IOException {
            this.generator.writeFieldName(fieldName);
            this.generator.writeNumber(value);
        }

        public void writeNumberField(XContentString fieldName, BigDecimal value) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeNumber(value);
        }

        public void writeBinaryField(String fieldName, byte[] data) throws IOException {
            this.generator.writeBinaryField(fieldName, data);
        }

        public void writeBinaryField(XContentString fieldName, byte[] data) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeBinary(data);
        }

        public void writeArrayFieldStart(String fieldName) throws IOException {
            this.generator.writeArrayFieldStart(fieldName);
        }

        public void writeArrayFieldStart(XContentString fieldName) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeStartArray();
        }

        public void writeObjectFieldStart(String fieldName) throws IOException {
            this.generator.writeObjectFieldStart(fieldName);
        }

        public void writeObjectFieldStart(XContentString fieldName) throws IOException {
            this.generator.writeFieldName((SerializableString)fieldName);
            this.generator.writeStartObject();
        }

        public void writeRawField(String fieldName, byte[] content, OutputStream outputStream) throws IOException {
            this.writeFieldNameWithNamespace(fieldName);
            try (JsonParser parser = this.params.getXmlFactory().createParser(content);){
                parser.nextToken();
                this.params.getXmlFactory().createGenerator(outputStream).copyCurrentStructure(parser);
            }
        }

        public void writeRawField(String fieldName, BytesReference content, OutputStream outputStream) throws IOException {
            this.writeFieldNameWithNamespace(fieldName);
            try (JsonParser parser = this.params.getXmlFactory().createParser((InputStream)content.streamInput());){
                parser.nextToken();
                this.params.getXmlFactory().createGenerator(outputStream).copyCurrentStructure(parser);
            }
        }

        public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream outputStream) throws IOException {
            this.writeFieldNameWithNamespace(fieldName);
            try (JsonParser parser = this.params.getXmlFactory().createParser(content, offset, length);){
                parser.nextToken();
                this.params.getXmlFactory().createGenerator(outputStream).copyCurrentStructure(parser);
            }
        }

        public void writeValue(XContentBuilder builder) throws IOException {
            this.generator.writeRawValue(builder.string());
        }

        public void copy(XContentBuilder builder, OutputStream bos) throws IOException {
            this.flush();
            builder.bytes().streamOutput(bos);
        }

        public void copyCurrentStructure(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            if (parser instanceof XmlXContentParser) {
                this.generator.copyCurrentStructure(((XmlXContentParser)parser).parser);
            } else {
                XContentHelper.copyCurrentStructure((XContentGenerator)this, (XContentParser)parser);
            }
        }

        public void flush() throws IOException {
            this.generator.flush();
        }

        public void close() throws IOException {
            if (this.generator.isClosed()) {
                return;
            }
            this.generator.close();
        }

        private void writeFieldNameWithNamespace(String name) throws IOException {
            QName qname = this.toQualifiedName((NamespaceContext)this.params.getNamespaceContext(), name);
            try {
                this.generator.getStaxWriter().setPrefix(qname.getPrefix(), qname.getNamespaceURI());
            }
            catch (XMLStreamException e) {
                throw new IOException(e);
            }
            this.generator.setNextName(qname);
            this.generator.writeFieldName(qname.getLocalPart());
        }

        private void writeFieldNameWithNamespace(XContentString name) throws IOException {
            this.writeFieldNameWithNamespace(name.getValue());
        }

        private QName toQualifiedName(NamespaceContext context, String string) {
            String name = string;
            if (name.startsWith("_") || name.startsWith("@")) {
                name = name.substring(1);
            }
            name = ISO9075.encode(name);
            int pos = name.indexOf(58);
            String nsPrefix = "";
            Object nsURI = context.getNamespaceURI("");
            if (pos > 0) {
                nsPrefix = name.substring(0, pos);
                nsURI = context.getNamespaceURI(nsPrefix);
                if (nsURI == null) {
                    if (this.params.isFatalNamespaceErrors()) {
                        throw new IllegalArgumentException("unknown namespace prefix: " + nsPrefix);
                    }
                    nsURI = "xbib:namespace/" + nsPrefix;
                }
                name = name.substring(pos + 1);
            }
            return new QName((String)nsURI, name, nsPrefix);
        }
    }
}

