/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.xbib.content.resource.NamespaceContext;

public class XmlNamespaceContext
implements javax.xml.namespace.NamespaceContext,
NamespaceContext {
    private final SortedMap<String, String> namespaces = new TreeMap<String, String>();
    private final SortedMap<String, Set<String>> prefixes = new TreeMap<String, Set<String>>();
    protected final Object lock = new Object();

    protected XmlNamespaceContext() {
    }

    protected XmlNamespaceContext(ResourceBundle bundle) {
        this();
        Enumeration<String> en = bundle.getKeys();
        while (en.hasMoreElements()) {
            String prefix = en.nextElement();
            String namespace = bundle.getString(prefix);
            this.addNamespace(prefix, namespace);
        }
    }

    public static XmlNamespaceContext newInstance() {
        return new XmlNamespaceContext();
    }

    public static XmlNamespaceContext newInstance(String bundleName, Locale locale, ClassLoader classLoader) {
        try {
            ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale, classLoader);
            return new XmlNamespaceContext(bundle);
        }
        catch (MissingResourceException e) {
            return new XmlNamespaceContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNamespace(String prefix, String namespace) {
        if (prefix != null && namespace != null) {
            Object object = this.lock;
            synchronized (object) {
                this.namespaces.put(prefix, namespace);
                if (this.prefixes.containsKey(namespace)) {
                    ((Set)this.prefixes.get(namespace)).add(prefix);
                } else {
                    HashSet<String> set = new HashSet<String>();
                    set.add(prefix);
                    this.prefixes.put(namespace, set);
                }
            }
        }
    }

    public SortedMap<String, String> getNamespaces() {
        return this.namespaces;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            return null;
        }
        return this.namespaces.getOrDefault(prefix, null);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        Iterator<String> it = this.getPrefixes(namespaceURI);
        return it != null && it.hasNext() ? it.next() : null;
    }

    @Override
    public Iterator<String> getPrefixes(String namespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace URI cannot be null");
        }
        return this.prefixes.containsKey(namespace) ? ((Set)this.prefixes.get(namespace)).iterator() : null;
    }

    public String toString() {
        return this.namespaces.toString();
    }
}

