/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.dataformat.xml.XmlFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.XContentGenerator;
import org.xbib.content.XContentParser;
import org.xbib.content.io.BytesReference;
import org.xbib.content.xml.XmlXContentGenerator;
import org.xbib.content.xml.XmlXContentParser;
import org.xbib.content.xml.XmlXParams;

public class XmlXContent
implements XContent {
    private static XmlXContent xmlXContent;
    private XmlFactory xmlFactory;

    public XmlXContent() {
        this(XmlXParams.createXmlFactory(XmlXParams.createXMLInputFactory(), XmlXParams.createXMLOutputFactory()));
    }

    private XmlXContent(XmlFactory xmlFactory) {
        this.xmlFactory = xmlFactory;
    }

    public static XContentBuilder contentBuilder() throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)XmlXContent.xmlXContent());
        if (builder.generator() instanceof XmlXContentGenerator) {
            ((XmlXContentGenerator)builder.generator()).setParams(XmlXParams.getDefaultParams());
        }
        return builder;
    }

    public static XContentBuilder contentBuilder(OutputStream outputStream) throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)XmlXContent.xmlXContent(), (OutputStream)outputStream);
        if (builder.generator() instanceof XmlXContentGenerator) {
            ((XmlXContentGenerator)builder.generator()).setParams(XmlXParams.getDefaultParams());
        }
        return builder;
    }

    public static XContentBuilder contentBuilder(XmlXParams params) throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)XmlXContent.xmlXContent(params.getXmlFactory()));
        if (builder.generator() instanceof XmlXContentGenerator) {
            ((XmlXContentGenerator)builder.generator()).setParams(params);
        }
        return builder;
    }

    public static XContentBuilder contentBuilder(XmlXParams params, OutputStream outputStream) throws IOException {
        XContentBuilder builder = XContentBuilder.builder((XContent)XmlXContent.xmlXContent(params.getXmlFactory()), (OutputStream)outputStream);
        if (builder.generator() instanceof XmlXContentGenerator) {
            ((XmlXContentGenerator)builder.generator()).setParams(params);
        }
        return builder;
    }

    public static XmlXContent xmlXContent() {
        if (xmlXContent == null) {
            xmlXContent = new XmlXContent(XmlXParams.createXmlFactory(XmlXParams.createXMLInputFactory(), XmlXParams.createXMLOutputFactory()));
        }
        return xmlXContent;
    }

    public static XmlXContent xmlXContent(XmlFactory xmlFactory) {
        if (xmlXContent == null) {
            xmlXContent = new XmlXContent(xmlFactory);
        }
        return xmlXContent;
    }

    public String name() {
        return "xml";
    }

    public XContentGenerator createGenerator(OutputStream outputStream) throws IOException {
        return new XmlXContentGenerator(this.xmlFactory.createGenerator(outputStream, JsonEncoding.UTF8));
    }

    public XContentGenerator createGenerator(Writer writer) throws IOException {
        return new XmlXContentGenerator(this.xmlFactory.createGenerator(writer));
    }

    public XContentParser createParser(String content) throws IOException {
        return new XmlXContentParser(this.xmlFactory.createParser(content.getBytes(StandardCharsets.UTF_8)));
    }

    public XContentParser createParser(InputStream is) throws IOException {
        return new XmlXContentParser(this.xmlFactory.createParser(is));
    }

    public XContentParser createParser(byte[] data) throws IOException {
        return new XmlXContentParser(this.xmlFactory.createParser(data));
    }

    public XContentParser createParser(byte[] data, int offset, int length) throws IOException {
        return new XmlXContentParser(this.xmlFactory.createParser(data, offset, length));
    }

    public XContentParser createParser(Reader reader) throws IOException {
        return new XmlXContentParser(this.xmlFactory.createParser(reader));
    }

    public XContentParser createParser(BytesReference bytes) throws IOException {
        return this.createParser((InputStream)bytes.streamInput());
    }

    public boolean isXContent(BytesReference bytes) {
        int length;
        int n = length = bytes.length() < 20 ? bytes.length() : 20;
        if (length == 0) {
            return false;
        }
        byte first = bytes.get(0);
        return length > 2 && first == 60 && bytes.get(1) == 63 && bytes.get(2) == 120;
    }
}

