/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.stream;

import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import org.xbib.content.xml.stream.AbstractXMLReader;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

abstract class AbstractStaxXMLReader
extends AbstractXMLReader {
    private static final String NAMESPACES_FEATURE_NAME = "http://xml.org/sax/features/namespaces";
    private static final String NAMESPACE_PREFIXES_FEATURE_NAME = "http://xml.org/sax/features/namespace-prefixes";
    private static final String IS_STANDALONE_FEATURE_NAME = "http://xml.org/sax/features/is-standalone";
    private boolean namespacesFeature = true;
    private boolean namespacePrefixesFeature = false;
    private Boolean isStandalone;

    AbstractStaxXMLReader() {
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES_FEATURE_NAME)) {
            return this.namespacesFeature;
        }
        if (name.equals(NAMESPACE_PREFIXES_FEATURE_NAME)) {
            return this.namespacePrefixesFeature;
        }
        if (name.equals(IS_STANDALONE_FEATURE_NAME)) {
            if (this.isStandalone != null) {
                return this.isStandalone;
            }
            throw new SAXNotSupportedException("startDocument() callback not completed yet");
        }
        return super.getFeature(name);
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(NAMESPACES_FEATURE_NAME)) {
            this.namespacesFeature = value;
        } else if (name.equals(NAMESPACE_PREFIXES_FEATURE_NAME)) {
            this.namespacePrefixesFeature = value;
        } else {
            super.setFeature(name, value);
        }
    }

    protected void setStandalone(boolean standalone) {
        this.isStandalone = standalone;
    }

    protected boolean hasNamespacesFeature() {
        return this.namespacesFeature;
    }

    protected boolean hasNamespacePrefixesFeature() {
        return this.namespacePrefixesFeature;
    }

    protected void setLocator(Location location) {
        if (this.getContentHandler() != null) {
            this.getContentHandler().setDocumentLocator(new StaxLocator(location));
        }
    }

    protected String toQualifiedName(QName qName) {
        String prefix = qName.getPrefix();
        if (prefix.length() > 0) {
            return qName.getLocalPart();
        }
        return prefix + ":" + qName.getLocalPart();
    }

    @Override
    public final void parse(InputSource ignored) throws SAXException {
        this.parse();
    }

    @Override
    public final void parse(String ignored) throws SAXException {
        this.parse();
    }

    private void parse() throws SAXException {
        try {
            this.parseInternal();
        }
        catch (XMLStreamException ex) {
            StaxLocator locator = null;
            if (ex.getLocation() != null) {
                locator = new StaxLocator(ex.getLocation());
            }
            SAXParseException saxException = new SAXParseException(ex.getMessage(), locator, ex);
            if (this.getErrorHandler() != null) {
                this.getErrorHandler().fatalError(saxException);
            }
            throw saxException;
        }
    }

    protected abstract void parseInternal() throws SAXException, XMLStreamException;

    private static class StaxLocator
    implements Locator {
        private Location location;

        StaxLocator(Location location) {
            this.location = location;
        }

        @Override
        public String getPublicId() {
            return this.location.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.location.getSystemId();
        }

        @Override
        public int getLineNumber() {
            return this.location.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.location.getColumnNumber();
        }
    }
}

