/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.transform;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamSource;
import org.xbib.content.xml.transform.TransformerErrorListener;

public final class StylesheetPool {
    private final Map<String, Templates> stylesheets = new ConcurrentHashMap<String, Templates>();

    public TransformerHandler getIdentityTransformerHandler(SAXTransformerFactory transformerFactory) throws TransformerConfigurationException {
        return transformerFactory.newTransformerHandler();
    }

    public boolean hasTemplate(StreamSource source) {
        return this.stylesheets.containsKey(source.getSystemId());
    }

    public Templates getTemplate(String systemId) {
        return this.stylesheets.get(systemId);
    }

    public Templates newTemplates(SAXTransformerFactory transformerFactory, Source source) throws TransformerConfigurationException {
        String systemId = source.getSystemId();
        Templates template = this.stylesheets.get(systemId);
        if (template == null) {
            template = transformerFactory.newTemplates(source);
            this.stylesheets.put(systemId, template);
        }
        return template;
    }

    public TransformerHandler newTransformerHandler(SAXTransformerFactory transformerFactory, Templates template) throws TransformerConfigurationException {
        TransformerHandler handler = transformerFactory.newTransformerHandler(template);
        handler.getTransformer().setErrorListener(new TransformerErrorListener());
        return handler;
    }
}

