/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.transform;

import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.URIResolver;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.xbib.content.xml.transform.DefaultStylesheetErrorListener;
import org.xbib.content.xml.transform.StylesheetPool;
import org.xbib.content.xml.transform.TransformerURIResolver;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;

public class StylesheetTransformer
implements Closeable {
    private static final StylesheetPool pool = new StylesheetPool();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private SAXTransformerFactory transformerFactory;
    private URIResolver resolver;
    private Source source;
    private Result result;

    public StylesheetTransformer setPath(String ... path) {
        if (this.transformerFactory == null) {
            this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        this.transformerFactory.setErrorListener(new DefaultStylesheetErrorListener());
        this.setResolver(path == null ? new TransformerURIResolver() : new TransformerURIResolver(path));
        return this;
    }

    public StylesheetTransformer setResolver(URIResolver resolver) {
        this.resolver = resolver;
        if (this.transformerFactory == null) {
            this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        this.transformerFactory.setURIResolver(resolver);
        return this;
    }

    public StylesheetTransformer addParameter(String name, Object value) {
        this.parameters.put(name, value);
        return this;
    }

    public Map<String, Object> getParameters() {
        return this.parameters;
    }

    public StylesheetTransformer setSource(Reader reader) {
        this.source = new StreamSource(reader);
        return this;
    }

    public StylesheetTransformer setSource(InputSource source) {
        this.source = new SAXSource(source);
        return this;
    }

    public StylesheetTransformer setSource(Source source) {
        this.source = source;
        return this;
    }

    public StylesheetTransformer setSource(XMLReader reader, InputSource in) {
        this.source = new SAXSource(reader, in);
        return this;
    }

    public StylesheetTransformer setSource(XMLReader reader, InputSource in, String xsl, ContentHandler handler) throws TransformerException {
        if (this.transformerFactory == null) {
            this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        XMLFilter filter = this.transformerFactory.newXMLFilter(this.resolver.resolve(xsl, null));
        filter.setParent(reader);
        filter.setContentHandler(handler);
        this.source = new SAXSource(filter, in);
        return this;
    }

    public StylesheetTransformer setResult(Writer result) {
        this.result = new StreamResult(result);
        return this;
    }

    public StylesheetTransformer setResult(OutputStream result) {
        this.result = new StreamResult(result);
        return this;
    }

    public StylesheetTransformer setResult(Result result) {
        this.result = result;
        return this;
    }

    public void transform() throws TransformerException {
        if (this.source == null) {
            return;
        }
        if (this.result == null) {
            return;
        }
        if (this.transformerFactory == null) {
            this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        Transformer transformer = this.transformerFactory.newTransformer();
        transformer.transform(this.source, this.result);
    }

    public void transform(Iterable<String> xsl) throws TransformerException {
        this.transform(null, xsl);
    }

    public void transform(String base, Iterable<String> xsl) throws TransformerException {
        if (this.source == null) {
            return;
        }
        if (this.result == null) {
            return;
        }
        if (xsl == null) {
            return;
        }
        if (this.transformerFactory == null) {
            this.transformerFactory = (SAXTransformerFactory)TransformerFactory.newInstance();
        }
        Transformer transformer = this.transformerFactory.newTransformer();
        LinkedList<TransformerHandler> handlers = new LinkedList<TransformerHandler>();
        for (String s : xsl) {
            Templates t = pool.newTemplates(this.transformerFactory, this.resolver.resolve(s, base));
            TransformerHandler h = pool.newTransformerHandler(this.transformerFactory, t);
            for (Map.Entry<String, Object> me : this.parameters.entrySet()) {
                if (me.getValue() == null) continue;
                h.getTransformer().setParameter(me.getKey(), me.getValue());
            }
            handlers.add(h);
        }
        Result r = this.result;
        ListIterator it = handlers.listIterator(handlers.size());
        while (it.hasPrevious()) {
            TransformerHandler h = (TransformerHandler)it.previous();
            h.setResult(r);
            r = new SAXResult(h);
        }
        transformer.transform(this.source, r);
    }

    @Override
    public void close() throws IOException {
        if (this.resolver != null && this.resolver instanceof TransformerURIResolver) {
            TransformerURIResolver transformerURIResolver = (TransformerURIResolver)this.resolver;
            transformerURIResolver.close();
        }
    }
}

