/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.XContentParser;
import org.xbib.content.core.XContentService;
import org.xbib.content.xml.XmlXContent;
import org.xbib.content.xml.XmlXParams;

public class XmlXContentHelper {
    private XmlXContentHelper() {
    }

    public static Map<String, Object> convertFromXmlToMap(Reader reader) {
        try {
            return XmlXContent.xmlXContent().createParser(reader).mapOrderedAndClose();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse content to map", e);
        }
    }

    public static Map<String, Object> convertFromXmlToMap(String data) {
        try {
            return XmlXContent.xmlXContent().createParser(data).mapOrderedAndClose();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to parse content to map", e);
        }
    }

    public static String convertToXml(byte[] data, int offset, int length) throws IOException {
        return XmlXContentHelper.convertToXml(XmlXParams.getDefaultParams(), data, offset, length, false);
    }

    public static String convertToXml(byte[] data, int offset, int length, boolean prettyprint) throws IOException {
        return XmlXContentHelper.convertToXml(XmlXParams.getDefaultParams(), data, offset, length, prettyprint);
    }

    public static String convertToXml(XmlXParams params, byte[] data, int offset, int length) throws IOException {
        return XmlXContentHelper.convertToXml(params, data, offset, length, false);
    }

    public static String convertToXml(XmlXParams params, byte[] data, int offset, int length, boolean prettyPrint) throws IOException {
        XContent xContent = XContentService.xContent((byte[])data, (int)offset, (int)length);
        try (XContentParser parser = xContent.createParser(data, offset, length);){
            String string;
            block13: {
                XContentBuilder builder = XmlXContent.contentBuilder(params);
                try {
                    parser.nextToken();
                    if (prettyPrint) {
                        builder.prettyPrint();
                    }
                    builder.copyCurrentStructure(parser);
                    string = builder.string();
                    if (builder == null) break block13;
                }
                catch (Throwable throwable) {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                builder.close();
            }
            return string;
        }
    }
}

