/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.LinkedHashMap;
import org.xbib.content.XContent;
import org.xbib.content.XContentParser;
import org.xbib.content.core.AbstractXContentParser;
import org.xbib.content.core.MapFactory;
import org.xbib.content.xml.XmlXContent;

public class XmlXContentParser
extends AbstractXContentParser {
    protected final JsonParser parser;

    public XmlXContentParser(JsonParser parser) {
        this.parser = parser;
    }

    public XContent content() {
        return XmlXContent.xmlXContent();
    }

    public XContentParser.Token nextToken() throws IOException {
        return this.convertToken(this.parser.nextToken());
    }

    public void skipChildren() throws IOException {
        this.parser.skipChildren();
    }

    public XContentParser.Token currentToken() {
        return this.convertToken(this.parser.getCurrentToken());
    }

    public XContentParser.NumberType numberType() throws IOException {
        return this.convertNumberType(this.parser.getNumberType());
    }

    public boolean estimatedNumberType() {
        return true;
    }

    public String currentName() throws IOException {
        return this.parser.getCurrentName();
    }

    protected MapFactory getMapFactory() {
        return HashMap::new;
    }

    protected MapFactory getOrderedMapFactory() {
        return LinkedHashMap::new;
    }

    protected boolean doBooleanValue() throws IOException {
        return this.parser.getBooleanValue();
    }

    public String text() throws IOException {
        return this.parser.getText();
    }

    public boolean hasTextCharacters() {
        return this.parser.hasTextCharacters();
    }

    public char[] textCharacters() throws IOException {
        return this.parser.getTextCharacters();
    }

    public int textLength() throws IOException {
        return this.parser.getTextLength();
    }

    public int textOffset() throws IOException {
        return this.parser.getTextOffset();
    }

    public Number numberValue() throws IOException {
        return this.parser.getNumberValue();
    }

    public BigInteger bigIntegerValue() throws IOException {
        return this.parser.getBigIntegerValue();
    }

    public BigDecimal bigDecimalValue() throws IOException {
        return this.parser.getDecimalValue();
    }

    public short doShortValue() throws IOException {
        return this.parser.getShortValue();
    }

    public int doIntValue() throws IOException {
        return this.parser.getIntValue();
    }

    public long doLongValue() throws IOException {
        return this.parser.getLongValue();
    }

    public float doFloatValue() throws IOException {
        return this.parser.getFloatValue();
    }

    public double doDoubleValue() throws IOException {
        return this.parser.getDoubleValue();
    }

    public byte[] binaryValue() throws IOException {
        return this.parser.getBinaryValue();
    }

    public void close() throws IOException {
        this.parser.close();
    }

    private XContentParser.NumberType convertNumberType(JsonParser.NumberType numberType) {
        switch (numberType) {
            case INT: {
                return XContentParser.NumberType.INT;
            }
            case LONG: {
                return XContentParser.NumberType.LONG;
            }
            case FLOAT: {
                return XContentParser.NumberType.FLOAT;
            }
            case DOUBLE: {
                return XContentParser.NumberType.DOUBLE;
            }
            case BIG_INTEGER: {
                return XContentParser.NumberType.BIG_INTEGER;
            }
            case BIG_DECIMAL: {
                return XContentParser.NumberType.BIG_DECIMAL;
            }
        }
        throw new IllegalStateException("No matching token for number_type [" + numberType + "]");
    }

    private XContentParser.Token convertToken(JsonToken token) {
        if (token == null) {
            return null;
        }
        switch (token) {
            case FIELD_NAME: {
                return XContentParser.Token.FIELD_NAME;
            }
            case VALUE_FALSE: 
            case VALUE_TRUE: {
                return XContentParser.Token.VALUE_BOOLEAN;
            }
            case VALUE_STRING: {
                return XContentParser.Token.VALUE_STRING;
            }
            case VALUE_NUMBER_INT: 
            case VALUE_NUMBER_FLOAT: {
                return XContentParser.Token.VALUE_NUMBER;
            }
            case VALUE_NULL: {
                return XContentParser.Token.VALUE_NULL;
            }
            case START_OBJECT: {
                return XContentParser.Token.START_OBJECT;
            }
            case END_OBJECT: {
                return XContentParser.Token.END_OBJECT;
            }
            case START_ARRAY: {
                return XContentParser.Token.START_ARRAY;
            }
            case END_ARRAY: {
                return XContentParser.Token.END_ARRAY;
            }
            case VALUE_EMBEDDED_OBJECT: {
                return XContentParser.Token.VALUE_EMBEDDED_OBJECT;
            }
        }
        throw new IllegalStateException("No matching token for json_token [" + token + "]");
    }
}

