/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.json;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.io.Reader;
import java.util.TreeSet;
import javax.xml.namespace.QName;
import org.xbib.content.resource.NamespaceContext;
import org.xbib.content.xml.util.ToQName;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JsonSaxAdapter {
    private static final AttributesImpl EMPTY_ATTRIBUTES = new AttributesImpl();
    private static final JsonFactory factory = new JsonFactory();
    private final JsonParser jsonParser;
    private final ContentHandler contentHandler;
    private QName root = new QName("root");
    private NamespaceContext context;

    public JsonSaxAdapter(Reader reader, ContentHandler contentHandler) throws IOException {
        this(factory.createParser(reader), contentHandler);
    }

    public JsonSaxAdapter(JsonParser jsonParser, ContentHandler contentHandler) {
        this.jsonParser = jsonParser;
        this.contentHandler = contentHandler;
        contentHandler.setDocumentLocator(new DocumentLocator());
    }

    public JsonSaxAdapter root(QName root) {
        this.root = root;
        return this;
    }

    public JsonSaxAdapter context(NamespaceContext context) {
        this.context = context;
        return this;
    }

    public void parse() throws IOException, SAXException {
        this.jsonParser.nextToken();
        this.contentHandler.startDocument();
        this.writeNamespaceDeclarations(this.context);
        if (this.root != null) {
            this.contentHandler.startElement(this.root.getNamespaceURI(), this.root.getLocalPart(), this.root.getPrefix() + ":" + this.root.getLocalPart(), EMPTY_ATTRIBUTES);
        }
        this.parseObject();
        if (this.root != null) {
            this.contentHandler.endElement(this.root.getNamespaceURI(), this.root.getLocalPart(), this.root.getPrefix() + ":" + this.root.getLocalPart());
        }
        this.contentHandler.endDocument();
    }

    private int parseObject() throws SAXException, IOException {
        int elementsWritten = 0;
        while (this.jsonParser.nextToken() != null && this.jsonParser.getCurrentToken() != JsonToken.END_OBJECT) {
            if (JsonToken.FIELD_NAME.equals((Object)this.jsonParser.getCurrentToken())) {
                String elementName = this.jsonParser.getCurrentName();
                this.jsonParser.nextToken();
                this.parseElement(elementName);
                ++elementsWritten;
                continue;
            }
            throw new JsonParseException(this.jsonParser, "expected field name, but got " + this.jsonParser.getCurrentToken(), this.jsonParser.getCurrentLocation());
        }
        return elementsWritten;
    }

    private void parseElement(String elementName) throws SAXException, IOException {
        JsonToken currentToken = this.jsonParser.getCurrentToken();
        if (JsonToken.START_OBJECT.equals((Object)currentToken)) {
            this.startElement(elementName);
            this.parseObject();
            this.endElement(elementName);
        } else if (JsonToken.START_ARRAY.equals((Object)currentToken)) {
            this.parseArray(elementName);
        } else if (currentToken.isScalarValue() && !this.isEmptyValue()) {
            this.startElement(elementName);
            this.parseValue();
            this.endElement(elementName);
        }
    }

    private boolean isEmptyValue() throws IOException {
        return this.jsonParser.getCurrentToken() == JsonToken.VALUE_NULL || this.jsonParser.getText().isEmpty();
    }

    private void parseArray(String elementName) throws IOException, SAXException {
        while (this.jsonParser.nextToken() != JsonToken.END_ARRAY && this.jsonParser.getCurrentToken() != null) {
            this.parseElement(elementName);
        }
    }

    private void parseValue() throws IOException, SAXException {
        if (this.jsonParser.getCurrentToken() != JsonToken.VALUE_NULL) {
            String text = this.jsonParser.getText();
            this.contentHandler.characters(text.toCharArray(), 0, text.length());
        }
    }

    private void startElement(String elementName) throws SAXException {
        QName qname = ToQName.toQName(this.root, this.context, elementName);
        this.contentHandler.startElement(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix() + ":" + qname.getLocalPart(), EMPTY_ATTRIBUTES);
    }

    private void endElement(String elementName) throws SAXException {
        QName qname = ToQName.toQName(this.root, this.context, elementName);
        this.contentHandler.endElement(qname.getNamespaceURI(), qname.getLocalPart(), qname.getPrefix() + ":" + qname.getLocalPart());
    }

    private void writeNamespaceDeclarations(NamespaceContext context) throws SAXException {
        TreeSet keys = new TreeSet(context.getNamespaces().keySet());
        if (this.root != null && !keys.contains(this.root.getPrefix())) {
            this.contentHandler.startPrefixMapping(this.root.getPrefix(), this.root.getNamespaceURI());
        }
        for (String prefix : keys) {
            this.contentHandler.startPrefixMapping(prefix, context.getNamespaceURI(prefix));
        }
    }

    private class DocumentLocator
    implements Locator {
        private DocumentLocator() {
        }

        @Override
        public String getPublicId() {
            Object sourceRef = JsonSaxAdapter.this.jsonParser.getCurrentLocation().contentReference().getRawContent();
            if (sourceRef != null) {
                return sourceRef.toString();
            }
            return "";
        }

        @Override
        public String getSystemId() {
            return this.getPublicId();
        }

        @Override
        public int getLineNumber() {
            return JsonSaxAdapter.this.jsonParser.getCurrentLocation() != null ? JsonSaxAdapter.this.jsonParser.getCurrentLocation().getLineNr() : -1;
        }

        @Override
        public int getColumnNumber() {
            return JsonSaxAdapter.this.jsonParser.getCurrentLocation() != null ? JsonSaxAdapter.this.jsonParser.getCurrentLocation().getColumnNr() : -1;
        }
    }
}

