/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.stream;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventConsumer;
import org.xbib.content.xml.stream.AbstractStaxContentHandler;
import org.xbib.content.xml.stream.SimpleNamespaceContext;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class StaxEventContentHandler
extends AbstractStaxContentHandler {
    private final XMLEventFactory eventFactory;
    private final XMLEventConsumer eventConsumer;
    private Locator locator;

    public StaxEventContentHandler(XMLEventConsumer consumer) {
        this.eventFactory = XMLEventFactory.newInstance();
        this.eventConsumer = consumer;
    }

    public StaxEventContentHandler(XMLEventConsumer consumer, XMLEventFactory factory) {
        this.eventFactory = factory;
        this.eventConsumer = consumer;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    protected void startDocumentInternal() throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createStartDocument());
    }

    @Override
    protected void endDocumentInternal() throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createEndDocument());
    }

    @Override
    protected void startElementInternal(QName name, Attributes atts, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        List<Attribute> attributes = this.getAttributes(atts);
        List<Namespace> namespaces = this.createNamespaces(namespaceContext);
        this.consumeEvent(this.eventFactory.createStartElement(name, attributes.iterator(), namespaces.iterator()));
    }

    @Override
    protected void endElementInternal(QName name, SimpleNamespaceContext namespaceContext) throws XMLStreamException {
        List<Namespace> namespaces = this.createNamespaces(namespaceContext);
        this.consumeEvent(this.eventFactory.createEndElement(name, namespaces.iterator()));
    }

    @Override
    protected void charactersInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createCharacters(new String(ch, start, length)));
    }

    @Override
    protected void ignorableWhitespaceInternal(char[] ch, int start, int length) throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createIgnorableSpace(new String(ch, start, length)));
    }

    @Override
    protected void processingInstructionInternal(String target, String data) throws XMLStreamException {
        this.consumeEvent(this.eventFactory.createProcessingInstruction(target, data));
    }

    private void consumeEvent(XMLEvent event) throws XMLStreamException {
        if (this.locator != null) {
            this.eventFactory.setLocation(new SaxLocation(this.locator));
        }
        this.eventConsumer.add(event);
    }

    private List<Namespace> createNamespaces(SimpleNamespaceContext namespaceContext) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        String defaultNamespaceUri = namespaceContext.getNamespaceURI("");
        if (defaultNamespaceUri != null && defaultNamespaceUri.length() > 0) {
            namespaces.add(this.eventFactory.createNamespace(defaultNamespaceUri));
        }
        Iterator<String> iterator = namespaceContext.getBoundPrefixes();
        while (iterator.hasNext()) {
            String prefix = iterator.next();
            String namespaceUri = namespaceContext.getNamespaceURI(prefix);
            namespaces.add(this.eventFactory.createNamespace(prefix, namespaceUri));
        }
        return namespaces;
    }

    private List<Attribute> getAttributes(Attributes attributes) {
        ArrayList<Attribute> list = new ArrayList<Attribute>();
        for (int i = 0; i < attributes.getLength(); ++i) {
            QName name = this.toQName(attributes.getURI(i), attributes.getQName(i));
            if ("xmlns".equals(name.getLocalPart()) || "xmlns".equals(name.getPrefix())) continue;
            list.add(this.eventFactory.createAttribute(name, attributes.getValue(i)));
        }
        return list;
    }

    @Override
    protected void skippedEntityInternal(String name) throws XMLStreamException {
    }

    private static class SaxLocation
    implements Location {
        private Locator locator;

        private SaxLocation(Locator locator) {
            this.locator = locator;
        }

        @Override
        public int getLineNumber() {
            return this.locator.getLineNumber();
        }

        @Override
        public int getColumnNumber() {
            return this.locator.getColumnNumber();
        }

        @Override
        public int getCharacterOffset() {
            return -1;
        }

        @Override
        public String getPublicId() {
            return this.locator.getPublicId();
        }

        @Override
        public String getSystemId() {
            return this.locator.getSystemId();
        }
    }
}

