/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.xml.util;

import java.util.regex.Pattern;

public final class XMLUtil {
    private static final Pattern invalidXml10 = Pattern.compile("[^\t\n\r -\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]");
    private static final Pattern invalidXml11 = Pattern.compile("[^\u0001-\ud7ff\ue000-\ufffd\ud800\udc00-\udbff\udfff]");

    private XMLUtil() {
    }

    public static CharSequence escape(CharSequence string) {
        StringBuilder sb = new StringBuilder();
        XMLUtil.escape(sb, string);
        return sb;
    }

    public static CharSequence escape(char[] chars, int start, int len) {
        StringBuilder sb = new StringBuilder();
        XMLUtil.escape(sb, chars, start, len);
        return sb;
    }

    public static void escape(StringBuilder sb, String string) {
        XMLUtil.escape(sb, string.toCharArray(), 0, string.length());
    }

    public static void escape(StringBuilder sb, CharSequence string) {
        block6: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static void escape(StringBuilder sb, char[] chars, int start, int len) {
        block6: for (int i = start; i < len; ++i) {
            char c = chars[i];
            switch (c) {
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static String unescape(String str) {
        int idxS = str.indexOf(38);
        if (idxS < 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(str.length());
        int prev = 0;
        while (idxS != -1) {
            int idxE;
            if (prev < idxS) {
                sb.append(str.substring(prev, idxS));
                prev = idxS;
            }
            if ((idxE = str.indexOf(59, idxS)) < 0) break;
            int idx = idxS + 1;
            int size = idxE - idxS - 1;
            if (size < 2) {
                sb.append(str.substring(idxS, idxE + 1));
            } else {
                char c = str.charAt(idx);
                switch (c) {
                    case 'l': {
                        if (XMLUtil.xmlDecodeLT(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'g': {
                        if (XMLUtil.xmlDecodeGT(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'q': {
                        if (XMLUtil.xmlDecodeQUOT(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'a': {
                        if (XMLUtil.xmlDecodeAMPAPOS(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case 'n': {
                        if (XMLUtil.xmlDecodeNBSP(str, idx, sb, size)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    case '#': {
                        if (XMLUtil.xmlDecodeNumber(str, idx, sb, idxE)) break;
                        sb.append("&");
                        idxE = idxS;
                        break;
                    }
                    default: {
                        sb.append("&");
                        idxE = idxS;
                    }
                }
            }
            prev = idxE + 1;
            idxS = str.indexOf(38, prev);
        }
        if (prev < str.length()) {
            sb.append(str.substring(prev));
        }
        return sb.toString();
    }

    private static boolean xmlDecodeLT(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c = str.charAt(idx + 1);
        if (size != 2 || c != 't') {
            isRecognized = false;
        } else {
            sb.append('<');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeGT(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c = str.charAt(idx + 1);
        if (size != 2 || c != 't') {
            isRecognized = false;
        } else {
            sb.append('>');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeQUOT(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c = str.charAt(idx + 1);
        if (size != 4 || c != 'u' || str.charAt(idx + 2) != 'o' || str.charAt(idx + 3) != 't') {
            isRecognized = false;
        } else {
            sb.append('\"');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeAMPAPOS(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c = str.charAt(idx + 1);
        if (size == 3 && c == 'm' && str.charAt(idx + 2) == 'p') {
            sb.append('&');
        } else if (size == 4 && c == 'p' && str.charAt(idx + 2) == 'o' && str.charAt(idx + 3) == 's') {
            sb.append('\'');
        } else {
            isRecognized = false;
        }
        return isRecognized;
    }

    private static boolean xmlDecodeNBSP(String str, int idx, StringBuilder sb, int size) {
        boolean isRecognized = true;
        char c = str.charAt(idx + 1);
        if (size != 4 || c != 'b' || str.charAt(idx + 2) != 's' || str.charAt(idx + 3) != 'p') {
            isRecognized = false;
        } else {
            sb.append(' ');
        }
        return isRecognized;
    }

    private static boolean xmlDecodeNumber(String str, int idx, StringBuilder sb, int idxE) {
        boolean isRecognized = true;
        try {
            char c1 = str.charAt(idx + 1);
            char c = c1 == 'x' ? (char)Integer.parseInt(str.substring(idx + 2, idxE), 16) : (char)Integer.parseInt(str.substring(idx + 1, idxE));
            sb.append(c);
        }
        catch (NumberFormatException ex) {
            isRecognized = false;
        }
        return isRecognized;
    }

    public static String sanitize(CharSequence string) {
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            boolean legal;
            char c = string.charAt(i);
            boolean bl = legal = c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
            if (!legal) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sanitizeToLineFeed(CharSequence string) {
        StringBuilder sb = new StringBuilder();
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            boolean legal;
            char c = string.charAt(i);
            boolean bl = legal = c == '\t' || c == '\n' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd';
            if (!legal) continue;
            sb.append(c);
        }
        return sb.toString();
    }

    public static String sanitizeXml10(CharSequence sequence) {
        if (sequence == null) {
            return null;
        }
        if (sequence.length() == 0) {
            return "";
        }
        return invalidXml10.matcher(sequence).replaceAll("\ufffd");
    }

    public static String sanitizeXml10(char[] sequence, int offset, int length) {
        return XMLUtil.sanitizeXml10(new String(sequence, offset, length));
    }

    public static String sanitizeXml11(CharSequence sequence) {
        if (sequence == null) {
            return null;
        }
        if (sequence.length() == 0) {
            return "";
        }
        return invalidXml11.matcher(sequence).replaceAll("\ufffd");
    }

    public static String sanitizeXml11(char[] sequence, int offset, int length) {
        return XMLUtil.sanitizeXml11(new String(sequence, offset, length));
    }

    public static boolean isNCName(CharSequence name) {
        int nameLength = name.length();
        if (nameLength == 0) {
            return false;
        }
        char c = name.charAt(0);
        if (c == '_' || XMLUtil.isLetter(c)) {
            for (int i = 1; i < nameLength; ++i) {
                c = name.charAt(i);
                if (XMLUtil.isNCNameChar(c)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isNCNameChar(char c) {
        return XMLUtil.isAsciiBaseChar(c) || XMLUtil.isAsciiDigit(c) || c == '.' || c == '-' || c == '_' || XMLUtil.isNonAsciiBaseChar(c) || XMLUtil.isNonAsciiDigit(c) || XMLUtil.isIdeographic(c) || XMLUtil.isCombiningChar(c) || XMLUtil.isExtender(c);
    }

    public static boolean isLetter(char c) {
        return XMLUtil.isAsciiBaseChar(c) || XMLUtil.isNonAsciiBaseChar(c) || XMLUtil.isIdeographic(c);
    }

    private static boolean isAsciiBaseChar(char c) {
        return XMLUtil.charInRange(c, 65, 90) || XMLUtil.charInRange(c, 97, 122);
    }

    private static boolean isNonAsciiBaseChar(char c) {
        return XMLUtil.charInRange(c, 192, 214) || XMLUtil.charInRange(c, 216, 246) || XMLUtil.charInRange(c, 248, 255) || XMLUtil.charInRange(c, 256, 305) || XMLUtil.charInRange(c, 308, 318) || XMLUtil.charInRange(c, 321, 328) || XMLUtil.charInRange(c, 330, 382) || XMLUtil.charInRange(c, 384, 451) || XMLUtil.charInRange(c, 461, 496) || XMLUtil.charInRange(c, 500, 501) || XMLUtil.charInRange(c, 506, 535) || XMLUtil.charInRange(c, 592, 680) || XMLUtil.charInRange(c, 699, 705) || c == '\u0386' || XMLUtil.charInRange(c, 904, 906) || c == '\u038c' || XMLUtil.charInRange(c, 910, 929) || XMLUtil.charInRange(c, 931, 974) || XMLUtil.charInRange(c, 976, 982) || c == '\u03da' || c == '\u03dc' || c == '\u03de' || c == '\u03e0' || XMLUtil.charInRange(c, 994, 1011) || XMLUtil.charInRange(c, 1025, 1036) || XMLUtil.charInRange(c, 1038, 1103) || XMLUtil.charInRange(c, 1105, 1116) || XMLUtil.charInRange(c, 1118, 1153) || XMLUtil.charInRange(c, 1168, 1220) || XMLUtil.charInRange(c, 1223, 1224) || XMLUtil.charInRange(c, 1227, 1228) || XMLUtil.charInRange(c, 1232, 1259) || XMLUtil.charInRange(c, 1262, 1269) || XMLUtil.charInRange(c, 1272, 1273) || XMLUtil.charInRange(c, 1329, 1366) || c == '\u0559' || XMLUtil.charInRange(c, 1377, 1414) || XMLUtil.charInRange(c, 1488, 1514) || XMLUtil.charInRange(c, 1520, 1522) || XMLUtil.charInRange(c, 1569, 1594) || XMLUtil.charInRange(c, 1601, 1610) || XMLUtil.charInRange(c, 1649, 1719) || XMLUtil.charInRange(c, 1722, 1726) || XMLUtil.charInRange(c, 1728, 1742) || XMLUtil.charInRange(c, 1744, 1747) || c == '\u06d5' || XMLUtil.charInRange(c, 1765, 1766) || XMLUtil.charInRange(c, 2309, 2361) || c == '\u093d' || XMLUtil.charInRange(c, 2392, 2401) || XMLUtil.charInRange(c, 2437, 2444) || XMLUtil.charInRange(c, 2447, 2448) || XMLUtil.charInRange(c, 2451, 2472) || XMLUtil.charInRange(c, 2474, 2480) || c == '\u09b2' || XMLUtil.charInRange(c, 2486, 2489) || XMLUtil.charInRange(c, 2524, 2525) || XMLUtil.charInRange(c, 2527, 2529) || XMLUtil.charInRange(c, 2544, 2545) || XMLUtil.charInRange(c, 2565, 2570) || XMLUtil.charInRange(c, 2575, 2576) || XMLUtil.charInRange(c, 2579, 2600) || XMLUtil.charInRange(c, 2602, 2608) || XMLUtil.charInRange(c, 2610, 2611) || XMLUtil.charInRange(c, 2613, 2614) || XMLUtil.charInRange(c, 2616, 2617) || XMLUtil.charInRange(c, 2649, 2652) || c == '\u0a5e' || XMLUtil.charInRange(c, 2674, 2676) || XMLUtil.charInRange(c, 2693, 2699) || c == '\u0a8d' || XMLUtil.charInRange(c, 2703, 2705) || XMLUtil.charInRange(c, 2707, 2728) || XMLUtil.charInRange(c, 2730, 2736) || XMLUtil.charInRange(c, 2738, 2739) || XMLUtil.charInRange(c, 2741, 2745) || c == '\u0abd' || c == '\u0ae0' || XMLUtil.charInRange(c, 2821, 2828) || XMLUtil.charInRange(c, 2831, 2832) || XMLUtil.charInRange(c, 2835, 2856) || XMLUtil.charInRange(c, 2858, 2864) || XMLUtil.charInRange(c, 2866, 2867) || XMLUtil.charInRange(c, 2870, 2873) || c == '\u0b3d' || XMLUtil.charInRange(c, 2908, 2909) || XMLUtil.charInRange(c, 2911, 2913) || XMLUtil.charInRange(c, 2949, 2954) || XMLUtil.charInRange(c, 2958, 2960) || XMLUtil.charInRange(c, 2962, 2965) || XMLUtil.charInRange(c, 2969, 2970) || c == '\u0b9c' || XMLUtil.charInRange(c, 2974, 2975) || XMLUtil.charInRange(c, 2979, 2980) || XMLUtil.charInRange(c, 2984, 2986) || XMLUtil.charInRange(c, 2990, 2997) || XMLUtil.charInRange(c, 2999, 3001) || XMLUtil.charInRange(c, 3077, 3084) || XMLUtil.charInRange(c, 3086, 3088) || XMLUtil.charInRange(c, 3090, 3112) || XMLUtil.charInRange(c, 3114, 3123) || XMLUtil.charInRange(c, 3125, 3129) || XMLUtil.charInRange(c, 3168, 3169) || XMLUtil.charInRange(c, 3205, 3212) || XMLUtil.charInRange(c, 3214, 3216) || XMLUtil.charInRange(c, 3218, 3240) || XMLUtil.charInRange(c, 3242, 3251) || XMLUtil.charInRange(c, 3253, 3257) || c == '\u0cde' || XMLUtil.charInRange(c, 3296, 3297) || XMLUtil.charInRange(c, 3333, 3340) || XMLUtil.charInRange(c, 3342, 3344) || XMLUtil.charInRange(c, 3346, 3368) || XMLUtil.charInRange(c, 3370, 3385) || XMLUtil.charInRange(c, 3424, 3425) || XMLUtil.charInRange(c, 3585, 3630) || c == '\u0e30' || XMLUtil.charInRange(c, 3634, 3635) || XMLUtil.charInRange(c, 3648, 3653) || XMLUtil.charInRange(c, 3713, 3714) || c == '\u0e84' || XMLUtil.charInRange(c, 3719, 3720) || c == '\u0e8a' || c == '\u0e8d' || XMLUtil.charInRange(c, 3732, 3735) || XMLUtil.charInRange(c, 3737, 3743) || XMLUtil.charInRange(c, 3745, 3747) || c == '\u0ea5' || c == '\u0ea7' || XMLUtil.charInRange(c, 3754, 3755) || XMLUtil.charInRange(c, 3757, 3758) || c == '\u0eb0' || XMLUtil.charInRange(c, 3762, 3763) || c == '\u0ebd' || XMLUtil.charInRange(c, 3776, 3780) || XMLUtil.charInRange(c, 3904, 3911) || XMLUtil.charInRange(c, 3913, 3945) || XMLUtil.charInRange(c, 4256, 4293) || XMLUtil.charInRange(c, 4304, 4342) || c == '\u1100' || XMLUtil.charInRange(c, 4354, 4355) || XMLUtil.charInRange(c, 4357, 4359) || c == '\u1109' || XMLUtil.charInRange(c, 4363, 4364) || XMLUtil.charInRange(c, 4366, 4370) || c == '\u113c' || c == '\u113e' || c == '\u1140' || c == '\u114c' || c == '\u114e' || c == '\u1150' || XMLUtil.charInRange(c, 4436, 4437) || c == '\u1159' || XMLUtil.charInRange(c, 4447, 4449) || c == '\u1163' || c == '\u1165' || c == '\u1167' || c == '\u1169' || XMLUtil.charInRange(c, 4461, 4462) || XMLUtil.charInRange(c, 4466, 4467) || c == '\u1175' || c == '\u119e' || c == '\u11a8' || c == '\u11ab' || XMLUtil.charInRange(c, 4526, 4527) || XMLUtil.charInRange(c, 4535, 4536) || c == '\u11ba' || XMLUtil.charInRange(c, 4540, 4546) || c == '\u11eb' || c == '\u11f0' || c == '\u11f9' || XMLUtil.charInRange(c, 7680, 7835) || XMLUtil.charInRange(c, 7840, 7929) || XMLUtil.charInRange(c, 7936, 7957) || XMLUtil.charInRange(c, 7960, 7965) || XMLUtil.charInRange(c, 7968, 8005) || XMLUtil.charInRange(c, 8008, 8013) || XMLUtil.charInRange(c, 8016, 8023) || c == '\u1f59' || c == '\u1f5b' || c == '\u1f5d' || XMLUtil.charInRange(c, 8031, 8061) || XMLUtil.charInRange(c, 8064, 8116) || XMLUtil.charInRange(c, 8118, 8124) || c == '\u1fbe' || XMLUtil.charInRange(c, 8130, 8132) || XMLUtil.charInRange(c, 8134, 8140) || XMLUtil.charInRange(c, 8144, 8147) || XMLUtil.charInRange(c, 8150, 8155) || XMLUtil.charInRange(c, 8160, 8172) || XMLUtil.charInRange(c, 8178, 8180) || XMLUtil.charInRange(c, 8182, 8188) || c == '\u2126' || XMLUtil.charInRange(c, 8490, 8491) || c == '\u212e' || XMLUtil.charInRange(c, 8576, 8578) || XMLUtil.charInRange(c, 12353, 12436) || XMLUtil.charInRange(c, 12449, 12538) || XMLUtil.charInRange(c, 12549, 12588) || XMLUtil.charInRange(c, 44032, 55203);
    }

    public static boolean isIdeographic(char c) {
        return XMLUtil.charInRange(c, 19968, 40869) || c == '\u3007' || XMLUtil.charInRange(c, 12321, 12329);
    }

    public static boolean isCombiningChar(char c) {
        return XMLUtil.charInRange(c, 768, 837) || XMLUtil.charInRange(c, 864, 865) || XMLUtil.charInRange(c, 1155, 1158) || XMLUtil.charInRange(c, 1425, 1441) || XMLUtil.charInRange(c, 1443, 1465) || XMLUtil.charInRange(c, 1467, 1469) || c == '\u05bf' || XMLUtil.charInRange(c, 1473, 1474) || c == '\u05c4' || XMLUtil.charInRange(c, 1611, 1618) || c == '\u0670' || XMLUtil.charInRange(c, 1750, 1756) || XMLUtil.charInRange(c, 1757, 1759) || XMLUtil.charInRange(c, 1760, 1764) || XMLUtil.charInRange(c, 1767, 1768) || XMLUtil.charInRange(c, 1770, 1773) || XMLUtil.charInRange(c, 2305, 2307) || c == '\u093c' || XMLUtil.charInRange(c, 2366, 2380) || c == '\u094d' || XMLUtil.charInRange(c, 2385, 2388) || XMLUtil.charInRange(c, 2402, 2403) || XMLUtil.charInRange(c, 2433, 2435) || c == '\u09bc' || c == '\u09be' || c == '\u09bf' || XMLUtil.charInRange(c, 2496, 2500) || XMLUtil.charInRange(c, 2503, 2504) || XMLUtil.charInRange(c, 2507, 2509) || c == '\u09d7' || XMLUtil.charInRange(c, 2530, 2531) || c == '\u0a02' || c == '\u0a3c' || c == '\u0a3e' || c == '\u0a3f' || XMLUtil.charInRange(c, 2624, 2626) || XMLUtil.charInRange(c, 2631, 2632) || XMLUtil.charInRange(c, 2635, 2637) || XMLUtil.charInRange(c, 2672, 2673) || XMLUtil.charInRange(c, 2689, 2691) || c == '\u0abc' || XMLUtil.charInRange(c, 2750, 2757) || XMLUtil.charInRange(c, 2759, 2761) || XMLUtil.charInRange(c, 2763, 2765) || XMLUtil.charInRange(c, 2817, 2819) || c == '\u0b3c' || XMLUtil.charInRange(c, 2878, 2883) || XMLUtil.charInRange(c, 2887, 2888) || XMLUtil.charInRange(c, 2891, 2893) || XMLUtil.charInRange(c, 2902, 2903) || XMLUtil.charInRange(c, 2946, 2947) || XMLUtil.charInRange(c, 3006, 3010) || XMLUtil.charInRange(c, 3014, 3016) || XMLUtil.charInRange(c, 3018, 3021) || c == '\u0bd7' || XMLUtil.charInRange(c, 3073, 3075) || XMLUtil.charInRange(c, 3134, 3140) || XMLUtil.charInRange(c, 3142, 3144) || XMLUtil.charInRange(c, 3146, 3149) || XMLUtil.charInRange(c, 3157, 3158) || XMLUtil.charInRange(c, 3202, 3203) || XMLUtil.charInRange(c, 3262, 3268) || XMLUtil.charInRange(c, 3270, 3272) || XMLUtil.charInRange(c, 3274, 3277) || XMLUtil.charInRange(c, 3285, 3286) || XMLUtil.charInRange(c, 3330, 3331) || XMLUtil.charInRange(c, 3390, 3395) || XMLUtil.charInRange(c, 3398, 3400) || XMLUtil.charInRange(c, 3402, 3405) || c == '\u0d57' || c == '\u0e31' || XMLUtil.charInRange(c, 3636, 3642) || XMLUtil.charInRange(c, 3655, 3662) || c == '\u0eb1' || XMLUtil.charInRange(c, 3764, 3769) || XMLUtil.charInRange(c, 3771, 3772) || XMLUtil.charInRange(c, 3784, 3789) || XMLUtil.charInRange(c, 3864, 3865) || c == '\u0f35' || c == '\u0f37' || c == '\u0f39' || c == '\u0f3e' || c == '\u0f3f' || XMLUtil.charInRange(c, 3953, 3972) || XMLUtil.charInRange(c, 3974, 3979) || XMLUtil.charInRange(c, 3984, 3989) || c == '\u0f97' || XMLUtil.charInRange(c, 3993, 4013) || XMLUtil.charInRange(c, 4017, 4023) || c == '\u0fb9' || XMLUtil.charInRange(c, 8400, 8412) || c == '\u20e1' || XMLUtil.charInRange(c, 12330, 12335) || c == '\u3099' || c == '\u309a';
    }

    public static boolean isDigit(char c) {
        return XMLUtil.isAsciiDigit(c) || XMLUtil.isNonAsciiDigit(c);
    }

    private static boolean isAsciiDigit(char c) {
        return XMLUtil.charInRange(c, 48, 57);
    }

    private static boolean isNonAsciiDigit(char c) {
        return XMLUtil.charInRange(c, 1632, 1641) || XMLUtil.charInRange(c, 1776, 1785) || XMLUtil.charInRange(c, 2406, 2415) || XMLUtil.charInRange(c, 2534, 2543) || XMLUtil.charInRange(c, 2662, 2671) || XMLUtil.charInRange(c, 2790, 2799) || XMLUtil.charInRange(c, 2918, 2927) || XMLUtil.charInRange(c, 3047, 3055) || XMLUtil.charInRange(c, 3174, 3183) || XMLUtil.charInRange(c, 3302, 3311) || XMLUtil.charInRange(c, 3430, 3439) || XMLUtil.charInRange(c, 3664, 3673) || XMLUtil.charInRange(c, 3792, 3801) || XMLUtil.charInRange(c, 3872, 3881);
    }

    public static boolean isExtender(char c) {
        return c == '\u00b7' || c == '\u02d0' || c == '\u02d1' || c == '\u0387' || c == '\u0640' || c == '\u0e46' || c == '\u0ec6' || c == '\u3005' || XMLUtil.charInRange(c, 12337, 12341) || XMLUtil.charInRange(c, 12445, 12446) || XMLUtil.charInRange(c, 12540, 12542);
    }

    private static boolean charInRange(char c, int start, int end) {
        return c >= start && c <= end;
    }
}

