/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.yaml;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.XContentGenerator;
import org.xbib.content.XContentParser;
import org.xbib.content.io.BytesReference;
import org.xbib.content.yaml.YamlXContentGenerator;
import org.xbib.content.yaml.YamlXContentParser;

public class YamlXContent
implements XContent {
    private static final YamlXContent yamlXContent;
    private static final YAMLFactory yamlFactory;

    public static YamlXContent yamlContent() {
        return yamlXContent;
    }

    public static YAMLFactory yamlFactory() {
        return yamlFactory;
    }

    public static XContentBuilder contentBuilder() throws IOException {
        return XContentBuilder.builder((XContent)yamlXContent);
    }

    public static XContentBuilder contentBuilder(OutputStream outputStream) throws IOException {
        return XContentBuilder.builder((XContent)yamlXContent, (OutputStream)outputStream);
    }

    public String name() {
        return "yaml";
    }

    public XContentGenerator createGenerator(OutputStream os) throws IOException {
        return new YamlXContentGenerator((JsonGenerator)yamlFactory.createGenerator(os, JsonEncoding.UTF8));
    }

    public XContentGenerator createGenerator(Writer writer) throws IOException {
        return new YamlXContentGenerator((JsonGenerator)yamlFactory.createGenerator(writer));
    }

    public XContentParser createParser(String content) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(content.getBytes(StandardCharsets.UTF_8)));
    }

    public XContentParser createParser(InputStream is) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(is));
    }

    public XContentParser createParser(byte[] data) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(data));
    }

    public XContentParser createParser(byte[] data, int offset, int length) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(data, offset, length));
    }

    public XContentParser createParser(BytesReference bytes) throws IOException {
        return this.createParser((InputStream)bytes.streamInput());
    }

    public XContentParser createParser(Reader reader) throws IOException {
        return new YamlXContentParser((JsonParser)yamlFactory.createParser(reader));
    }

    public boolean isXContent(BytesReference bytes) {
        int length;
        int n = length = bytes.length() < 20 ? bytes.length() : 20;
        if (length == 0) {
            return false;
        }
        byte first = bytes.get(0);
        return length > 2 && first == 45 && bytes.get(1) == 45 && bytes.get(2) == 45;
    }

    static {
        yamlFactory = new YAMLFactory();
        yamlXContent = new YamlXContent();
    }
}

