/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.yaml;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.xbib.content.XContent;
import org.xbib.content.io.BytesReference;
import org.xbib.content.json.JsonXContentGenerator;
import org.xbib.content.yaml.YamlXContent;

public class YamlXContentGenerator
extends JsonXContentGenerator {
    public YamlXContentGenerator(JsonGenerator generator) {
        super(generator);
    }

    public XContent content() {
        return YamlXContent.yamlContent();
    }

    public void writeRawField(String fieldName, byte[] content, OutputStream outputStream) throws IOException {
        this.writeFieldName(fieldName);
        try (YAMLParser parser = YamlXContent.yamlFactory().createParser(content);){
            parser.nextToken();
            YamlXContent.yamlFactory().createGenerator(outputStream).copyCurrentStructure((JsonParser)parser);
        }
    }

    public void writeRawField(String fieldName, BytesReference content, OutputStream outputStream) throws IOException {
        this.writeFieldName(fieldName);
        try (YAMLParser parser = YamlXContent.yamlFactory().createParser((InputStream)content.streamInput());){
            parser.nextToken();
            YamlXContent.yamlFactory().createGenerator(outputStream).copyCurrentStructure((JsonParser)parser);
        }
    }

    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream outputStream) throws IOException {
        this.writeFieldName(fieldName);
        try (YAMLParser parser = YamlXContent.yamlFactory().createParser(content, offset, length);){
            parser.nextToken();
            YamlXContent.yamlFactory().createGenerator(outputStream).copyCurrentStructure((JsonParser)parser);
        }
    }
}

