/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.content.yaml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.fasterxml.jackson.dataformat.yaml.YAMLParser;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.xbib.content.XContent;
import org.xbib.content.XContentBuilder;
import org.xbib.content.XContentGenerator;
import org.xbib.content.XContentParser;
import org.xbib.content.core.AbstractXContentGenerator;
import org.xbib.content.core.DefaultXContentBuilder;
import org.xbib.content.core.XContentHelper;
import org.xbib.content.io.BytesReference;
import org.xbib.content.yaml.YamlXContent;

public class YamlXContentGenerator
extends AbstractXContentGenerator {
    private final YAMLGeneratorDelegate delegate;

    public YamlXContentGenerator(YAMLGenerator generator) {
        this.delegate = new YAMLGeneratorDelegate(generator);
        super.setGenerator((XContentGenerator)this.delegate);
    }

    public XContent content() {
        return this.delegate.content();
    }

    public void usePrettyPrint() {
        this.delegate.usePrettyPrint();
    }

    public void writeRawField(String fieldName, byte[] content, OutputStream outputStream) throws IOException {
        this.writeFieldName(fieldName);
        try (YAMLParser parser = YamlXContent.yamlFactory().createParser(content);){
            parser.nextToken();
            YamlXContent.yamlFactory().createGenerator(outputStream).copyCurrentStructure((JsonParser)parser);
        }
    }

    public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream outputStream) throws IOException {
        this.writeFieldName(fieldName);
        try (YAMLParser parser = YamlXContent.yamlFactory().createParser(content, offset, length);){
            parser.nextToken();
            YamlXContent.yamlFactory().createGenerator(outputStream).copyCurrentStructure((JsonParser)parser);
        }
    }

    public void writeValue(XContentBuilder builder) throws IOException {
        this.delegate.writeValue(builder);
    }

    public void copyCurrentStructure(XContentParser parser) throws IOException {
        this.delegate.copyCurrentStructure(parser);
    }

    public void copy(XContentBuilder builder, OutputStream outputStream) throws IOException {
        this.flush();
        if (builder instanceof DefaultXContentBuilder) {
            DefaultXContentBuilder xContentBuilder = (DefaultXContentBuilder)builder;
            xContentBuilder.bytes().streamOutput(outputStream);
        }
    }

    public void flush() throws IOException {
        this.delegate.flush();
    }

    public void close() throws IOException {
        this.delegate.close();
    }

    private static class YAMLGeneratorDelegate
    implements XContentGenerator {
        final YAMLGenerator yamlGenerator;

        YAMLGeneratorDelegate(YAMLGenerator yamlGenerator) {
            this.yamlGenerator = yamlGenerator;
        }

        public XContent content() {
            return YamlXContent.yamlContent();
        }

        public void usePrettyPrint() {
            this.yamlGenerator.useDefaultPrettyPrinter();
        }

        public void writeStartArray() throws IOException {
            this.yamlGenerator.writeStartArray();
        }

        public void writeEndArray() throws IOException {
            this.yamlGenerator.writeEndArray();
        }

        public void writeStartObject() throws IOException {
            this.yamlGenerator.writeStartObject();
        }

        public void writeEndObject() throws IOException {
            this.yamlGenerator.writeEndObject();
        }

        public void writeFieldName(String name) throws IOException {
            this.yamlGenerator.writeFieldName(name);
        }

        public void writeString(String text) throws IOException {
            this.yamlGenerator.writeString(text);
        }

        public void writeString(char[] text, int offset, int len) throws IOException {
            this.yamlGenerator.writeString(text, offset, len);
        }

        public void writeUTF8String(byte[] text, int offset, int length) throws IOException {
            this.yamlGenerator.writeUTF8String(text, offset, length);
        }

        public void writeBinary(byte[] data, int offset, int len) throws IOException {
            this.yamlGenerator.writeBinary(data, offset, len);
        }

        public void writeBinary(byte[] data) throws IOException {
            this.yamlGenerator.writeBinary(data);
        }

        public void writeNumber(int v) throws IOException {
            this.yamlGenerator.writeNumber(v);
        }

        public void writeNumber(long v) throws IOException {
            this.yamlGenerator.writeNumber(v);
        }

        public void writeNumber(double d) throws IOException {
            this.yamlGenerator.writeNumber(d);
        }

        public void writeNumber(float f) throws IOException {
            this.yamlGenerator.writeNumber(f);
        }

        public void writeNumber(BigInteger bi) throws IOException {
            this.yamlGenerator.writeNumber(bi);
        }

        public void writeNumber(BigDecimal bd) throws IOException {
            this.yamlGenerator.writeNumber(bd);
        }

        public void writeBoolean(boolean b) throws IOException {
            this.yamlGenerator.writeBoolean(b);
        }

        public void writeNull() throws IOException {
            this.yamlGenerator.writeNull();
        }

        public void writeStringField(String fieldName, String value) throws IOException {
            this.yamlGenerator.writeStringField(fieldName, value);
        }

        public void writeBooleanField(String fieldName, boolean value) throws IOException {
            this.yamlGenerator.writeBooleanField(fieldName, value);
        }

        public void writeNullField(String fieldName) throws IOException {
            this.yamlGenerator.writeNullField(fieldName);
        }

        public void writeNumberField(String fieldName, int value) throws IOException {
            this.yamlGenerator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(String fieldName, long value) throws IOException {
            this.yamlGenerator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(String fieldName, double value) throws IOException {
            this.yamlGenerator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(String fieldName, float value) throws IOException {
            this.yamlGenerator.writeNumberField(fieldName, value);
        }

        public void writeNumberField(String fieldName, BigInteger value) throws IOException {
            this.yamlGenerator.writeFieldName(fieldName);
            this.yamlGenerator.writeNumber(value);
        }

        public void writeNumberField(String fieldName, BigDecimal value) throws IOException {
            this.yamlGenerator.writeNumberField(fieldName, value);
        }

        public void writeBinaryField(String fieldName, byte[] data) throws IOException {
            this.yamlGenerator.writeBinaryField(fieldName, data);
        }

        public void writeArrayFieldStart(String fieldName) throws IOException {
            this.yamlGenerator.writeArrayFieldStart(fieldName);
        }

        public void writeObjectFieldStart(String fieldName) throws IOException {
            this.yamlGenerator.writeObjectFieldStart(fieldName);
        }

        public void writeRawField(String fieldName, byte[] content, OutputStream outputStream) throws IOException {
            this.yamlGenerator.writeRaw(",\"");
            this.yamlGenerator.writeRaw(fieldName);
            this.yamlGenerator.writeRaw("\":");
            this.flush();
            outputStream.write(content);
        }

        public void writeRawField(String fieldName, byte[] content, int offset, int length, OutputStream outputStream) throws IOException {
            this.yamlGenerator.writeRaw(",\"");
            this.yamlGenerator.writeRaw(fieldName);
            this.yamlGenerator.writeRaw("\":");
            this.flush();
            outputStream.write(content, offset, length);
        }

        public void writeRawField(String fieldName, BytesReference content, OutputStream outputStream) throws IOException {
            this.yamlGenerator.writeRaw(",\"");
            this.yamlGenerator.writeRaw(fieldName);
            this.yamlGenerator.writeRaw("\":");
            this.flush();
            content.streamOutput(outputStream);
        }

        public void writeValue(XContentBuilder builder) throws IOException {
            this.yamlGenerator.writeRawValue(builder.string());
        }

        public void copy(XContentBuilder builder, OutputStream outputStream) throws IOException {
            this.flush();
            if (builder instanceof DefaultXContentBuilder) {
                DefaultXContentBuilder xContentBuilder = (DefaultXContentBuilder)builder;
                xContentBuilder.bytes().streamOutput(outputStream);
            }
        }

        public void copyCurrentStructure(XContentParser parser) throws IOException {
            if (parser.currentToken() == null) {
                parser.nextToken();
            }
            XContentHelper.copyCurrentStructure((XContentGenerator)this, (XContentParser)parser);
        }

        public void flush() throws IOException {
            this.yamlGenerator.flush();
        }

        public void close() throws IOException {
            if (this.yamlGenerator.isClosed()) {
                return;
            }
            this.yamlGenerator.close();
        }
    }
}

