/*
 * Decompiled with CFR 0.152.
 */
package org.xbib.elx.transport;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.Version;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionModule;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.TransportActionNodeProxy;
import org.elasticsearch.action.admin.cluster.node.liveness.LivenessRequest;
import org.elasticsearch.action.admin.cluster.node.liveness.LivenessResponse;
import org.elasticsearch.cache.recycler.PageCacheRecycler;
import org.elasticsearch.client.support.AbstractClient;
import org.elasticsearch.client.support.Headers;
import org.elasticsearch.client.transport.ClientTransportModule;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterNameModule;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Injector;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.inject.ModulesBuilder;
import org.elasticsearch.common.network.NetworkModule;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsModule;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.indices.breaker.CircuitBreakerModule;
import org.elasticsearch.node.internal.InternalSettingsPreparer;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.plugins.PluginsModule;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.search.SearchModule;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.threadpool.ThreadPoolModule;
import org.elasticsearch.transport.FutureTransportResponseHandler;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportModule;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportClient
extends AbstractClient {
    private static final String CLIENT_TYPE = "transport";
    private final Injector injector;
    private final ProxyActionMap proxyActionMap;
    private final long pingTimeout;
    private final ClusterName clusterName;
    private final TransportService transportService;
    private final Version minCompatibilityVersion;
    private final Headers headers;
    private final AtomicInteger tempNodeId = new AtomicInteger();
    private final AtomicInteger nodeCounter = new AtomicInteger();
    private final Object mutex = new Object();
    private volatile List<DiscoveryNode> listedNodes = Collections.emptyList();
    private volatile List<DiscoveryNode> nodes = Collections.emptyList();
    private volatile List<DiscoveryNode> filteredNodes = Collections.emptyList();
    private volatile boolean closed;

    private TransportClient(Injector injector) {
        super((Settings)injector.getInstance(Settings.class), (ThreadPool)injector.getInstance(ThreadPool.class), (Headers)injector.getInstance(Headers.class));
        this.injector = injector;
        this.clusterName = (ClusterName)injector.getInstance(ClusterName.class);
        this.transportService = (TransportService)injector.getInstance(TransportService.class);
        this.minCompatibilityVersion = ((Version)injector.getInstance(Version.class)).minimumCompatibilityVersion();
        this.headers = (Headers)injector.getInstance(Headers.class);
        this.pingTimeout = this.settings.getAsTime("client.transport.ping_timeout", TimeValue.timeValueSeconds((long)5L)).millis();
        this.proxyActionMap = (ProxyActionMap)injector.getInstance(ProxyActionMap.class);
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<TransportAddress> transportAddresses() {
        ArrayList<TransportAddress> lstBuilder = new ArrayList<TransportAddress>();
        for (DiscoveryNode listedNode : this.listedNodes) {
            lstBuilder.add(listedNode.address());
        }
        return Collections.unmodifiableList(lstBuilder);
    }

    public List<DiscoveryNode> connectedNodes() {
        return this.nodes;
    }

    public List<DiscoveryNode> filteredNodes() {
        return this.filteredNodes;
    }

    public List<DiscoveryNode> listedNodes() {
        return this.listedNodes;
    }

    public TransportClient addDiscoveryNodes(DiscoveryNodes discoveryNodes) {
        ArrayList<InetSocketTransportAddress> addresses = new ArrayList<InetSocketTransportAddress>();
        for (DiscoveryNode discoveryNode : discoveryNodes) {
            addresses.add((InetSocketTransportAddress)discoveryNode.address());
        }
        this.addTransportAddresses(addresses);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient addTransportAddresses(Collection<InetSocketTransportAddress> transportAddresses) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("transport client is closed, can't add addresses");
            }
            ArrayList<TransportAddress> filtered = new ArrayList<TransportAddress>(transportAddresses.size());
            for (TransportAddress transportAddress : transportAddresses) {
                boolean found = false;
                for (DiscoveryNode otherNode : this.listedNodes) {
                    if (!otherNode.address().equals(transportAddress)) continue;
                    found = true;
                    this.logger.debug("address [{}] already exists with [{}], ignoring...", new Object[]{transportAddress, otherNode});
                    break;
                }
                if (found) continue;
                filtered.add(transportAddress);
            }
            if (filtered.isEmpty()) {
                return this;
            }
            ArrayList<DiscoveryNode> discoveryNodeList = new ArrayList<DiscoveryNode>();
            discoveryNodeList.addAll(this.listedNodes());
            for (TransportAddress transportAddress : filtered) {
                DiscoveryNode node = new DiscoveryNode("#transport#-" + this.tempNodeId.incrementAndGet(), transportAddress, this.minCompatibilityVersion);
                this.logger.debug("adding address [{}]", new Object[]{node});
                discoveryNodeList.add(node);
            }
            this.listedNodes = Collections.unmodifiableList(discoveryNodeList);
            this.connect();
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransportClient removeTransportAddress(TransportAddress transportAddress) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.closed) {
                throw new IllegalStateException("transport client is closed, can't remove an address");
            }
            ArrayList<DiscoveryNode> builder = new ArrayList<DiscoveryNode>();
            for (DiscoveryNode otherNode : this.listedNodes) {
                if (!otherNode.address().equals(transportAddress)) {
                    builder.add(otherNode);
                    continue;
                }
                this.logger.debug("removing address [{}]", new Object[]{otherNode});
            }
            this.listedNodes = Collections.unmodifiableList(builder);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            for (DiscoveryNode node : this.nodes) {
                this.transportService.disconnectFromNode(node);
            }
            for (DiscoveryNode listedNode : this.listedNodes) {
                this.transportService.disconnectFromNode(listedNode);
            }
            this.nodes = Collections.emptyList();
        }
        ((TransportService)this.injector.getInstance(TransportService.class)).close();
        for (Class plugin : ((PluginsService)this.injector.getInstance(PluginsService.class)).nodeServices()) {
            ((LifecycleComponent)this.injector.getInstance(plugin)).close();
        }
        try {
            ThreadPool.terminate((ThreadPool)((ThreadPool)this.injector.getInstance(ThreadPool.class)), (long)10L, (TimeUnit)TimeUnit.SECONDS);
        }
        catch (Exception e) {
            this.logger.debug(e.getMessage(), (Throwable)e, new Object[0]);
        }
        ((PageCacheRecycler)this.injector.getInstance(PageCacheRecycler.class)).close();
    }

    private void connect() {
        HashSet<DiscoveryNode> newNodes = new HashSet<DiscoveryNode>();
        HashSet<DiscoveryNode> newFilteredNodes = new HashSet<DiscoveryNode>();
        for (DiscoveryNode listedNode : this.listedNodes) {
            if (!this.transportService.nodeConnected(listedNode)) {
                try {
                    this.logger.trace("connecting to listed node (light) [{}]", new Object[]{listedNode});
                    this.transportService.connectToNodeLight(listedNode);
                }
                catch (Exception e) {
                    this.logger.debug("failed to connect to node [{}], removed from nodes list", (Throwable)e, new Object[]{listedNode});
                    continue;
                }
            }
            try {
                LivenessResponseHandler responseHandler = new LivenessResponseHandler();
                LivenessResponse livenessResponse = (LivenessResponse)this.transportService.submitRequest(listedNode, "cluster:monitor/nodes/liveness", (TransportRequest)this.headers.applyTo((TransportMessage)new LivenessRequest()), TransportRequestOptions.builder().withType(TransportRequestOptions.Type.STATE).withTimeout(this.pingTimeout).build(), (TransportResponseHandler)responseHandler).txGet();
                if (!this.clusterName.equals((Object)livenessResponse.getClusterName())) {
                    this.logger.warn("node {} not part of the cluster {}, ignoring...", new Object[]{listedNode, this.clusterName});
                    newFilteredNodes.add(listedNode);
                    continue;
                }
                if (livenessResponse.getDiscoveryNode() != null) {
                    DiscoveryNode nodeWithInfo = livenessResponse.getDiscoveryNode();
                    newNodes.add(new DiscoveryNode(nodeWithInfo.name(), nodeWithInfo.id(), nodeWithInfo.getHostName(), nodeWithInfo.getHostAddress(), listedNode.address(), (Map)nodeWithInfo.attributes(), nodeWithInfo.version()));
                    continue;
                }
                this.logger.debug("node {} didn't return any discovery info, temporarily using transport discovery node", new Object[]{listedNode});
                newNodes.add(listedNode);
            }
            catch (Exception e) {
                this.logger.info("failed to get node info for {}, disconnecting...", (Throwable)e, new Object[]{listedNode});
                this.transportService.disconnectFromNode(listedNode);
            }
        }
        Iterator it = newNodes.iterator();
        while (it.hasNext()) {
            DiscoveryNode node = (DiscoveryNode)it.next();
            if (this.transportService.nodeConnected(node)) continue;
            try {
                this.logger.trace("connecting to node [{}]", new Object[]{node});
                this.transportService.connectToNode(node);
            }
            catch (Exception e) {
                it.remove();
                if (!this.logger.isDebugEnabled()) continue;
                this.logger.debug("failed to connect to discovered node [" + node + "]", (Throwable)e, new Object[0]);
            }
        }
        this.nodes = Collections.unmodifiableList(new ArrayList(newNodes));
        this.filteredNodes = Collections.unmodifiableList(new ArrayList(newFilteredNodes));
    }

    protected <R extends ActionRequest, S extends ActionResponse, T extends ActionRequestBuilder<R, S, T>> void doExecute(Action<R, S, T> action, R request, ActionListener<S> listener) {
        TransportActionNodeProxy proxyAction = this.proxyActionMap.getProxies().get(action);
        if (proxyAction == null) {
            throw new IllegalStateException("undefined action " + action);
        }
        List<DiscoveryNode> nodeList = this.nodes;
        if (nodeList.isEmpty()) {
            throw new NoNodeAvailableException("none of the configured nodes are available: " + this.listedNodes);
        }
        int index = this.nodeCounter.incrementAndGet();
        if (index < 0) {
            index = 0;
            this.nodeCounter.set(0);
        }
        try {
            proxyAction.execute(nodeList.get(index % nodeList.size()), request, listener);
        }
        catch (Exception e) {
            listener.onFailure((Throwable)e);
        }
    }

    private static class TransportSearchModule
    extends SearchModule {
        private TransportSearchModule() {
        }

        protected void configure() {
        }
    }

    private static class LivenessResponseHandler
    extends FutureTransportResponseHandler<LivenessResponse> {
        private LivenessResponseHandler() {
        }

        public LivenessResponse newInstance() {
            return new LivenessResponse();
        }
    }

    public static class ProxyActionMap {
        private final Map<Action, TransportActionNodeProxy> proxies = new LinkedHashMap<Action, TransportActionNodeProxy>();

        @Inject
        public ProxyActionMap(Settings settings, TransportService transportService, Map<String, GenericAction> actions) {
            for (GenericAction action : actions.values()) {
                if (!(action instanceof Action)) continue;
                this.proxies.put((Action)action, new TransportActionNodeProxy(settings, action, transportService));
            }
        }

        public Map<Action, TransportActionNodeProxy> getProxies() {
            return this.proxies;
        }
    }

    public static class Builder {
        private Settings settings = Settings.EMPTY;
        private List<Class<? extends Plugin>> pluginClasses = new ArrayList<Class<? extends Plugin>>();

        public Builder settings(Settings.Builder settings) {
            return this.settings(settings.build());
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder addPlugin(Class<? extends Plugin> pluginClass) {
            this.pluginClasses.add(pluginClass);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public TransportClient build() {
            Settings transportClientSettings = Settings.settingsBuilder().put("transport.ping.schedule", this.settings.get("ping.interval", "30s")).put(InternalSettingsPreparer.prepareSettings((Settings)this.settings)).put("network.server", false).put("node.client", true).put("client.type", TransportClient.CLIENT_TYPE).build();
            PluginsService pluginsService = new PluginsService(transportClientSettings, null, null, this.pluginClasses);
            this.settings = pluginsService.updatedSettings();
            Version version = Version.CURRENT;
            ThreadPool threadPool = new ThreadPool(transportClientSettings);
            boolean success = false;
            try {
                ModulesBuilder modules = new ModulesBuilder();
                modules.add(new Module[]{new Version.Module(version)});
                for (Module pluginModule : pluginsService.nodeModules()) {
                    modules.add(new Module[]{pluginModule});
                }
                modules.add(new Module[]{new PluginsModule(pluginsService)});
                modules.add(new Module[]{new SettingsModule(this.settings)});
                modules.add(new Module[]{new NetworkModule()});
                modules.add(new Module[]{new ClusterNameModule(this.settings)});
                modules.add(new Module[]{new ThreadPoolModule(threadPool)});
                modules.add(new Module[]{new TransportModule(this.settings)});
                modules.add(new Module[]{new TransportSearchModule()});
                modules.add(new Module[]{new ActionModule(true)});
                modules.add(new Module[]{new ClientTransportModule()});
                modules.add(new Module[]{new CircuitBreakerModule(this.settings)});
                pluginsService.processModules((Iterable)modules);
                Injector injector = modules.createInjector();
                ((TransportService)injector.getInstance(TransportService.class)).start();
                TransportClient transportClient = new TransportClient(injector);
                success = true;
                TransportClient transportClient2 = transportClient;
                return transportClient2;
            }
            finally {
                if (!success) {
                    ThreadPool.terminate((ThreadPool)threadPool, (long)10L, (TimeUnit)TimeUnit.SECONDS);
                }
            }
        }
    }
}

